/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import oracle.dbtools.raptor.newscriptrunner.util.parser.Expression;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ExpressionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.GrammarBuildContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedExpressionVisitor;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Syntax;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;

public class QMarkBuilder
extends ExpressionBuilder {
    private final Transformer<Node, ?> transformer;
    private final ExpressionBuilder item;

    protected QMarkBuilder(Transformer<Node, ?> transformer, ExpressionBuilder item) {
        this.transformer = transformer;
        this.item = item;
    }

    @Override
    protected Expression build(GrammarBuildContext context) {
        return context.compose(new QMark(context, this));
    }

    private static class QMark
    implements Expression {
        private final Transformer<Node, ?> transformer;
        private final Expression item;

        QMark(GrammarBuildContext context, QMarkBuilder builder) {
            this.transformer = builder.transformer;
            this.item = builder.item.build(context);
        }

        @Override
        public Syntax getSyntax() {
            StringBuilder buff = new StringBuilder();
            Syntax itemSyntax = this.item.getSyntax();
            if (itemSyntax.bracketIfNested()) {
                buff.append('(');
            }
            buff.append(itemSyntax.get());
            if (itemSyntax.bracketIfNested()) {
                buff.append(')');
            }
            buff.append('?');
            return new Syntax(buff.toString(), false);
        }

        @Override
        public void visitNamedExpressions(NamedExpressionVisitor visitor) {
            this.item.visitNamedExpressions(visitor);
        }

        @Override
        public void parse(Node node) {
            Node childNode = node.createChildContext(this.item);
            this.item.parse(childNode);
            node.mergeCompletions(childNode.getCompletions());
            node.mergeSemanticErrors(childNode.getSemanticErrors());
            node.mergeParseError(childNode.getParseError());
            if (childNode.isMatched()) {
                node.addChildNode(childNode);
                node.setValueFrom(childNode, this.transformer);
            }
            node.setMatched();
        }

        public String toString() {
            return "QMARK";
        }
    }
}

