/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Expression;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ExpressionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.GrammarBuildContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedExpressionVisitor;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Syntax;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;

public final class PlusBuilder
extends ExpressionBuilder {
    private final Transformer<List<Node>, ?> transformer;
    private final ExpressionBuilder item;

    protected PlusBuilder(Transformer<List<Node>, ?> transformer, ExpressionBuilder item) {
        this.transformer = transformer;
        this.item = item;
    }

    @Override
    protected Expression build(GrammarBuildContext context) {
        return context.compose(new Plus(context, this));
    }

    private static class Plus
    implements Expression {
        private final Transformer<List<Node>, ?> transformer;
        private final Expression item;

        Plus(GrammarBuildContext context, PlusBuilder builder) {
            this.transformer = builder.transformer;
            this.item = builder.item.build(context);
        }

        @Override
        public Syntax getSyntax() {
            StringBuilder buff = new StringBuilder();
            Syntax itemSyntax = this.item.getSyntax();
            if (itemSyntax.bracketIfNested()) {
                buff.append('(');
            }
            buff.append(itemSyntax.get());
            if (itemSyntax.bracketIfNested()) {
                buff.append(')');
            }
            buff.append('+');
            return new Syntax(buff.toString(), false);
        }

        @Override
        public void visitNamedExpressions(NamedExpressionVisitor visitor) {
            this.item.visitNamedExpressions(visitor);
        }

        @Override
        public void parse(Node node) {
            boolean matched;
            Node childNode;
            boolean matchedOne = false;
            do {
                childNode = node.createChildContext(this.item);
                this.item.parse(childNode);
                matched = childNode.isMatched();
                node.mergeParseError(childNode.getParseError());
                node.mergeCompletions(childNode.getCompletions());
                if (!matchedOne || matched) {
                    node.mergeSemanticErrors(childNode.getSemanticErrors());
                }
                if (!matched) break;
                matchedOne = true;
                node.addChildNode(childNode);
            } while (!childNode.isEmpty() && matched);
            if (matchedOne) {
                node.setValueFrom(node.getChildNodes(), this.transformer);
                node.setMatched();
            }
        }

        public String toString() {
            return "PLUS";
        }
    }
}

