/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Synonyms;

class NamePropertiesBuilder {
    private String name;
    private List<String> abbrevs;
    private String helpId;
    private boolean helpIdSet;

    NamePropertiesBuilder() {
    }

    void setName(String name) {
        this.name = name;
    }

    void setAbbrevs(String ... abbrevs) {
        this.abbrevs = Arrays.asList(abbrevs);
    }

    void setHelpId(String helpId) {
        this.helpId = helpId;
        this.helpIdSet = true;
    }

    NameProperties build(boolean hasSynonyms) {
        return this.build(null, hasSynonyms);
    }

    NameProperties build(Id id, boolean hasSynonyms) {
        return new NameProperties(this.name, this.abbrevs, this.helpId, this.helpIdSet, id, hasSynonyms);
    }

    static class NameProperties {
        private final String name;
        private final Optional<String> helpIdOpt;
        private final Synonyms synonyms;
        private static final Pattern NAME_PATTERN = Pattern.compile("((?:\\\\\\'|[^'])+)(?:\\'(.*))?");

        private NameProperties(String rawName, List<String> abbrevs, String helpId, boolean helpIdSet, Id id, boolean hasSynonyms) {
            String[] normalizedNameParts = this.normalizedSplitName(rawName, hasSynonyms, id);
            this.name = normalizedNameParts[1];
            this.helpIdOpt = Optional.ofNullable(this.normalizedHelpId(helpId, this.name, helpIdSet, id));
            this.synonyms = hasSynonyms ? new Synonyms(this.name, normalizedNameParts[0], this.normalizedAbbrevs(abbrevs)) : null;
        }

        Synonyms getSynonyms() {
            return this.synonyms;
        }

        String getName() {
            return this.name;
        }

        Optional<String> getHelpId() {
            return this.helpIdOpt;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String[] normalizedSplitName(String rawName, boolean hasSynonyms, Id id) {
            String[] result = new String[2];
            if (rawName == null) {
                rawName = id.getName();
            }
            if (hasSynonyms) {
                Object fullName;
                String nameRoot;
                Matcher lineMatcher = NAME_PATTERN.matcher(rawName);
                if (!lineMatcher.matches()) throw new IllegalArgumentException("name is invalid: " + rawName);
                if (lineMatcher.group(2) == null) {
                    nameRoot = null;
                    fullName = lineMatcher.group(1).replace("\\'", "'").toUpperCase();
                } else {
                    nameRoot = lineMatcher.group(1).replace("\\'", "'").toUpperCase();
                    fullName = nameRoot + lineMatcher.group(2).replace("\\'", "'").toUpperCase();
                }
                result[0] = nameRoot;
                result[1] = fullName;
                return result;
            } else {
                result[0] = null;
                result[1] = rawName != null ? rawName.toUpperCase() : null;
            }
            return result;
        }

        private String normalizedHelpId(String helpId, String normalizedName, boolean helpIdSet, Id id) {
            if (helpId != null) {
                return helpId.toUpperCase();
            }
            if (!helpIdSet) {
                if (id != null) {
                    return id.getHelpId();
                }
                return normalizedName;
            }
            return null;
        }

        private List<String> normalizedAbbrevs(List<String> abbrevs) {
            if (abbrevs != null) {
                ArrayList<String> upperAbbrevs = new ArrayList<String>();
                for (String abbrev : abbrevs) {
                    upperAbbrevs.add(abbrev.toUpperCase());
                }
                return Collections.unmodifiableList(upperAbbrevs);
            }
            return Collections.EMPTY_LIST;
        }
    }
}

