/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.help;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StructuredHelpPage {
    private final String content;
    private final Map<String, Integer> linePositions;

    public StructuredHelpPage(String content, Map<String, Integer> linePositions) {
        this.content = Objects.requireNonNull(content, "help page content cannot be null");
        this.linePositions = linePositions != null ? Collections.unmodifiableMap(linePositions) : Collections.emptyMap();
    }

    public String getContent() {
        return this.content;
    }

    public Optional<Integer> getSectionLineNumber(String tag) {
        if (tag == null) {
            return Optional.empty();
        }
        String current = tag.toUpperCase();
        while (!current.isEmpty()) {
            if (this.linePositions.containsKey(current)) {
                return Optional.ofNullable(this.linePositions.get(current));
            }
            int lastSlash = current.lastIndexOf(47);
            if (lastSlash < 0) break;
            current = current.substring(0, lastSlash);
        }
        return Optional.empty();
    }
}

