/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.parameterparser.validators;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.ParmResources;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Queries.ValidatorQuery;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ConnectionNotValidException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;

public abstract class AbstractValidatorService<T> {
    T parmValue;
    List<T> allowedValues = new ArrayList<T>();
    Boolean allowNull = false;
    String pName;
    Connection _conn;
    ScriptRunnerContext _ctx;
    String dateFmtStr;

    public boolean isListType() {
        return false;
    }

    public void advancedCheck() throws ParameterFailedValidationException, ConnectionNotValidException {
        if (this.allowedValues != null && this.allowedValues.size() > 0) {
            for (T e : this.allowedValues) {
                String p;
                String s;
                if (!(e instanceof String && this.parmValue instanceof String ? (s = (String)e).equalsIgnoreCase(p = (String)this.parmValue) : e.equals(this.parmValue))) continue;
                return;
            }
            throw new ParameterFailedValidationException(ParmResources.format("BAD_VAL_PARM", this.parmValue, this.pName));
        }
    }

    protected String executeQuery(Connection conn, String queryId, Map<String, String> binds) throws SQLException, ParameterFailedValidationException, ConnectionNotValidException {
        if (conn == null) {
            throw new ConnectionNotValidException(ParmResources.format("CONN_REQ", new Object[0]));
        }
        String query = ValidatorQuery.getQuery(queryId, conn);
        DBUtil dBUtil = DBUtil.getInstance(conn);
        String result = dBUtil.executeReturnOneCol(query, binds);
        SQLException e = dBUtil.getLastException();
        if (e != null) {
            if (e.getErrorCode() == 44001) {
                throw new ParameterFailedValidationException(ParmResources.format("BAD_VAL_PARM", this.parmValue, this.pName));
            }
            if (e.getErrorCode() == 17008) {
                throw new ConnectionNotValidException(ParmResources.format("CONN_CLOSED", this.pName));
            }
            String message = ParmResources.getString("SQL_ERR_MESSAGE");
            throw new SQLException(message, e);
        }
        return result;
    }

    protected String executeQuery(Connection conn, String queryId, String bind) throws SQLException, ParameterFailedValidationException, ConnectionNotValidException {
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("VALUE", bind);
        return this.executeQuery(conn, queryId, binds);
    }

    protected void existsQuery(Connection conn, String queryId, Map<String, String> binds) throws SQLException, ParameterFailedValidationException, ConnectionNotValidException {
        String result = this.executeQuery(conn, queryId, binds);
        if (result == null || result.equals("0")) {
            throw new ParameterFailedValidationException(ParmResources.format("BAD_VAL_PARM", this.parmValue, this.pName));
        }
    }

    protected void existsQuery(Connection conn, String queryId, String bind) throws SQLException, ParameterFailedValidationException, ConnectionNotValidException {
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("VALUE", bind);
        this.existsQuery(conn, queryId, binds);
    }

    public T getCleanParm(String value) throws ParameterFailedValidationException {
        if (value == null) {
            return null;
        }
        value = this.isListType() ? value.trim().replaceAll("\"([^\"]*)\"", "$1") : value.trim().replaceAll("^\"|\"$", "");
        return this.getParameter(value);
    }

    protected abstract T getParameter(String var1) throws ParameterFailedValidationException;

    public abstract String parmToString();

    public void setupValidator(boolean allowNulls, String allowedValues, String dateFormat, String name, ScriptRunnerContext ctx) {
        this.allowNull = allowNulls;
        if (allowedValues != null) {
            this.allowedValues = this.StringToTypeList(allowedValues);
        }
        this.pName = name;
        this._conn = ctx.getCurrentConnection();
        this._ctx = ctx;
        this.dateFmtStr = dateFormat;
    }

    public abstract List<T> StringToTypeList(String var1);

    public void validate(String parmValue) throws ParameterFailedValidationException, ConnectionNotValidException {
        try {
            parmValue = parmValue.trim();
            this.parmValue = this.getCleanParm(parmValue);
        }
        catch (Exception e) {
            if (e instanceof ParameterFailedValidationException) {
                throw e;
            }
            throw new ParameterFailedValidationException(this.pName, e);
        }
        if (!this.allowNull.booleanValue() && parmValue == null) {
            throw new ParameterFailedValidationException(ParmResources.format("BAD_VAL_PARM", "NULL", this.pName));
        }
        if (this.allowNull.booleanValue() && parmValue == null) {
            return;
        }
        this.advancedCheck();
    }
}

