/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.FlagProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ParseConnectionSpecArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.AbstractConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NameProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.PasswordProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.ReplaceFlag;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.SavePasswordFlag;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.UserProperty;

public abstract class StandardFormConnectorType
extends AbstractConnectorType {
    protected StandardFormConnectorType(FlagProperty selector) {
        this(selector, true);
    }

    protected StandardFormConnectorType(FlagProperty selector, boolean addDefaultProperties) {
        super(selector);
        if (addDefaultProperties) {
            this.addProperty(UserProperty.USER);
            this.addProperty(PasswordProperty.PASSWORD);
            this.addProperty(URLProperty.URL);
            this.addProperty(ReplaceFlag.REPLACE);
            this.addProperty(NameProperty.SAVE);
            this.addProperty(SavePasswordFlag.SAVEPWD);
        }
    }

    protected static boolean isNotEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    protected static boolean isNotEmpty(TextSecret secret) {
        return secret != null && secret.isPresent();
    }

    protected static ConnectionDetails createConnectDetails(ParseConnectionSpecArgs args) {
        return ScriptUtils.getConnectionDetails("connect " + args.getConnectionSpec());
    }

    @Override
    public void parseConnectionSpec(ParseConnectionSpecArgs args) {
        super.parseConnectionSpec(args);
    }
}

