/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import oracle.dbtools.core.connections.helpers.ConnectCredentials;
import oracle.dbtools.core.connections.helpers.ConnectionHelper;
import oracle.dbtools.core.connections.helpers.ConnectionHelperContext;
import oracle.dbtools.core.connections.helpers.ConnectionHelperFactory;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.core.util.DbtoolsException;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.plusplus.util.CommandContext;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NamedConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleStandardFormConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.StandardFormConnector;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;
import oracle.dbtools.raptor.utils.TNSHelper;

public class NamedConnectionsConnector
extends StandardFormConnector {
    private final ConnectionHelper creator;
    private final String name;

    static ConnectionDefinition lookupDefinition(String name) {
        ConnectionStorage fileSystem = ConnectionStorage.instance();
        Optional<ConnectionDefinition> opt = fileSystem.listConnectionDirectories().stream().map(arg_0 -> ((ConnectionStorage)fileSystem).loadConnection(arg_0)).filter(def -> Objects.equals(def.getConnectionName(), name)).findFirst();
        return opt.orElse(null);
    }

    NamedConnectionsConnector(ConnectorArgs args) {
        super(args);
        CommandContext cmdCtx = CommandContext.of(args.getScriptRunnerContext(), ConnectCommand.class);
        this.name = args.getPropertyValues().getValueOf(NamedConnectionProperty.NAME);
        ConnectionDefinition def = NamedConnectionsConnector.lookupDefinition(this.name);
        this.creator = def != null ? ConnectionHelperFactory.findHelper((ConnectionHelperContext)ConnectionHelperContext.of((ConnectionDefinition)def, (MessageLogger)cmdCtx.getMessageLogger())) : ConnectionHelperFactory.createFallbackHelper();
    }

    @Override
    protected boolean completeConnectionDetails(Connection conn, ConnectionDetails cd) {
        ConnectionDetails updatedDetails;
        ConnectCredentials credentials = this.creator.getCredentials();
        String storedUser = credentials.getUsername();
        TextSecret storedPwd = credentials.getPassword();
        String role = credentials.getRole();
        String overrideUser = cd.getConnectName();
        TextSecret overridePassword = cd.getConnectPassword();
        boolean prompt = true;
        if (overrideUser == null || overrideUser.isEmpty()) {
            if (overridePassword.isPresent()) {
                if (storedUser != null) {
                    cd.setConnectName(storedUser);
                } else {
                    prompt = this.creator.requiresUsername();
                }
            } else {
                if (storedUser != null) {
                    cd.setConnectName(storedUser);
                }
                if (storedPwd.isPresent()) {
                    cd.setConnectPassword(storedPwd);
                }
                boolean bl = prompt = this.creator.requiresUsername() || this.creator.requiresPassword();
            }
            if (role != null && !role.isEmpty()) {
                cd.setRole("as " + role);
            }
            cd.setConnectDB(this.name);
        }
        if (prompt && (updatedDetails = this.ctx.getConnectFieldsProvider().get3Fields(this.ctx, cd, false)) != null) {
            cd.cloneFrom(updatedDetails);
        }
        return true;
    }

    @Override
    protected StandardFormConnector.ConnectionRec createConnection(List<String> urlMessage, String connectName, TextSecret connectPassword, String connectDB, String role) {
        String feedback;
        Connection conn;
        block13: {
            String tnsNamesDir;
            Properties props = new Properties();
            props.setProperty("v$session.program", SQLPLUSUtil.getProductName());
            Properties globalProps = (Properties)this.ctx.getProperty("sqlcl.global.conn.props");
            if (globalProps != null) {
                for (String key : globalProps.stringPropertyNames()) {
                    props.setProperty(key, globalProps.getProperty(key));
                }
            }
            if ((tnsNamesDir = TNSHelper.getTnsnamesDir()) != null) {
                props.setProperty("oracle.net.tns_admin", tnsNamesDir);
            }
            String realRole = null;
            if (role != null && !role.isEmpty()) {
                if (OracleStandardFormConnector.isValidRole(role)) {
                    realRole = role;
                } else {
                    String[] retVal = SQLPLUSUtil.nextWordAndRest(role);
                    if ("AS".equalsIgnoreCase(retVal[0])) {
                        realRole = OracleStandardFormConnector.isValidRole(retVal[1]) ? retVal[1] : null;
                    }
                }
            }
            conn = null;
            feedback = null;
            try {
                conn = this.creator.createConnection(ConnectCredentials.of((String)connectName, (TextSecret)connectPassword, (String)realRole), props);
            }
            catch (SQLException | DbtoolsException ex) {
                feedback = ex.getLocalizedMessage();
                if (feedback != null) break block13;
                feedback = ex.getMessage();
            }
        }
        if (conn == null) {
            if (feedback != null) {
                // empty if block
            }
            if (!this.ctx.isSQLPlusClassic()) {
                urlMessage.add(ScriptRunnerDbArb.format("URL_MESSAGE", connectName, connectDB, feedback));
            } else {
                SQLPLUSUtil.classicUrlMessageAdd(urlMessage, connectName, connectDB, feedback);
            }
        }
        return new StandardFormConnector.ConnectionRec(this, conn);
    }
}

