/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connect;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import oracle.dbtools.raptor.newscriptrunner.ICommandHistory;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Connector;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorTypeCache;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.RawPropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.SetType;

class ConnectionContextProvider
implements ConnectionContext {
    private static final String BASE64_PREFIX = "base64:";
    private final ConnectorTypeCache connectorTypeCache;
    private final ScriptRunnerContext runnerContext;
    private final PropertyValues contextPropertyValues;
    private ConnectorType currentConnectorType;
    private String currentConnectionSpec;
    private PropertyValues currentPropertyValues;
    private ISQLCommand currentCommand;

    ConnectionContextProvider(ConnectorTypeCache connectorTypeCache, ScriptRunnerContext runnerContext) {
        this.connectorTypeCache = connectorTypeCache;
        this.runnerContext = runnerContext;
        this.contextPropertyValues = new ModifiablePropertyValuesImpl();
    }

    @Override
    public PropertyValues getContextPropertyValues() {
        return this.contextPropertyValues;
    }

    @Override
    public ConnectorType getCurrentConnectorType() {
        return this.currentConnectorType;
    }

    @Override
    public void setCurrentConnectorType(ConnectorType currentConnectorType) {
        this.currentConnectorType = currentConnectorType;
    }

    @Override
    public String getCurrentConnectionSpec() {
        return this.currentConnectionSpec;
    }

    @Override
    public void setCurrentConnectionSpec(String currentConnectionSpec) {
        this.currentConnectionSpec = currentConnectionSpec;
    }

    @Override
    public PropertyValues getCurrentPropertyValues() {
        return this.currentPropertyValues != null ? this.currentPropertyValues : this.getContextPropertyValues();
    }

    @Override
    public void setCurrentPropertyValues(PropertyValues currentPropertyValues) {
        this.currentPropertyValues = currentPropertyValues;
    }

    @Override
    public ISQLCommand getCurrentCommand() {
        return this.currentCommand;
    }

    @Override
    public void setCurrentCommand(ISQLCommand currentCommand) {
        this.currentCommand = currentCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection cloneCurrentConnection(BiConsumer<ConnectionProperty, String> propertyConsumer) {
        Connection clonedConnection = null;
        if (this.currentConnectorType != null) {
            ICommandHistory history = (ICommandHistory)this.runnerContext.getProperty("sqlcl.ihistorycommand");
            boolean wasDisabled = false;
            if (history != null) {
                wasDisabled = history.isDisabled();
                history.setDisabled(true);
            }
            try {
                Connector connector = this.currentConnectorType.createConnector(ConnectorArgs.create(this.currentConnectionSpec, this.currentPropertyValues, this.runnerContext, this.currentCommand, propertyConsumer));
                clonedConnection = connector.connect();
            }
            finally {
                if (history != null) {
                    history.setDisabled(wasDisabled);
                }
            }
        } else {
            propertyConsumer.accept(ConnectionProperty.ERROR_MESSAGE, Messages.getString(Messages.Key.NO_CONNECTION_TO_CLONE));
        }
        return clonedConnection;
    }

    private class ModifiablePropertyValuesImpl
    implements PropertyValues {
        private final Map<Property<?>, Object> valueMap;

        ModifiablePropertyValuesImpl() {
            this.valueMap = new HashMap();
            for (String propertyName : ConnectionContextProvider.this.connectorTypeCache.getPropertyNames()) {
                Property property = ConnectionContextProvider.this.connectorTypeCache.getProperty(propertyName);
                this.valueMap.put(property, property.getInitialValue());
            }
        }

        ModifiablePropertyValuesImpl(ModifiablePropertyValuesImpl propertyValues) {
            this.valueMap = new HashMap(propertyValues.valueMap);
        }

        @Override
        public PropertyValues createCopy() {
            return new ModifiablePropertyValuesImpl(this);
        }

        @Override
        public <T> void setValueOf(Property<T> property, Object value) {
            this.valueMap.put(property, value);
        }

        @Override
        public <T> T getValueOf(Property<T> property) {
            return (T)this.valueMap.get(property);
        }

        @Override
        public String asStringFor(ConnectorType connectorType, String separator) {
            StringBuilder buff = new StringBuilder();
            buff.append("type: ").append(connectorType.getName());
            for (Property<?> property : connectorType.getProperties()) {
                Object value;
                if (property.isRedacted() || (value = this.getValueOf(property)) == null || value.toString().isBlank()) continue;
                buff.append(separator).append(property.getName().toLowerCase()).append(": ").append(value.toString());
            }
            return buff.toString();
        }

        @Override
        public String loadFromArgs(String[] args) {
            StringBuilder buff = new StringBuilder();
            TreeMap<String, Object> rawValuesMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            for (int argNo = 0; argNo < args.length; ++argNo) {
                String name;
                Property property;
                String arg = args[argNo];
                if (!arg.startsWith("-") || (property = ConnectionContextProvider.this.connectorTypeCache.getProperty(name = arg.substring(1))) == null) continue;
                if (property.isFlag()) {
                    if (property.getSetType() != SetType.CONFIGURATION) {
                        if (buff.length() > 0) {
                            buff.append(" ");
                        }
                        buff.append(arg);
                    }
                    rawValuesMap.put(name, "true");
                    continue;
                }
                if (argNo + 1 >= args.length) continue;
                Object value = args[argNo + 1];
                if (property.getSetType() != SetType.CONFIGURATION) {
                    if (buff.length() > 0) {
                        buff.append(" ");
                    }
                    if (((String)value).startsWith(ConnectionContextProvider.BASE64_PREFIX) && ((String)value).length() > ConnectionContextProvider.BASE64_PREFIX.length()) {
                        String encodedStr = ((String)value).substring(ConnectionContextProvider.BASE64_PREFIX.length());
                        value = new String(Base64.getDecoder().decode(encodedStr));
                    }
                    if (((String)value).length() > 2 && ((String)value).matches("[^\\s]*\\s.*")) {
                        boolean quoted;
                        char firstChar = ((String)value).charAt(0);
                        char lastChar = ((String)value).charAt(((String)value).length() - 1);
                        boolean bl = quoted = firstChar == '\"' && lastChar == '\"' || firstChar == '\'' && lastChar == '\'';
                        if (!quoted) {
                            value = "\"" + (String)value + "\"";
                        }
                    }
                    buff.append(arg).append(" ").append((String)value);
                }
                rawValuesMap.put(name, value);
            }
            RawPropertyValues rawValues = RawPropertyValues.create(rawValuesMap);
            ArrayList errors = new ArrayList();
            for (String name : rawValuesMap.keySet()) {
                Property property = ConnectionContextProvider.this.connectorTypeCache.getProperty(name);
                if (property == null || property.getSetType() == SetType.NONE) continue;
                Object value = property.createValue(ConnectionContextProvider.this.runnerContext, rawValues, errors::add);
                this.setValueOf(property, value);
            }
            for (String error : errors) {
                System.out.println(error + "\n");
            }
            if (!errors.isEmpty()) {
                return null;
            }
            return buff.toString();
        }
    }
}

