/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetXMLFormat
extends CommandListener
implements IShowCommand {
    String[] aliases = new String[]{"xmlformat", "xmlfo", "xmlfor", "xmlform", "xmlforma"};

    @Override
    public String[] getShowAliases() {
        return this.aliases;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getProperty("script.runner.set_xmlformat") != null) {
            String on = "OFF";
            boolean x = (Boolean)ctx.getProperty("script.runner.set_xmlformat");
            on = x ? "ON" : "OFF";
            ctx.write(MessageFormat.format("xmlformat is {0}\n", on));
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String sql = cmd.getSql();
        String[] tokens = sql.split("\\s+");
        if (tokens.length != 3) {
            ctx.write("SP2-0265: xmlformat must be set ON or OFF\n");
        } else {
            String token = tokens[2];
            if (token.toLowerCase().equals("on") || token.toLowerCase().equals("off")) {
                boolean x = token.toLowerCase().equals("on") ? Boolean.TRUE : Boolean.FALSE;
                ctx.putProperty("script.runner.set_xmlformat", x);
            } else {
                ctx.write("SP2-0265: xmlformat must be set ON or OFF\n");
            }
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

