/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class SetMaxRows
extends CommandListener
implements IShowCommand {
    public static final String S_MAXROWS = "maxrows";
    public static final String S_MAXROWSSPOOLTRUNCATE = "maxspoolrowstruncate";

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String lowertrim = cmd.getLoweredTrimmedNoWhitespaceSQL();
        if (lowertrim.startsWith("setmaxrows")) {
            block7: {
                String[] parts = cmd.getLoweredTrimmedSQL().split("\\s+");
                if (parts.length == 3 && parts[2].equalsIgnoreCase("default")) {
                    ctx.write(MessageFormat.format(Messages.getString("MAXROWSCLEARED"), S_MAXROWS));
                    ctx.putProperty("sqlcl.script.maxrows", null);
                    return true;
                }
                if (parts.length == 3) {
                    int newSetting = 0;
                    try {
                        newSetting = Integer.parseInt(parts[2]);
                        if (newSetting < 2) {
                            this.usage(ctx, cmd, conn);
                            break block7;
                        }
                        ctx.putProperty("sqlcl.script.maxrows", new Integer(newSetting));
                    }
                    catch (NumberFormatException e) {
                        this.usage(ctx, cmd, conn);
                    }
                } else {
                    this.usage(ctx, cmd, conn);
                }
            }
            return true;
        }
        return false;
    }

    public void usage(ScriptRunnerContext ctx, ISQLCommand cmd, Connection conn) {
        ctx.write(MessageFormat.format(Messages.getString("MAXROWSUSAGE"), S_MAXROWS));
        ScriptUtils.doWhenever(ctx, cmd, conn, true);
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String format = null;
        format = ctx.getProperties().containsKey("sqlcl.script.maxrows") && ctx.getProperties().get("sqlcl.script.maxrows") != null ? ((Integer)ctx.getProperties().get("sqlcl.script.maxrows")).toString() : "Default";
        ctx.write("");
        ctx.write(MessageFormat.format(Messages.getString("MAXROWS"), S_MAXROWS, format) + "\n");
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{S_MAXROWS};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

