/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.Substitution;

public class HostAliasCommand
extends CommandListener {
    private static final String CMD = "host";
    private static final Set<String> INTERACTIVE_COMMANDS = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        int hostReturn;
        block73: {
            String[] stArray;
            String newCommand;
            hostReturn = 0;
            Substitution sub = new Substitution(ctx);
            try {
                sub.replaceSubstitution(cmd);
            }
            catch (Substitution.SubstitutionException substitutionException) {
                // empty catch block
            }
            String command = cmd.getSql().trim();
            ArrayList<String> cmdTokens = new ArrayList<String>();
            boolean hostRemoved = false;
            if (command.startsWith("!") && !(newCommand = command.replaceFirst("\\!|host|hos|ho", "")).equals(command)) {
                hostRemoved = true;
                command = newCommand;
            }
            if (!hostRemoved) {
                StringTokenizer st = new StringTokenizer(command);
                if (command.toLowerCase().startsWith(CMD) || command.toLowerCase().startsWith("hos") || command.toLowerCase().startsWith("ho")) {
                    String host = st.nextToken();
                    command = command.replaceFirst(host, "");
                }
            }
            Object addPath = "";
            if (System.getProperty("os.name").toLowerCase().indexOf("win") <= -1) {
                try {
                    String pwd = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
                    addPath = " export PATH=\"" + pwd + ":$PATH\" && ";
                }
                catch (Exception e) {
                    ctx.write(e.getMessage() + "\n");
                }
            }
            command = command.trim();
            if ((command = ScriptUtils.checkforContinuationChars(command)).trim().equals("")) {
                if (System.getProperty("os.name").toLowerCase().indexOf("win") > -1) {
                    cmdTokens.add("cmd.exe");
                } else {
                    cmdTokens.add("bash");
                    cmdTokens.add("-c");
                    cmdTokens.add("SQLCLTERM=`stty -g 2>/dev/null` && stty sane 2>/dev/null && " + (String)addPath + "bash -l ; SQLCLEXIT=$? && if test \"M$SQLCLTERM\" != \"M\" ; then stty \"$SQLCLTERM\" 2>/dev/null; fi; exit $SQLCLEXIT");
                }
            } else if (System.getProperty("os.name").toLowerCase().indexOf("win") > -1) {
                cmdTokens.add("cmd.exe");
                cmdTokens.add("/C");
                cmdTokens.add(command);
            } else if (HostAliasCommand.isInteractiveCommand(command)) {
                cmdTokens.add("bash");
                cmdTokens.add("-c");
                cmdTokens.add("SQLCLTERM=`stty -g 2>/dev/null` ; stty sane 2>/dev/null; " + (String)addPath + command + " < /dev/tty >  /dev/tty 2>&1 ; SQLCLEXIT=$? ; if test \"M$SQLCLTERM\" != \"M\" ; then stty \"$SQLCLTERM\" 2>/dev/null ; fi; exit  $SQLCLEXIT");
            } else {
                cmdTokens.add("bash");
                cmdTokens.add("-c");
                cmdTokens.add("SQLCLTERM=`stty -g 2>/dev/null` ; stty sane 2>/dev/null; " + (String)addPath + command + "; SQLCLEXIT=$? ; if test \"M$SQLCLTERM\" != \"M\" ; then stty \"$SQLCLTERM\" 2>/dev/null ; fi; exit  $SQLCLEXIT");
            }
            ProcessBuilder builder = new ProcessBuilder(cmdTokens);
            builder.directory(new File(FileUtils.getSQLPath(ctx)[0]));
            String changepwd = (String)ctx.getProperty("script.runner.cd_command");
            if (changepwd != null && (stArray = changepwd.split(File.pathSeparator)) != null && stArray.length > 0 && stArray[0] != null && new File(stArray[0]).isDirectory()) {
                changepwd = stArray[0];
                builder.directory(new File(stArray[0]));
            }
            BufferedInputStream bis = null;
            FilterOutputStream bos = null;
            ByteArrayOutputStream bufferStore = null;
            try {
                int x;
                Process process;
                builder.redirectErrorStream(true);
                if (ctx.getProperty("script.runner.jline") != null) {
                    int x2;
                    if (HostAliasCommand.isInteractiveCommand(command)) {
                        builder.inheritIO();
                    }
                    process = builder.start();
                    try (BufferedReader out = new BufferedReader(new InputStreamReader(process.getInputStream()));
                         BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                        String line;
                        while (process.isAlive()) {
                            while (out.ready() && (line = out.readLine()) != null) {
                                ctx.writeln(line);
                            }
                            while (err.ready() && (line = err.readLine()) != null) {
                                ctx.writeln(line);
                            }
                            Thread.sleep(10L);
                        }
                        while (out.ready() && (line = out.readLine()) != null) {
                            ctx.writeln(line);
                        }
                        while (err.ready() && (line = err.readLine()) != null) {
                            ctx.writeln(line);
                        }
                    }
                    hostReturn = x2 = process.waitFor();
                    ctx.getMap().put("_RC", String.valueOf(x2));
                    break block73;
                }
                File tmpInput = null;
                try {
                    tmpInput = File.createTempFile("sqldhost", null);
                    tmpInput.deleteOnExit();
                    builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
                    builder.redirectInput(ProcessBuilder.Redirect.from(tmpInput));
                    process = builder.start();
                    try {
                        int bufSize = 4096;
                        bis = new BufferedInputStream(process.getInputStream(), bufSize);
                        bufferStore = new ByteArrayOutputStream();
                        bos = new BufferedOutputStream(bufferStore);
                        byte[] buffer = new byte[bufSize];
                        boolean written = false;
                        String afterMessage = null;
                        while (true) {
                            int len = 0;
                            boolean readAlready = false;
                            try {
                                process.exitValue();
                            }
                            catch (IllegalThreadStateException e) {
                                readAlready = true;
                                len = bis.read(buffer, 0, Math.min(bufSize, bis.available()));
                                if (len == -1) break;
                            }
                            if (!readAlready && (len = bis.read(buffer, 0, bufSize)) == -1) break;
                            ((BufferedOutputStream)bos).write(buffer, 0, len);
                            written = true;
                            Thread.sleep(200L);
                            if (ctx.getTaskProgressUpdater() == null) continue;
                            try {
                                ctx.getTaskProgressUpdater().checkCanProceed();
                            }
                            catch (ExecutionException e) {
                                process.destroy();
                                if (e.getCause() != null) {
                                    afterMessage = e.getCause().getMessage() + "\n";
                                    continue;
                                }
                                afterMessage = e.getMessage() + "\n";
                            }
                        }
                        if (written) {
                            ((BufferedOutputStream)bos).flush();
                            ctx.write(bufferStore.toString());
                            ctx.getOutputStream().flush();
                        }
                        if (afterMessage != null) {
                            ctx.write(afterMessage);
                        }
                    }
                    finally {
                        try {
                            if (tmpInput != null) {
                                tmpInput.delete();
                            }
                        }
                        catch (Exception e) {
                            ctx.write(e.getLocalizedMessage().trim() + "\n");
                        }
                    }
                }
                finally {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                    if (bufferStore != null) {
                        try {
                            bufferStore.close();
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                    }
                }
                hostReturn = x = process.waitFor();
                ctx.getMap().put("_RC", String.valueOf(x));
            }
            catch (IOException e) {
                ctx.write(e.getMessage() + "\n");
            }
            catch (InterruptedException e) {
                ctx.write(e.getMessage() + "\n");
            }
        }
        ctx.write("\n");
        if (hostReturn != 0) {
            ScriptUtils.doWhenever(ctx, cmd, conn, false);
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.isCommandLine()) {
            ctx.getSQLPlusConsoleReader().pauseReader(true);
        }
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.isCommandLine()) {
            ctx.getSQLPlusConsoleReader().pauseReader(false);
        }
    }

    private static boolean isInteractiveCommand(String commandLine) {
        String[] tokens;
        if (commandLine == null || commandLine.trim().isEmpty()) {
            return false;
        }
        for (String token : tokens = commandLine.toLowerCase(Locale.ROOT).split("\\s+")) {
            String stripped = token.replaceAll("[^a-zA-Z0-9._-]", "");
            if (!INTERACTIVE_COMMANDS.contains(stripped)) continue;
            return true;
        }
        return false;
    }

    static {
        Collections.addAll(INTERACTIVE_COMMANDS, "vim", "vi", "nvim", "nano", "less", "more", "man", "top", "htop", "btop", "atop", "iotop", "watch", "mc", "ftp", "telnet", "mysql", "psql", "read", "bash", "sh", "zsh", "fish", "tmux", "screen", "fzf", "peco", "hx", "kak", "python", "node", "ruby", "cmd", "powershell", "choice", "pause", "diskpart", "chkdsk", "netsh", "set", "Read-Host", "ssh-add");
    }
}

