/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.plusplus.IBuffer;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.newscriptrunner.IGetHandlePauseProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedConnectFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedFieldProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedPasswordFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.IGetSpoolFilterProvider;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.IScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.JSONWrapBufferedOutputStream;
import oracle.dbtools.raptor.newscriptrunner.Messages;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.BottomTitle;
import oracle.dbtools.raptor.newscriptrunner.commands.SetSpool;
import oracle.dbtools.raptor.newscriptrunner.commands.TopTitle;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.console.IConsoleReader;
import oracle.dbtools.raptor.newscriptrunner.handlers.StandAloneHandlePauseProvider;
import oracle.dbtools.raptor.newscriptrunner.handlers.StandAloneHandleSetPauseProvider;
import oracle.dbtools.raptor.newscriptrunner.handlers.StandAlonePromptedAcceptProvider;
import oracle.dbtools.raptor.newscriptrunner.handlers.StandAlonePromptedConnectFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.handlers.StandAlonePromptedPasswordFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.handlers.StandAlonePromptedSubstitutionProvider;
import oracle.dbtools.raptor.newscriptrunner.restricted.RunnerRestrictedLevel;
import oracle.dbtools.raptor.newscriptrunner.util.container.Container;
import oracle.dbtools.raptor.newscriptrunner.util.container.ProviderFactory;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;
import oracle.dbtools.util.Encodings;
import oracle.dbtools.util.IExceptionHandler;
import oracle.dbtools.util.print.AnsiUtils;

public class ScriptRunnerContext
implements IScriptRunnerContext {
    public static final String ALWAYSUTF8 = "UTF-8";
    public static final String CLI_CONN_RESOLVER = "cli.conn.resolver";
    public static final String CLI_CONN_MGR = "cli.conn.mgr";
    public static final String CLI_CONN_NAME = "cli.conn.name";
    public static final String CLI_CONN_URL = "cli.conn.url";
    public static final String CLI_CONN_PROPS = "cli.conn.props";
    public static final String SQL_FORMAT = "sql.format";
    public static final String SQL_FORMAT_FULL = "sql.format.full";
    public static final String CLOUD_STORAGE = "cloud.storage";
    public static final String MIGRATEADVISOR = "migrate.advisor";
    public static final String DATAPUMP = "data.pump";
    public static final String LOAD_FORMAT = "load.format";
    public static final String LOAD_FORMAT_OPTIONS = "load.format.options";
    public static final String LOAD_METHOD = "load.method";
    public static final String LOAD_METHOD_INSERT = "load.method.insert";
    public static final String LOAD_METHOD_DBMS_CLOUD = "load.method.dbms_cloud";
    public static final String PRE_COMMAND = "pre.command";
    public static final String POST_COMMAND = "post.command";
    public static final String TOTAL_CMD_COUNT = "total_cmd_count";
    public static final String CURRENT_CMD_COUNT = "current_cmd_count";
    public static final String OUT_STREAM_WRAPPER = "output_stream_wrapper";
    public static final int FEEDBACK_ON = -1;
    public static final int FEEDBACK_OFF = -2;
    public static final int FEEDBACK_ONLY = -3;
    public static final int FEEDBACK_SQL_ID_ON = -10;
    public static final String LAST_ERR_TYPE = "sqldev.last.err.type";
    public static final String LAST_ERR_NAME = "sqldev.last.err.name";
    public static final String ERR_ANY_CMDS_IN_SCRIPT = "sqldev.error.any.in";
    public static final String ERR_ENCOUNTERED = "sqldev.error";
    public static final String ERR_MESSAGE = "sqldev.last.err.message";
    public static final String ERR_MESSAGE_SQLCODE = "sqldev.last.err.message.forsqlcode";
    public static final String TOP_BASE_URL = "script.runner.topbase.url";
    public static final String BASE_URL = "script.runner.base.url";
    public static final String NODE_URL = "script.runner.node.url";
    public static final String SYSTEM_OUT = "script.runner.using.systemout";
    public static final String DBCONFIG_GLOGIN = "DBConfig.GLOGIN";
    public static final String DBCONFIG_GLOGIN_FILE = "DBConfig.GLOGIN_FILE";
    public static final String DBCONFIG_DEFAULT_PATH = "DBConfig.DEFAULT_PATH";
    public static final String DBCONFIG_USE_THICK_DRIVER = "DBConfig.USE_THICK_DRIVER";
    public static final String SPOOLOUTBUFFER = "Spool.out.buffer";
    public static final String SPOOLOUTFILENAME = "Spool.out.filename";
    public static final String EXITCOMMIT = "script.runner.exitcommit";
    public static final String POPUPBINDS = "f9.popup.binds";
    public static final String APPINFO = "script.runner.appinfo";
    public static final String APPINFOSTRING = "script.runner.appinfostring";
    public static final String APPINFOARRAYLIST = "script.runner.appinfo.arraylist";
    public static final String ARRAYSIZE = "script.runner.arraysize";
    public static final String AUTOCOMMITCOUNTER = "script.runner.autocommit.counter";
    public static final String AUTOCOMMITSETTING = "script.runner.autocommit.setting";
    public static final String ERR_FOR_AUTOCOMMIT = "script.runner.autocommit.errorFlag";
    public static final String COPYCOMMIT = "script.runner.copycommit";
    public static final String CHECKBOXAUTOCOMMIT = "script.runner.autocommit.checkbox";
    public static final String LASTSETSERVEROUTPUT = "script.runner.lastsetserveroutput";
    public static final String REINIT_ON_EXIT = "script.runner.reinitOnExit";
    public static final String DBMSPUTPUTPANE = "script.runner.dbmsouputpane";
    public static final String RESULTS = "script.runner.results";
    public static final String IS_RESTRICTED = "script.runner.restricted";
    public static final String RESTRICTED_MSG = "script.runner.restricted.message";
    public static final Long AUTOCOMMITON = -1L;
    public static final Long AUTOCOMMITOFF = -2L;
    public static final int VERIFY_OFF = -3;
    public static final int VERIFY_ON = -4;
    public static final int AUTOPRINT_OFF = -5;
    public static final int AUTOPRINT_ON = -6;
    public static final String DBPROPS = "sqldev.script.runner.connection.properties";
    public static final String AUTOTRACE_CTXTRACESTATE = "AUTOTRACE_STATE";
    public static final String AUTOTRACE_CTXTRACETYPE = "AUTOTRACE_TYPE";
    public static final String AUTOTRACE_AUTO_EXPLAIN = "EXPLAIN";
    public static final String AUTOTRACE_AUTO_STAT = "STATISTICS";
    public static final String AUTOTRACE_AUTO_ALL = "ALL";
    public static final String AUTOTRACE_AUTO_NONE = "NONE";
    public static final String AUTOTRACE_TRACEONLY = "TRACEONLY";
    public static final String SHOWSERVEROUTPUT = "script.runner.context.serveroutput";
    public static final String SHOWTIMING = "script.runner.context.timing";
    public static final String SHOWAUTOPRINT = "script.runner.context.autoprint";
    public static final String SETNULL = "script.runner.setnull";
    public static final String SETNUMWIDTH = "script.runner.setnumwidth";
    public static final String SETNUMFORMAT = "script.runner.setnumformat";
    public static final String SETPAGESIZE = "script.runner.setpagesize";
    public static final String SETLINESIZE = "script.runner.setlinesize";
    public static final String SETLONG = "script.runner.setlong";
    public static final String SETLONGCHUNKSIZE = "script.runner.setlongchunksize";
    public static final String SETCOLSEP = "script.runner.setcolsep";
    public static final String SETHEADING = "script.runner.setheading";
    public static final String SETHEADSEP = "script.runner.setheadsep";
    public static final String SETHEADSEPCHAR = "script.runner.setheadsepchar";
    public static final String SETWRAP = "script.runner.setwrap";
    public static final String SETPRELIM = "script.runner.setprelim";
    public static final String SETSHOWMODE = "script.runner.setshowmode";
    public static final String SETDESCRIBE = "script.runner.setdescribe";
    public static final String SETSOURCEREF = "script.runner.sourceref";
    public static final String SETSCAN = "sql.scan";
    public static final String TTITLE_ON = "ON";
    public static final String TTITLE_OFF = "OFF";
    public static final String BTITLE_ON = "ON";
    public static final String BTITLE_OFF = "OFF";
    public static final String JLINE_SETTING = "script.runner.jline";
    public static final String NOTSYSDBA = "NOTSYSDBA";
    public static final String OPTLFLAG = "SqlCli.optlflag";
    public static final String SETTRIMSPOOL = "script.runner.settrimspool";
    public static final String SETTRIMOUT = "script.runner.settrimout";
    public static final String NOLOG = "script.runner.sqlplus.nolog";
    public static final String SILENT = "script.runner.sqlplus.silent";
    public static final String EXIT_INT = "script.runner.exit_int";
    public static final String EXIT_INT_WHENEVER = "script.runner.exit_int_whenever";
    public static final String EXIT_INT_WHENEVER_WAS_SQLCODE = "script.runner.exit_int_whenever.wassqlcode";
    public static final String SQLPLUS_CMDLINE_LOGIN = "script.runner.cmdline.login";
    public static final String BASECONNECTIONID = "script.runner.connection.id";
    public static final String SUFFIX = "script.runner.file.suffix";
    public static final String EDITFILE = "script.runner.file.editfile";
    public static final String SETCOLOR = "script.runner.color.coding";
    public static final String CDPATH = "script.runner.cd_command";
    public static final String SCRIPT_DEPTH = "script.runner.script_depth";
    public static final String LDAPCON = "script.runner.ldapcon";
    public static final String SETNET = "script.runner.setnet";
    public static final String SETNETOVERWRITE = "script.runner.setnetoverwrite";
    public static final String SQLPROMPTTIME = "script.runner.setsqlplustime";
    public static final String SERVEROUTPUTPENDING = "script.runner.serveroutputpending";
    public static final String SET_PAUSE = "script.runner.set_pause";
    public static final String SET_SECUREDCOL = "script.runner.set_securedcol";
    public static final String SET_SECUREDCOL_UNAUTH = "script.runner.set_securedcol_unauth";
    public static final String SET_SECUREDCOL_UNKNOWN = "script.runner.set_securedcol_unknown";
    public static final String SET_PAUSE_VALUE = "script.runner.set_pause_value";
    public static final String SET_SQLCODE = "script.runner.sqlcode";
    public static final String SET_OSCODE = "script.runner.oscode";
    public static final String SET_XMLFORMAT = "script.runner.set_xmlformat";
    public static final String SET_CLOSECURSOR = "script.runner.set_xmlformat";
    public static final String SET_SQLPLUSCOMPATIBILITY = "script.runner.set_sqlpluscompat";
    public static final String SET_PRINT_THEME = "script.runner.set_printtheme";
    public static final String LNO = "script.runner.lno";
    public static final String PNO = "script.runner.pno";
    public static final String PRELIMAUTH = "script.runner.PRELIM_AUTH";
    public static final String PRELIMAUTHPREERROR = "script.runner.PRELIM_AUTHPREERROR";
    public static final String HTTP_PROXY = "script.runner.hhtp.proxy";
    public static final String HTTP_PROXY_PORT = "script.runner.hhtp.proxy.port";
    public static final String HTTP_PROXY_HOST = "script.runner.hhtp.proxy.host";
    public static final String OPTIONAL_SHOW_HEADER = "script.runner.optional_show_header";
    public static final String INCOMPLETE = "incomplete";
    public static final String SPECIAL = "script.runner.special";
    public static final String LOGON = "script.runner.sqlplus.logon";
    public static final String THREETIMES = "script.runner.threetimes";
    public static final String PROMPTFORDATABASE = "SQLCLDBPROMPT";
    public static final String CLEARSCREEN = "sqlcl.clear.screen";
    public static final String NEWPAGE = "script.runner.newpage";
    public static final String HIDDENOPTIONX = "script.runner.sqlcl.optionx";
    public static final String HIDDENOPTIONC = "script.runner.sqlcl.optionc";
    public static final String SQLPLUS_CLASSIC_MODE = "sqlplus.classic.mode";
    public static final String SQLPLUS_EMBEDDED_MODE = "sqlplus.embedded.mode";
    public static final String LOGIN_FILE = "sqlplus.login.file";
    public static final String EXPLICITSETECHO = "script.setecho";
    public static final String ERR_SQLCODE = "sqldev.last.err.sqlcode";
    public static final String SQLCLI_STDIN = "script.runner.sqlcl.stdin.input";
    public static final String SQLCLI_STDIN_WAS_ON = "script.runner.sqlcl.stdin.input.was.on";
    public static final String SQLPLUS_EXECUTE_FILE = "script.runner.sqlcl.execute.file";
    public static final String SQLTERMINATOR = "script.runner.sqlcl.sql.terminator";
    public static final String IGNORECOLUMNSETTINGS = "script.runner.sqlcl.ignore.settings";
    public static final String ORACLE_HOME_MAIN_THREAD = "script.runner.oraclehomemainthread";
    public static final String SQLPATH_PROVIDER_MAIN_THREAD = "script.runner.sqlpathprovidermainthread";
    public static final String LASTLOGINTIME = "sqlcl.last.login.time";
    public static final String ISSLASHSTATEMENT = "script.runner.isslashstatement";
    public static final String SERVEROUTFORMAT = "script.runner.serveroutformat";
    public static final String SERVEROUTPUTUNLIMITED = "script.runner.serveroutputunlimited";
    public static final String PRINTBLLINES = "script.runner.printblanks.aftersubs";
    public static final String COMMANDLINECONNECT = "script.runner.commandlineconnect";
    public static final String SERVEROUTNOLOGLATER = "script.runner.serveroutputnologpending";
    public static final String CONNECT_CALLED = "script.runner.connectcalled";
    public static final String NOMULTILINEACCEPT = "script.runner.nomultilineaccept";
    public static final String SQLCLI_GLOGIN_SQL = "sqlcli.glogin.sql";
    public static final String SQLCLI_LOGIN_SQL = "sqlcli.login.sql";
    public static final String ECHOSCRIPTDEPTH = "sqlcli.runner.echo.scriptdepth";
    public static final String NOHISTORY = "sqlcl.batch.nohistory";
    public static final String NOHISTORYLIST = "sqlcl.batch.nohistory.command.list";
    public static final String ISHTTPCON = "sqlcl.connection.httpcon";
    public static final String SETCOLINVISIBLE = "sqlcl.set.colinvisible";
    public static final String SPOOLTHREAD = "sqlcl.spool.thread";
    public static final String ALIAS_END_ON_EOF = "sqcl.alias.end_statement_on_eof";
    public static final String MAXROWS_SPOOLONLY = "sqlcl.spool.spoolonly";
    public static final String MAXROWS_NEXTTRUE = "sqlcl.spool.nexttrue";
    public static final String ERROR_LOGGING = "sqlplus.error.logging";
    public static final String ERROR_LOGGING_TABLE = "sqlplus.error.logging.table";
    public static final String ERROR_LOGGING_SCHEMA = "sqlplus.error.logging.schema";
    public static final String ERROR_LOGGING_DISPLAY_SCHEMATABLE = "sqlplus.error.logging.displayschematable";
    public static final String ERROR_LOGGING_IDENTIFIER = "sqlplus.error.logging.identifier";
    public static final String SECURELITERALS = "sqlcl.script.secureliterals";
    public static final String IN_INITIAL_SQLCLCONNECT = "sqlcl.script.ininitialconnect";
    public static final String SERVEROUTPUT_OPTIMIZED = "sqlcl.serveroutput.optimized";
    public static final String MAXROWS = "sqlcl.script.maxrows";
    public static final String MAXROWSSPOOLTRUNCATE = "sqlcl.script.maxrowsspooltruncate";
    public static final String CODESCAN_ALL = "sqlcl.codescan.all";
    public static final String CODESCAN_SQLINJECTION = "sqlcl.codescan.SQLINJECTION";
    public static final String CODESCAN_PSRCHECKS = "sqlcl.codescan.PSRCHECKS";
    public static final String CODESCAN_SQLBESTPRACTICE = "sqlcl.codescan.SQLBESTPRACTICE";
    public static final String HANDLESQLEXCEPION = "sqlcl.in.handleSQLException";
    public static final String WALLET_ARCHIVE = "script.runner.walletarchive.zip";
    public static final String WALLET_ARCHIVE_LOCATION = "script.runner.walletarchive.location";
    public static final String GLOBAL_CONN_PROPERTIES = "sqlcl.global.conn.props";
    public static final String PARAMETERPOLICY = "sqlcl.parameterpolicy";
    public static final String ICOMMANDHISTORY = "sqlcl.ihistorycommand";
    public static final String HISTORY_MODIFIED_LINE = "sqlcl.history.modified.line";
    public static final String CONNECTION_PROPERTIES = "sqlcl.connection.properties";
    private static final String SQLDEVELOPER_BANNER = "SQL Developer";
    private static final String SQLCL_BANNER = "SQLcl";
    private static String s_outputEncoding = "UTF-8";
    private static final ThreadLocal<ScriptRunnerContext> _storedContext = new ThreadLocal();
    private Container container;
    public static final String OBJECT_TYPE_ATTRIBUTE_ALIAS = "ALIAS";
    public static final String OBJECT_TYPE_ATTRIBUTE_FORMAT = "FORMAT";
    public static final String OBJECT_TYPE_ATTRIBUTE_LIKE = "LIKE";
    public static final String OBJECT_TYPE_ATTRIBUTE_ON_OFF = "ON_OFF";
    public static final String LOGIN_FILE_ON_CWD = "LOGIN_FILE_ON_CWD";
    public static final String T2TEMPLATE = "T2_TEMPLATE";
    public static final String ILISTPRINTER_MUTE_NEWLINE = "ILISTPRINTER_MUTE_NEWLINE";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Connection baseConnection = null;
    private boolean closeConnection = false;
    private boolean topLevel = false;
    private Map<String, String> map = null;
    private Map<String, String> subvartypeMap = null;
    private Map<String, String> columnMap = null;
    private Map<String, String> ovcolumnMap = null;
    private boolean exited = false;
    private boolean returnExited = false;
    private int osError = 0;
    private int sqlError = 0;
    private boolean escape = false;
    private char escapeChar = (char)92;
    public String escChar = "OFF";
    private char substitutionChar = (char)38;
    private boolean substitutionOn = true;
    private boolean scanOn = true;
    private char terminateChar = (char)59;
    private Character substitutionTerminateChar = Character.valueOf('.');
    private URL _lastUrl = null;
    private Map<String, Object> _props = new HashMap<String, Object>();
    private boolean supressOutput = false;
    private int feedback = -1;
    private int feedback_sqlid = 0;
    private Object _outputComp;
    private boolean _verify = true;
    private boolean _echo = false;
    private int _autoprint = -5;
    private String _sqlPrompt = "SQL> ";
    private String m_basePrompt = "";
    private Map<String, Bind> varMap = null;
    private Map<String, List<DataValue>> varBatchMap = null;
    private PrintWriter _errWriter;
    private IRaptorTaskProgressUpdater m_taskProgressUpdater = null;
    private boolean m_isRunScript = true;
    private Connection m_currentConnection = null;
    private String m_encoding = System.getProperty("file.encoding");
    private int[] dmlResult;
    private RunnerRestrictedLevel.Level restrictedLevel = RunnerRestrictedLevel.Level.NONE;
    private boolean dbmsOutputEnable = false;
    private StringBuffer m_dbmsOutput = null;
    private Map<String, String> m_nlsMap = null;
    private boolean m_isConsumerRunning = false;
    private HashMap<String, Savepoint> savepoints = null;
    private HashMap<String, ArrayList<String>> m_formatCmdList = new HashMap();
    private LinkedHashMap<String, ArrayList<String>> m_breakCmdList = new LinkedHashMap();
    private TreeMap<String, ArrayList<TreeMap<String, HashMap<String, String>>>> m_computeCmdList = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private TopTitle m_tTitle = null;
    private BottomTitle m_bTitle = null;
    private String m_tTitleCmd = "";
    private String m_bTitleCmd = "";
    private boolean m_tTitleFlag = false;
    private boolean m_bTitleFlag = false;
    protected String m_EditorText = "";
    private IGetSpoolFilterProvider m_getSpoolFilterProvider = null;
    private IGetPromptedFieldProvider m_getPromptedFieldProvider = new StandAlonePromptedAcceptProvider();
    private IGetPromptedFieldProvider m_getSubstitutionFieldProvider = new StandAlonePromptedSubstitutionProvider();
    private IGetPromptedPasswordFieldsProvider m_getPasswordFieldsProvider = new StandAlonePromptedPasswordFieldsProvider();
    private IGetPromptedConnectFieldsProvider m_getConnectFieldsProvider = new StandAlonePromptedConnectFieldsProvider();
    private IGetHandlePauseProvider m_getHandlePauseProvider = new StandAloneHandlePauseProvider();
    private IGetHandlePauseProvider m_getHandleSetPauseProvider = new StandAloneHandleSetPauseProvider();
    private boolean _jsonOutput = false;
    private Version cmdlineVersion = new Version("4.1.0");
    private boolean _jsonQuery = false;
    private final HashMap<String, ArrayList<String>> m_121ViewColCmdList = new HashMap();
    ArrayList<ISQLCommand> m_executedCommandList = new ArrayList();
    public int m_scriptStartIndex = 0;
    public int m_scriptEndIndex = 0;
    public Object node = null;
    private IConsoleReader _sqlplusConsoleReader = null;
    private IBuffer _sqlplusBuffer;
    private AtomicBoolean _interrupted = new AtomicBoolean();
    private AtomicBoolean _interruptible = new AtomicBoolean();
    private HashMap<String, HashMap<String, HashMap<String, String>>> m_objectTypeAttributesMap = new HashMap();
    private HashMap<String, String> m_AliasTypeAttributesMap = new HashMap();
    private int unknownStatements = 0;
    private Parameters _parameters = null;

    public boolean shouldInterrupt() {
        return (this.isCommandLine() || this.isInterruptible()) && this.isInterrupted();
    }

    public void setInterruptible(boolean interruptible) {
        this._interruptible.set(interruptible);
    }

    public boolean isInterruptible() {
        return this._interruptible.get();
    }

    public ScriptRunnerContext() {
        this.reInitClear();
        this.runWithStoredContext(() -> {
            this.container = new Container();
        });
    }

    public ScriptRunnerContext(List<ProviderFactory<?>> componentFactories) {
        this.reInitClear();
        this.runWithStoredContext(() -> {
            this.container = new Container(componentFactories);
        });
    }

    public ScriptRunnerContext(ScriptRunnerContext copyFrom) {
        if (copyFrom.map != null) {
            this.map = new HashMap<String, String>(copyFrom.map);
        }
        if (copyFrom.subvartypeMap != null) {
            this.subvartypeMap = new HashMap<String, String>(copyFrom.subvartypeMap);
        }
        if (copyFrom.columnMap != null) {
            this.columnMap = new HashMap<String, String>(copyFrom.columnMap);
        }
        if (copyFrom.ovcolumnMap != null) {
            this.ovcolumnMap = new HashMap<String, String>(copyFrom.ovcolumnMap);
        }
        this.returnExited = copyFrom.returnExited;
        this.escape = copyFrom.escape;
        this.escapeChar = copyFrom.escapeChar;
        this.substitutionChar = copyFrom.substitutionChar;
        this.substitutionOn = copyFrom.substitutionOn;
        this.scanOn = copyFrom.scanOn;
        this.terminateChar = copyFrom.terminateChar;
        this.substitutionTerminateChar = copyFrom.substitutionTerminateChar;
        if (copyFrom._props != null) {
            this._props = new HashMap<String, Object>();
            for (String key : copyFrom._props.keySet()) {
                Class<?> cls;
                Object value = this._props.get(key);
                if (value == null || (cls = value.getClass()) != String.class && cls != Integer.class && cls != Boolean.class && cls != Character.class && cls != Byte.class && cls != Short.class && cls != Long.class && cls != Float.class && cls != Double.class) continue;
                this._props.put(key, value);
            }
        }
        this.supressOutput = copyFrom.supressOutput;
        this.feedback = copyFrom.feedback;
        this.feedback_sqlid = copyFrom.feedback_sqlid;
        this._verify = copyFrom._verify;
        this._echo = copyFrom._echo;
        this._autoprint = copyFrom._autoprint;
        this._sqlPrompt = copyFrom._sqlPrompt;
        this.m_basePrompt = copyFrom.m_basePrompt;
        this._errWriter = copyFrom._errWriter;
        this.m_encoding = copyFrom.m_encoding;
        this.restrictedLevel = copyFrom.restrictedLevel;
        this.dbmsOutputEnable = copyFrom.dbmsOutputEnable;
        if (copyFrom.m_nlsMap != null) {
            this.m_nlsMap = new HashMap<String, String>(copyFrom.m_nlsMap);
        }
        this.m_isConsumerRunning = copyFrom.m_isConsumerRunning;
        this.m_EditorText = copyFrom.m_EditorText;
        this._jsonOutput = copyFrom._jsonOutput;
        this.cmdlineVersion = copyFrom.cmdlineVersion;
        this._jsonQuery = copyFrom._jsonQuery;
        this.runWithStoredContext(() -> {
            this.container = copyFrom.container.copy();
        });
    }

    public final void runWithStoredContext(Runnable runnable) {
        ScriptRunnerContext previousStoredContext = ScriptRunnerContext.getCurrentContext();
        ScriptRunnerContext.set_storedContext(this);
        try {
            runnable.run();
        }
        finally {
            ScriptRunnerContext.set_storedContext(previousStoredContext);
        }
    }

    public static ScriptRunnerContext getCurrentContext() {
        return _storedContext.get();
    }

    public static String getOutputEncoding() {
        return s_outputEncoding;
    }

    public static String lineColErr(Object startLine, Object origSQL, Object endLine, Object startCol, Object errorMsg, ScriptRunnerContext src) {
        String retVal = "";
        String sourceRef = "";
        if (src != null) {
            sourceRef = (String)src.getProperty(SETSOURCEREF);
        }
        if (src.getOutputStream() instanceof JSONWrapBufferedOutputStream) {
            String jdbcErrorMessage = (String)src.getProperty(ERR_MESSAGE_SQLCODE);
            jdbcErrorMessage = jdbcErrorMessage == null ? "\"unknown\"" : jdbcErrorMessage.trim();
            jdbcErrorMessage = JSONWrapBufferedOutputStream.quote(jdbcErrorMessage, true);
            Integer sqlcode = (Integer)src.getProperty(ERR_SQLCODE);
            String errorInfo = MessageFormat.format(ScriptRunnerDbArb.getString("JSON_COMMAND_ERR"), 0 + sqlcode, startLine, 0, jdbcErrorMessage);
            ((JSONWrapBufferedOutputStream)src.getOutputStream()).addStmtInfo(errorInfo);
        }
        retVal = sourceRef == null || sourceRef.equals("") ? MessageFormat.format(ScriptRunnerDbArb.getString("LINE_COL_COMMAND_ERR"), startLine, origSQL, endLine, startCol, errorMsg) : MessageFormat.format(ScriptRunnerDbArb.getString("LINE_COL_FILE_COMMAND_ERR"), startLine, origSQL, endLine, startCol, sourceRef, errorMsg);
        return retVal;
    }

    public static String lineErr(Object startLine, Object origSQL, Object errorMsg, ScriptRunnerContext src) {
        String retVal = "";
        String sourceRef = "";
        if (src != null) {
            sourceRef = (String)src.getProperty(SETSOURCEREF);
            sourceRef = FileUtils.decodeIfFile(sourceRef);
        }
        if (src.getOutputStream() instanceof JSONWrapBufferedOutputStream) {
            Integer sqlcode = (Integer)src.getProperty(ERR_SQLCODE);
            String jdbcErrorMessage = (String)src.getProperty(ERR_MESSAGE_SQLCODE);
            if (jdbcErrorMessage != null) {
                jdbcErrorMessage = JSONWrapBufferedOutputStream.quote(jdbcErrorMessage.trim(), true);
            }
            String string = jdbcErrorMessage = jdbcErrorMessage == null ? "\"unknown\"" : jdbcErrorMessage;
            if (sqlcode == null) {
                sqlcode = 0;
            }
            String errorInfo = MessageFormat.format(ScriptRunnerDbArb.getString("JSON_COMMAND_ERR"), 0 + sqlcode, startLine, 0, jdbcErrorMessage);
            ((JSONWrapBufferedOutputStream)src.getOutputStream()).addStmtInfo(errorInfo);
        }
        retVal = src.getProperty(SQLPLUS_CLASSIC_MODE) != null && Boolean.parseBoolean(src.getProperty(SQLPLUS_CLASSIC_MODE).toString()) ? errorMsg.toString() : (sourceRef == null || sourceRef.equals("") ? (src.getProperty(SQLPLUS_CLASSIC_MODE) == null || !Boolean.parseBoolean(src.getProperty(SQLPLUS_CLASSIC_MODE).toString()) ? MessageFormat.format(ScriptRunnerDbArb.getString("LINE_COMMAND_ERR"), startLine, origSQL, errorMsg) : MessageFormat.format(ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR_CLASSIC"), startLine, errorMsg)) : MessageFormat.format(ScriptRunnerDbArb.getString("LINE_FILE_COMMAND_ERR"), startLine, sourceRef, origSQL, errorMsg));
        return retVal;
    }

    private static void set_storedContext(ScriptRunnerContext ctx) {
        if (ctx != null) {
            _storedContext.set(ctx);
        } else {
            _storedContext.remove();
        }
    }

    public static void setOutputEncoding(String in) {
        s_outputEncoding = in;
    }

    private String caseInsensitiveReplace(String source, String toReplace, String value) {
        int charInt = 0;
        int last = 0;
        if (source == null || ((String)source).equals("")) {
            return "";
        }
        if (toReplace == null || toReplace.equals("")) {
            return source;
        }
        if (value == null) {
            value = "";
        }
        String toReplaceUpper = toReplace.toUpperCase();
        String sourceUpper = ((String)source).toUpperCase();
        while ((charInt = sourceUpper.indexOf(toReplaceUpper, last)) != -1) {
            source = ((String)source).substring(0, charInt) + value + ((String)source).substring(charInt + toReplaceUpper.length());
            sourceUpper = ((String)source).toUpperCase();
            last = charInt + value.length();
        }
        return source;
    }

    private void clearCurrent() {
        if (this.getProperty(JLINE_SETTING) == null) {
            if (this.getBaseConnection() != null) {
                this.putProperty(NOLOG, false);
            }
            this.putProperty(PRELIMAUTH, false);
            this.alwaysCloseCurrentConnection();
            this.setCurrentConnection(this.getBaseConnection());
        }
    }

    private String correctEncodingName(String encoding) {
        String[] encodings;
        for (String validEncoding : encodings = Encodings.getEncodingsWithoutAlias()) {
            if (!validEncoding.equalsIgnoreCase(encoding)) continue;
            return validEncoding;
        }
        return null;
    }

    private void pushValtoMap(SqlplusVariable variable, String value) {
        if (this.getMap().containsKey(variable.toString())) {
            this.getMap().put(variable.toString(), value);
        }
    }

    private String trimQuotes(String interrim) {
        if (interrim == null) {
            return null;
        }
        if (interrim.trim().startsWith("\"") && interrim.trim().endsWith("\"")) {
            return interrim.trim().substring(1, interrim.trim().length() - 1);
        }
        return interrim;
    }

    protected void setProperties(Map<String, Object> properties) {
        this._props = properties;
    }

    void doAllNullSqlplusVar() {
        for (SqlplusVariable current : SqlplusVariable.values()) {
            if (current.equals((Object)SqlplusVariable._PRIVILEGE) || current.equals((Object)SqlplusVariable._CONNECT_IDENTIFIER) || current.equals((Object)SqlplusVariable._EDITOR) || current.equals((Object)SqlplusVariable._PWD)) continue;
            this.getMap().put(current.toString(), null);
        }
    }

    String doAllReplaceSqlplusVar(String source) {
        String interrim = source;
        for (SqlplusVariable current : SqlplusVariable.values()) {
            interrim = this.doPromptReplaceSqlplusVar(interrim, current);
        }
        Set<String> vars = this.getMap().keySet();
        for (String s : vars) {
            if (!this.trimQuotes(interrim).toLowerCase().trim().equals(s.toLowerCase().trim())) continue;
            try {
                interrim = Pattern.compile(s, 18).matcher(interrim).replaceAll(this.getMap().get(s));
            }
            catch (NullPointerException nullPointerException) {}
        }
        return interrim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String doPromptReplaceSqlplusVar(Connection preLoginConn, String source, SqlplusVariable current) {
        block113: {
            if (source.toUpperCase().indexOf(current.toString()) == -1) break block113;
            if (preLoginConn == null && !SqlplusVariable._SQLPLUS_RELEASE.equals((Object)current) && !SqlplusVariable._EDITOR.equals((Object)current)) {
                value = "";
                switch (current.ordinal()) {
                    case 0: {
                        sdf = new SimpleDateFormat("dd-MMM-yy");
                        value = sdf.format(new Date()).toUpperCase();
                        this.pushValtoMap(SqlplusVariable._DATE, value);
                        break;
                    }
                    case 9: {
                        this.pushValtoMap(SqlplusVariable._SQL_ID, "");
                        break;
                    }
                    case 8: {
                        try {
                            x = this.getMap().get(current.toString());
                            value = Paths.get("", new String[0]).toAbsolutePath().toString();
                            this.pushValtoMap(SqlplusVariable._PWD, x != null ? x : value);
                        }
                        catch (Exception e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                        }
                        break;
                    }
                    default: {
                        value = "";
                    }
                }
                value = this.caseInsensitiveReplace(source, current.toString(), value);
                return value;
            }
            if ((preLoginConn != null || !SqlplusVariable._SQLPLUS_RELEASE.equals((Object)current)) && !SqlplusVariable._O_VERSION.equals((Object)current) && !ConnectionResolver.isOracle(preLoginConn)) break block113;
            value = this.getMap().get(current.toString());
            switch (current.ordinal()) {
                case 9: {
                    this.pushValtoMap(SqlplusVariable._SQL_ID, "");
                    break;
                }
                case 0: {
                    if (preLoginConn == null) {
                        value = SqlplusVariable._DATE.toString();
                        break;
                    }
                    try {
                        if (preLoginConn != null && !preLoginConn.isClosed()) {
                            value = DBUtil.getInstance(preLoginConn).executeOracleReturnOneCol("select TO_CHAR(cast(current_timestamp as  date)) from dual", new HashMap<K, V>());
                            break;
                        }
                        sdf = new SimpleDateFormat("dd-MMM-yy");
                        value = sdf.format(new Date()).toUpperCase();
                    }
                    catch (SQLException e) {
                        sdf = new SimpleDateFormat("dd-MMM-yy");
                        value = sdf.format(new Date()).toUpperCase();
                    }
                    break;
                }
                case 2: {
                    if (value != null) break;
                    try {
                        if (preLoginConn != null && !preLoginConn.isClosed()) {
                            sql = preLoginConn.getClass().getName().equals("oracle.nucleo.jdbc.impl.NucleoConnectionImpl") != false ? "select username from sys.e_user_users" : "select USER from dual";
                            value = DBUtil.getInstance(preLoginConn).executeOracleReturnOneCol(sql, new HashMap<K, V>());
                            break;
                        }
                        value = "";
                    }
                    catch (SQLException sql) {}
                    break;
                }
                case 5: {
                    if (value == null) break;
                    break;
                }
                case 3: {
                    if (value == null || value.equals("") || this.getProperty("script.runner.jline") == null) {
                        value = "UNKNOWN";
                        break;
                    }
                    if (!value.equals("NOTSYSDBA")) break;
                    value = "";
                    break;
                }
                case 1: {
                    if (value != null && value != "") break;
                    if (!LockManager.lock(preLoginConn)) ** GOTO lbl157
                    try {
                        stmt = null;
                        rs = null;
                        value = "";
                        gotValue = false;
                        try {
                            stmt = preLoginConn.createStatement();
                            rs = stmt.executeQuery("select sys_context('userenv','service_name') from dual");
                            if (rs.next()) {
                                value = rs.getString(1);
                                if (value != null && value.indexOf(".") != -1) {
                                    value = value.substring(0, value.indexOf("."));
                                }
                                if (value != null && !value.equals("") && !value.toLowerCase().startsWith("sys$")) {
                                    gotValue = true;
                                }
                            }
                        }
                        catch (SQLException e) {
                            if (!e.getMessage().contains("ORA-01034")) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                            }
                        }
                        finally {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (SQLException e) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                }
                            }
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (SQLException e) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                }
                            }
                        }
                        if (!gotValue) {
                            try {
                                stmt = preLoginConn.createStatement();
                                rs = stmt.executeQuery("select sys_context('userenv','con_name') from dual");
                                if (rs.next() && (value = rs.getString(1)) != null && !value.equals("")) {
                                    gotValue = true;
                                }
                            }
                            catch (SQLException e) {
                                if (e.getErrorCode() != 2003) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                }
                            }
                            finally {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (SQLException e) {
                                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                    }
                                }
                                if (stmt != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (SQLException e) {
                                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                    }
                                }
                            }
                        }
                        if (gotValue) ** GOTO lbl157
                        try {
                            stmt = preLoginConn.createStatement();
                            rs = stmt.executeQuery("select sys_context('userenv','db_name') from dual");
                            if (rs.next() && (value = rs.getString(1)) != null && !value.equals("")) {
                                gotValue = true;
                            }
                        }
                        finally {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (SQLException e) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                }
                            }
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Exception e) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                }
                            }
                        }
                    }
                    catch (SQLException e1) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e1.getStackTrace()[0].toString(), e1);
                    }
                    finally {
                        LockManager.unlock(preLoginConn);
                    }
lbl157:
                    // 4 sources

                    if (value != null) break;
                    value = "";
                    break;
                }
                case 7: {
                    if (value != null) break;
                    if (value == null) {
                        value = "";
                    }
                    if (!LockManager.lock(preLoginConn)) break;
                    try {
                        major = preLoginConn.getMetaData().getDatabaseMajorVersion();
                        minor = preLoginConn.getMetaData().getDatabaseMinorVersion();
                        majmin = "";
                        majmin = major > 9 ? "" + major : "0" + major;
                        majmin = minor > 9 ? (String)majmin + minor : (String)majmin + "0" + minor;
                        value = (String)majmin + "000000";
                        break;
                    }
                    catch (SQLException e1) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e1.getStackTrace()[0].toString(), e1);
                        break;
                    }
                    finally {
                        LockManager.unlock(preLoginConn);
                    }
                }
                case 4: {
                    if (value != null) break;
                    numbs = this.getCmdlineVersion().toIntArray();
                    vals = 1;
                    majmin = "";
                    e = numbs;
                    var9_44 = e.length;
                    for (e = 0; e < var9_44; ++e) {
                        i = e[e];
                        if (vals > 6 || i == null) break;
                        majmin = i > 9 ? (String)majmin + i : (String)majmin + "0" + i;
                        ++vals;
                    }
                    for (zeros = vals; zeros < 6; ++zeros) {
                        majmin = (String)majmin + "00";
                    }
                    value = majmin;
                    break;
                }
                case 6: {
                    if (value != null) break;
                    try {
                        prelim = (Boolean)this.getProperty("script.runner.PRELIM_AUTH");
                        if (prelim != null && prelim.equals(Boolean.TRUE)) {
                            if (preLoginConn != null && !preLoginConn.isClosed()) {
                                value = DBUtil.getInstance(preLoginConn).executeOracleReturnOneCol("select * from v$version where upper(banner) like upper('Oracle Database%')", new HashMap<K, V>());
                                break;
                            }
                            value = "";
                            break;
                        }
                        if (preLoginConn != null && !preLoginConn.isClosed()) {
                            if (!LockManager.lock(preLoginConn)) break;
                            try {
                                dBMD = preLoginConn.getMetaData();
                                if (dBMD == null || (value = dBMD.getDatabaseProductVersion()) != null) break;
                                value = "";
                                break;
                            }
                            finally {
                                LockManager.unlock(preLoginConn);
                            }
                        }
                        value = "";
                    }
                    catch (SQLException prelim) {}
                    break;
                }
                case 8: {
                    if (value != null) break;
                    value = "UNKNOWN";
                    alle = null;
                    try {
                        path = "";
                        currentRelativePath = Paths.get("", new String[0]);
                        value = currentRelativePath.toAbsolutePath().toString();
                    }
                    catch (IOError e) {
                        alle = e;
                    }
                    catch (InvalidPathException e) {
                        alle = e;
                    }
                    if (alle == null) break;
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, alle.getStackTrace()[0].toString(), alle);
                }
            }
            if (value != null && !current.equals((Object)SqlplusVariable._DATE) && !current.equals((Object)SqlplusVariable._PRIVILEGE)) {
                this.getMap().put(current.toString(), (String)value);
            }
            if (value != null) {
                source = this.caseInsensitiveReplace(source, current.toString(), (String)value);
            }
        }
        return source;
    }

    public void addBind(String name, String value) {
        this.addBind(name, value, "VARCHAR2(500)");
    }

    public void addBind(String name, String value, String type) {
        String errMsg = null;
        try {
            if (name == null || type == null) {
                errMsg = ScriptRunnerDbArb.getString("ADDBIND_NULL_ERROR");
            } else {
                name = name.toUpperCase();
                String typeUpper = type.toUpperCase();
                boolean error = true;
                boolean bracket = false;
                String noBracket = "";
                if (type.indexOf(10) != -1) {
                    error = true;
                } else if (typeUpper.replaceAll("^NUMBER\\([0-9][0-9]*,[0-9][0-9]*\\)$", "").equals("")) {
                    if (value == null || value.toUpperCase().replaceAll("^[+-]?[0-9][0-9.]*$", "").equals("")) {
                        error = false;
                        bracket = true;
                    } else {
                        errMsg = MessageFormat.format(ScriptRunnerDbArb.getString("ADDBIND_INVALID_NUMERIC"), value);
                    }
                } else if (errMsg == null && typeUpper.replaceAll("^NUMBER\\([0-9][0-9]*\\)$", "").equals("")) {
                    if (value == null || value.toUpperCase().replaceAll("^[+-]?[0-9][0-9.]*$", "").equals("")) {
                        error = false;
                        bracket = true;
                    } else {
                        errMsg = MessageFormat.format(ScriptRunnerDbArb.getString("ADDBIND_INVALID_NUMERIC"), value);
                    }
                } else if (errMsg == null && typeUpper.replaceAll("^NUMBER$", "").equals("")) {
                    if (value == null || value.toUpperCase().replaceAll("^[+-]?[0-9][0-9.]*$", "").equals("")) {
                        error = false;
                    } else {
                        errMsg = MessageFormat.format(ScriptRunnerDbArb.getString("ADDBIND_INVALID_NUMERIC"), value);
                    }
                } else if (errMsg == null && typeUpper.replaceAll("^VARCHAR2\\([0-9][0-9]*\\)$", "").equals("")) {
                    bracket = true;
                    error = false;
                } else if (errMsg == null && typeUpper.replaceAll("^VARCHAR2$", "").equals("")) {
                    bracket = false;
                    error = false;
                }
                if (error) {
                    this.write(MessageFormat.format(ScriptRunnerDbArb.getString("ADDBIND_TYPE_VARCHAR2500"), type));
                    type = "VARCHAR2(500)";
                    error = false;
                    bracket = true;
                }
                if (bracket) {
                    noBracket = type.substring(0, type.indexOf(40));
                }
                if (!bracket) {
                    this.getVarMap().put(name, new Bind(name, type, "no_prompt", value, "", Bind.Mode.UNKNOWN));
                } else {
                    this.getVarMap().put(name, new Bind(name, noBracket, type, "no_prompt", value, ""));
                }
            }
            if (errMsg != null) {
                this.write("\n" + errMsg + "\n");
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getStackTrace()[0].toString(), e);
        }
    }

    public void addSavepoint(Savepoint sp) {
        if (this.savepoints == null) {
            this.savepoints = new HashMap();
        }
        try {
            this.savepoints.put(sp.getSavepointName(), sp);
        }
        catch (SQLException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void addUnknown() {
        ++this.unknownStatements;
    }

    public void alwaysCloseCurrentConnection() {
        try {
            if (!(this.getBaseConnection() != null && this.getCurrentConnection() == this.getBaseConnection() || this.getCurrentConnection() == null || this.getCurrentConnection().isClosed())) {
                this.getCurrentConnection().commit();
                this.getCurrentConnection().close();
            }
        }
        catch (SQLException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public void clearDbmsFlags() {
        this.dbmsOutputEnable = false;
    }

    public ScriptRunnerContext clone() {
        ScriptRunnerContext clone = new ScriptRunnerContext();
        clone.putProperty(IGNORECOLUMNSETTINGS, this.getProperty(IGNORECOLUMNSETTINGS));
        clone.set_autoprint(this.get_autoprint());
        clone.setTTitleFlag(this.getTTitleFlag());
        clone.setBTitleFlag(this.getBTitleFlag());
        clone.setBTitle(this.getBTitle());
        clone.setTTitle(this.getTTitle());
        clone.setBTitleCmd(this.getBTitleCmd());
        clone.setTTitleCmd(this.getTTitleCmd());
        clone.setStoredFormatCmds(this.getStoredFormatCmds());
        clone.setSavepoints(this.getSavePoints());
        clone.consumerRuning(false);
        clone.setdbmsEnable(this.isDbmsEnabled());
        clone.setEncoding(this.getEncoding());
        clone.setCurrentConnection(this.getCurrentConnection());
        clone.set_autoprint(this.get_autoprint());
        clone.setVarMap(this.getVarMap());
        clone.setBatchVarMap(this.getBatchVarMap());
        clone.setVerify(this.isVerifyOn());
        clone.setEcho(this.isEchoOn());
        clone.setFeedback(this.getFeedback());
        clone.setFeedbackSQLID(this.getFeedbackSQLID());
        clone.setSupressOutput(this.isOutputSupressed());
        clone.setProperties((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.putAll(ScriptRunnerContext.this.getProperties());
            }
        });
        clone.setLastUrl(this.getLastUrl());
        clone.setTerminateChar(this.getTerminateChar());
        clone.setSubstitutionTerminateChar(this.getSubstitutionTerminateChar());
        clone.setEscapeChar(this.getEscapeChar());
        clone.setScanOn(this.getScanOn());
        clone.setSubstitutionChar(this.getSubstitutionChar());
        clone.setSubstitutionOn(this.getSubstitutionOn());
        clone.setMap(this.getMap());
        clone.setColumnMap(this.getColumnMap());
        clone.setOVColumnMap(this.getOVColumnMap());
        clone.setSqlError(this.getSqlError());
        clone.setOsError(this.getOsError());
        clone.setCloseConnection(this.getCloseConnection());
        clone.setEscape(this.getEscape());
        clone.setReturnExited(this.getReturnExited());
        clone.setBaseConnection(this.getBaseConnection());
        clone.setNLSMap(this.getNLSMap());
        clone.setSourceRef(this.getSourceRef());
        clone.setPromptedFieldProvider(this.getPromptedFieldProvider());
        clone.setSubstitutionFieldProvider(this.getSubstitutionFieldProvider());
        clone.setPasswordFieldsProvider(this.getPasswordFieldsProvider());
        clone.setHandlePauseProvider(this.getHandlePauseProvider());
        clone.setHandleSetPauseProvider(this.getHandleSetPauseProvider());
        clone.setVersion(this.getCmdlineVersion());
        this.runWithStoredContext(() -> {
            clone.container = this.container.copy();
        });
        return clone;
    }

    public Connection cloneCLIConnection() throws SQLException {
        HashMap propertyConsumer = new HashMap();
        Connection clonedConnection = this.getService(ConnectionContext.class).cloneCurrentConnection(propertyConsumer::put);
        if (clonedConnection == null) {
            throw new SQLException((String)propertyConsumer.get((Object)ConnectionProperty.ERROR_MESSAGE));
        }
        return clonedConnection;
    }

    public void closeCurrentConnection() {
        if (this.getProperty(JLINE_SETTING) == null) {
            this.alwaysCloseCurrentConnection();
        }
    }

    public void consumerRuning(boolean isConsumerRunning) {
        this.m_isConsumerRunning = isConsumerRunning;
    }

    public void closeContext() {
        this.deferredReInitClear();
        if (this.container != null) {
            this.container.close();
            this.container = null;
        }
    }

    public void deferredReInitClear() {
        String envEditor;
        this.closeConnection = false;
        this.topLevel = false;
        this.map = Collections.synchronizedMap(new HashMap());
        this.subvartypeMap = Collections.synchronizedMap(new HashMap());
        this.varMap = Collections.synchronizedMap(new LinkedHashMap());
        this.varBatchMap = null;
        this.columnMap = Collections.synchronizedMap(new HashMap());
        this.ovcolumnMap = Collections.synchronizedMap(new HashMap());
        this.returnExited = this.exited;
        this.exited = false;
        this.osError = 0;
        this.sqlError = 0;
        this.escape = false;
        this.substitutionChar = (char)38;
        this.substitutionOn = true;
        this.scanOn = true;
        this._errWriter = null;
        this.m_isConsumerRunning = true;
        this.doAllNullSqlplusVar();
        if (this.getProperty(SPOOLOUTBUFFER) != null) {
            this.stopSpool();
        }
        this.setFeedback(6);
        this.setFeedbackSQLID(false);
        this.putProperty(NOHISTORY, Boolean.FALSE);
        this.putProperty(CODESCAN_ALL, "all");
        this.putProperty(CODESCAN_SQLINJECTION, Boolean.FALSE);
        this.putProperty(CODESCAN_PSRCHECKS, Boolean.FALSE);
        this.putProperty(CODESCAN_SQLBESTPRACTICE, Boolean.FALSE);
        this.putProperty(SQLTERMINATOR, ";");
        this.putProperty(POPUPBINDS, new HashMap());
        this.putProperty(APPINFO, false);
        this.putProperty(APPINFOARRAYLIST, new ArrayList());
        this.putProperty(AUTOCOMMITSETTING, AUTOCOMMITOFF);
        this.putProperty(AUTOCOMMITCOUNTER, 0L);
        this.putProperty(COPYCOMMIT, "0");
        this.putProperty(IGNORECOLUMNSETTINGS, Boolean.FALSE);
        this.putProperty(SETPAGESIZE, 14);
        this.putProperty(NEWPAGE, 1);
        this.putProperty(SETLINESIZE, 80);
        this.putProperty(SETLONG, 80);
        this.putProperty(SETLONGCHUNKSIZE, 80);
        this.putProperty(SETHEADING, "ON");
        this.putProperty(EXITCOMMIT, "ON");
        this.putProperty(SQLPLUS_CLASSIC_MODE, Boolean.FALSE);
        this.putProperty(SQLPLUS_EMBEDDED_MODE, "OFF");
        this.putProperty(SETHEADSEP, "ON");
        this.putProperty(SETTRIMOUT, true);
        this.putProperty(SETHEADSEPCHAR, "|");
        this.putProperty(SETWRAP, "ON");
        this.putProperty(SETPRELIM, "OFF");
        this.putProperty(SETSHOWMODE, "OFF");
        HashMap<String, Object> describecontents = new HashMap<String, Object>();
        describecontents.put("DEPTH", 1);
        describecontents.put("LINENUM", "OFF");
        describecontents.put("INDENT", "ON");
        this.putProperty(SETDESCRIBE, describecontents);
        this.putProperty(SETCOLSEP, " ");
        this.putProperty(SETSCAN, "ON");
        this.putProperty(SET_PAUSE, Boolean.FALSE);
        this.putProperty(SET_SECUREDCOL, Boolean.FALSE);
        this.putProperty(SET_SECUREDCOL_UNAUTH, "******************************");
        this.putProperty(SET_SECUREDCOL_UNKNOWN, "??????????????????????????????");
        this.putProperty("script.runner.set_xmlformat", Boolean.FALSE);
        this.putProperty("script.runner.set_xmlformat", Boolean.FALSE);
        this.putProperty(SET_PAUSE_VALUE, "");
        this.putProperty(PRINTBLLINES, Boolean.TRUE);
        this.putProperty(SETCOLINVISIBLE, Boolean.FALSE);
        this.putProperty(SETNUMWIDTH, 10);
        this.putProperty(EDITFILE, "afiedt.buf");
        this.putProperty(SUFFIX, "sql");
        this.putProperty(SETNUMFORMAT, "");
        this.putProperty(SETSOURCEREF, "");
        this.putProperty(SETCOLOR, "OFF");
        this.putProperty(SQLPROMPTTIME, "OFF");
        this.putProperty(LNO, 0);
        this.putProperty(PNO, 0);
        this.putProperty(SET_SQLCODE, 0);
        this.putProperty(SET_OSCODE, 0);
        this.putProperty(SQLCLI_GLOGIN_SQL, Boolean.FALSE);
        this.putProperty(SQLCLI_LOGIN_SQL, Boolean.FALSE);
        this.putProperty(ERROR_LOGGING, Boolean.FALSE);
        this.putProperty(ERROR_LOGGING_TABLE, "SPERRORLOG");
        this.removeProperty(SERVEROUTPUT_OPTIMIZED);
        String defaultEditor = "vi";
        if (System.getenv("SQLPLUS_CLASSIC") != null) {
            this.putProperty(SQLPLUS_CLASSIC_MODE, Boolean.TRUE);
            defaultEditor = "ed";
        }
        if ((envEditor = System.getenv("EDITOR")) != null && !envEditor.equals("")) {
            defaultEditor = envEditor;
        } else if (System.getProperty("os.name").toLowerCase().indexOf("win") > -1) {
            defaultEditor = "notepad";
        }
        this.getMap().put(SqlplusVariable._EDITOR.toString(), defaultEditor);
        this.setSubstitutionTerminateChar(Character.valueOf('.'));
    }

    public void deferredReInitNoExit() {
        this.clearCurrent();
        this.closeConnection = false;
        this.topLevel = false;
        this._errWriter = null;
        this.exited = false;
        this.putProperty(APPINFOARRAYLIST, new ArrayList());
        if (this.getProperty(SPOOLOUTBUFFER) != null) {
            this.stopSpool();
        }
    }

    public String doPromptReplaceSqlplusVar(String source, SqlplusVariable current) {
        return this.doPromptReplaceSqlplusVar(this.getCurrentConnection(), source, current);
    }

    public void enableDbmsOutput() {
        this.dbmsOutputEnable = true;
    }

    public <T extends Enum<T>> boolean enumContains(Class<T> enumerator, String value) {
        for (Enum c : (Enum[])enumerator.getEnumConstants()) {
            if (!c.name().equals(value)) continue;
            return true;
        }
        return false;
    }

    public void errorLog(String script, String message, String sql) {
        boolean logging = (Boolean)this.getProperty(ERROR_LOGGING);
        if (logging) {
            String unformattedInsertSQL = "insert into {0} (USERNAME , TIMESTAMP ,SCRIPT , IDENTIFIER ,MESSAGE , STATEMENT) values (:SCHEMA, CAST(SYSDATE AS TIMESTAMP), :SCRIPT,:IDENTIFIER, :MESSAGE,:STATEMENT)";
            String errorlog = (String)this.getProperty(ERROR_LOGGING_TABLE);
            if (this.getProperty(ERROR_LOGGING_SCHEMA) != null) {
                errorlog = MessageFormat.format("{0}.{1}", this.getProperty(ERROR_LOGGING_SCHEMA).toString().toUpperCase(), errorlog);
            }
            String insertSQL = MessageFormat.format("insert into {0} (USERNAME , TIMESTAMP ,SCRIPT , IDENTIFIER ,MESSAGE , STATEMENT) values (:SCHEMA, CAST(SYSDATE AS TIMESTAMP), :SCRIPT,:IDENTIFIER, :MESSAGE,:STATEMENT)", errorlog);
            HashMap<String, String> binds = new HashMap<String, String>();
            try {
                String schema = this.getBaseConnection().getSchema();
                binds.put("SCHEMA", schema.toUpperCase());
            }
            catch (SQLException schema) {
                // empty catch block
            }
            if (script != null && script.length() > 0) {
                Path p = Paths.get(script, new String[0]);
                script = p.getFileName().toString();
            }
            binds.put("SCRIPT", script);
            String identifier = "";
            if (this.getProperty(ERROR_LOGGING_IDENTIFIER) != null) {
                identifier = this.getProperty(ERROR_LOGGING_IDENTIFIER).toString();
            }
            binds.put("IDENTIFIER", identifier);
            binds.put("MESSAGE", message);
            binds.put("STATEMENT", sql);
            DBUtil.getInstance(this.getCurrentConnection()).execute(insertSQL, binds);
        }
    }

    public int get_autoprint() {
        return this._autoprint;
    }

    public HashMap<String, ArrayList<String>> get121IdentViewColCmds() {
        return this.m_121ViewColCmdList;
    }

    public HashMap<String, String> getAliasTypeAttributesMap() {
        return this.m_AliasTypeAttributesMap;
    }

    public Connection getBaseConnection() {
        return this.baseConnection;
    }

    public String getBasePrompt() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss ");
        Calendar now = Calendar.getInstance();
        boolean addTime = this.getProperty(SQLPROMPTTIME).equals("ON");
        return addTime ? dateFormat.format(now.getTime()) + this.m_basePrompt : this.m_basePrompt;
    }

    public Map<String, List<DataValue>> getBatchVarMap() {
        return this.varBatchMap;
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return this.getBooleanProperty(name, null, null, defaultValue);
    }

    public boolean getBooleanProperty(String name, String trueRep, String falseRep, boolean defaultValue) {
        boolean result = defaultValue;
        Object propValue = this._props.get(name);
        if (propValue != null) {
            String propText = propValue.toString();
            if (trueRep == null) {
                result = Boolean.parseBoolean(propText);
            } else if (trueRep.equalsIgnoreCase(propText)) {
                result = true;
            } else if (falseRep == null || falseRep.equalsIgnoreCase(propText)) {
                result = false;
            }
        }
        return result;
    }

    public BottomTitle getBTitle() {
        return this.m_bTitle;
    }

    public String getBTitleCmd() {
        return this.m_bTitleCmd;
    }

    public boolean getBTitleFlag() {
        return this.m_bTitleFlag;
    }

    public char getCharProperty(String name, char defaultValue) {
        String stringRep;
        char result = defaultValue;
        Object propValue = this._props.get(name);
        if (propValue != null && (stringRep = propValue.toString()) != null && stringRep.length() == 1) {
            result = stringRep.charAt(0);
        }
        return result;
    }

    public boolean getCloseConnection() {
        return this.closeConnection;
    }

    public Version getCmdlineVersion() {
        return this.cmdlineVersion;
    }

    public Map<String, String> getColumnMap() {
        return this.columnMap;
    }

    public IGetPromptedConnectFieldsProvider getConnectFieldsProvider() {
        return this.m_getConnectFieldsProvider;
    }

    public String getConnectionID(String source) {
        return this.doPromptReplaceSqlplusVar(source, SqlplusVariable._CONNECT_IDENTIFIER);
    }

    public Object getConsoleService() {
        return this.getProperty(JLINE_SETTING);
    }

    public Connection getCurrentConnection() {
        return this.m_currentConnection;
    }

    public String getDate(String source) {
        return this.doPromptReplaceSqlplusVar(source, SqlplusVariable._DATE);
    }

    public int[] getDMLResult() {
        return this.dmlResult;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public PrintWriter getErrWriter() {
        return this._errWriter;
    }

    public boolean getEscape() {
        return this.escape;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public IExceptionHandler getExceptionHandler() {
        return null;
    }

    public ArrayList<ISQLCommand> getExecutedCommandList() {
        return this.m_executedCommandList;
    }

    public boolean getExited() {
        return this.exited;
    }

    public int getFeedback() {
        return this.feedback;
    }

    public boolean getFeedbackSQLID() {
        return this.feedback_sqlid != 0;
    }

    public IGetHandlePauseProvider getHandlePauseProvider() {
        return this.m_getHandlePauseProvider;
    }

    public IGetHandlePauseProvider getHandleSetPauseProvider() {
        return this.m_getHandleSetPauseProvider;
    }

    public int getIntegerProperty(String name, int defaultValue) {
        int result = defaultValue;
        Object propValue = this._props.get(name);
        if (propValue != null) {
            try {
                result = Integer.parseInt(propValue.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public String getLastDirName() {
        try {
            if (this._lastUrl == null) {
                return null;
            }
            return FileUtils.getDirFromFileURL(this._lastUrl);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public URL getLastDirNameURL() {
        return this._lastUrl;
    }

    public String getLastNodeDirName() {
        try {
            URL nodeURL = (URL)this.getProperty(NODE_URL);
            if (nodeURL == null) {
                return null;
            }
            return FileUtils.getDirFromFileURL(nodeURL);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public URL getLastNodeForDirNameURL() {
        URL nodeURL = (URL)this.getProperty(NODE_URL);
        return nodeURL;
    }

    public URL getLastUrl() {
        return this._lastUrl;
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public Map<String, String> getNLSMap() {
        return this.m_nlsMap;
    }

    public Object getNode() {
        return this.node;
    }

    public HashMap<String, HashMap<String, HashMap<String, String>>> getObjectTypeAttributes() {
        return this.m_objectTypeAttributesMap;
    }

    public int getOsError() {
        return this.osError;
    }

    public Object getOutputComponent() {
        return this._outputComp;
    }

    public WrapListenBufferOutputStream getOutputStream() {
        return (WrapListenBufferOutputStream)this._props.get(OUT_STREAM_WRAPPER);
    }

    public Map<String, String> getOVColumnMap() {
        return this.ovcolumnMap;
    }

    public Parameters getParameterInstance() {
        if (this._parameters == null) {
            this._parameters = new Parameters();
            return this._parameters;
        }
        return this._parameters;
    }

    public IGetPromptedPasswordFieldsProvider getPasswordFieldsProvider() {
        return this.m_getPasswordFieldsProvider;
    }

    public String getPostCommand() {
        return (String)this._props.get(POST_COMMAND);
    }

    public String getPreCommand() {
        return (String)this._props.get(PRE_COMMAND);
    }

    public String getPrivilege(String source) {
        return this.doPromptReplaceSqlplusVar(source, SqlplusVariable._PRIVILEGE);
    }

    public String getPrompt() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss ");
        Calendar now = Calendar.getInstance();
        boolean addTime = this.getProperty(SQLPROMPTTIME).equals("ON");
        String prompt = this.doAllReplaceSqlplusVar(this._sqlPrompt).replaceAll("'", "").replaceAll("\"", "");
        return addTime ? dateFormat.format(now.getTime()) + prompt : prompt;
    }

    public IGetPromptedFieldProvider getPromptedFieldProvider() {
        return this.m_getPromptedFieldProvider;
    }

    public Map<String, Object> getProperties() {
        return this._props;
    }

    public Object getProperty(String name) {
        return this._props.get(name);
    }

    public String getRawPrompt() {
        return this._sqlPrompt;
    }

    public RunnerRestrictedLevel.Level getRestrictedLevel() {
        return this.restrictedLevel;
    }

    public boolean getReturnExited() {
        return this.returnExited;
    }

    public Savepoint getSavepoint(String name) {
        if (this.savepoints != null) {
            return this.savepoints.get(name);
        }
        return null;
    }

    public HashMap<String, Savepoint> getSavePoints() {
        return this.savepoints;
    }

    public boolean getScanOn() {
        return this.scanOn;
    }

    public String getSettingsDir() {
        Object base = System.getProperty("ide.pref.dir");
        if (base == null) {
            base = System.getProperty("ide.base.dir");
        }
        if (base == null) {
            base = System.getProperty("user.home") + File.separator + ".sqldeveloper";
        }
        try {
            if (!new File((String)base).exists()) {
                new File((String)base).mkdir();
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return base;
    }

    public String getSourceRef() {
        return (String)this.getProperty(SETSOURCEREF);
    }

    public IGetSpoolFilterProvider getSpoolFilterProvider() {
        return this.m_getSpoolFilterProvider;
    }

    public int getSqlError() {
        return this.sqlError;
    }

    public String getSQLID(String source) {
        return this.doPromptReplaceSqlplusVar(source, SqlplusVariable._SQL_ID);
    }

    public IBuffer getSQLPlusBuffer() {
        return this._sqlplusBuffer;
    }

    public IConsoleReader getSQLPlusConsoleReader() {
        return this._sqlplusConsoleReader;
    }

    public LinkedHashMap<String, ArrayList<String>> getStoredBreakCmds() {
        return this.m_breakCmdList;
    }

    public TreeMap<String, ArrayList<TreeMap<String, HashMap<String, String>>>> getStoredComputeCmds() {
        return this.m_computeCmdList;
    }

    public HashMap<String, ArrayList<String>> getStoredFormatCmds() {
        return this.m_formatCmdList;
    }

    public String getStringProperty(String name, String defaultValue) {
        String result = defaultValue;
        Object propValue = this._props.get(name);
        if (propValue != null) {
            result = propValue.toString();
        }
        return result;
    }

    public String getStringTerminator() {
        return System.getProperty("line.separator");
    }

    public char getSubstitutionChar() {
        return this.substitutionChar;
    }

    public IGetPromptedFieldProvider getSubstitutionFieldProvider() {
        return this.m_getSubstitutionFieldProvider;
    }

    public boolean getSubstitutionOn() {
        return this.substitutionOn;
    }

    public Character getSubstitutionTerminateChar() {
        return this.substitutionTerminateChar;
    }

    public Map<String, String> getSubVarTypeMap() {
        return this.subvartypeMap;
    }

    @Override
    public IRaptorTaskProgressUpdater getTaskProgressUpdater() {
        return this.m_taskProgressUpdater;
    }

    public char getTerminateChar() {
        return this.terminateChar;
    }

    public boolean getTiming() {
        if (this.getProperty(SHOWTIMING) != null) {
            return (Boolean)this.getProperty(SHOWTIMING);
        }
        return false;
    }

    public boolean getTopLevel() {
        return this.topLevel;
    }

    public TopTitle getTTitle() {
        return this.m_tTitle;
    }

    public String getTTitleCmd() {
        return this.m_tTitleCmd;
    }

    public boolean getTTitleFlag() {
        return this.m_tTitleFlag;
    }

    public Map<String, Bind> getVarMap() {
        return this.varMap;
    }

    public boolean hasNode() {
        return this.node != null;
    }

    public boolean is121LongIdentUsed() {
        String col;
        boolean is121longident = false;
        Iterator<String> iter = this.m_121ViewColCmdList.keySet().iterator();
        while (iter.hasNext() && !(is121longident = this.m_121ViewColCmdList.get(col = iter.next()).contains("_12.1_longident"))) {
        }
        return is121longident;
    }

    public boolean isCommandLine() {
        return this._props.get(JLINE_SETTING) != null;
    }

    public boolean isConsumerRunning() {
        if (!this.m_isConsumerRunning) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.m_isConsumerRunning;
    }

    public boolean isDbmsEnabled() {
        return this.dbmsOutputEnable;
    }

    public boolean isEchoOn() {
        return this._echo;
    }

    public boolean isInterrupted() {
        return this._interrupted.get();
    }

    public boolean isJSONOutput() {
        return this._jsonOutput;
    }

    public boolean isJsonQuery() {
        return this._jsonQuery;
    }

    public boolean isLoginSQL() {
        return Boolean.parseBoolean(this.getProperty(SQLCLI_GLOGIN_SQL).toString()) || Boolean.parseBoolean(this.getProperty(SQLCLI_LOGIN_SQL).toString());
    }

    public boolean isMaxUnknown() {
        return this.unknownStatements >= 4;
    }

    public boolean isOutputSupressed() {
        return this.supressOutput;
    }

    public boolean isProductNameSQLcl() {
        String productBanner = SQLPLUSUtil.getProductName();
        return productBanner != null && productBanner.equals(SQLCL_BANNER);
    }

    public boolean isProductNameSQLDeveloper() {
        String productBanner = SQLPLUSUtil.getProductName();
        return productBanner != null && productBanner.equals(SQLDEVELOPER_BANNER);
    }

    public boolean isRunScript() {
        return this.m_isRunScript;
    }

    public boolean isSQLPlusClassic() {
        if (this.getProperty(SQLPLUS_CLASSIC_MODE) != null && Boolean.parseBoolean(this.getProperty(SQLPLUS_CLASSIC_MODE).toString())) {
            this.putProperty(SQLPLUS_CLASSIC_MODE, Boolean.TRUE);
            return true;
        }
        return false;
    }

    public boolean isSQLPlusSilent() {
        return this.getProperty(SILENT) != null && Boolean.parseBoolean(this.getProperty(SILENT).toString());
    }

    public boolean isStdin() {
        if (this.getProperty(SQLCLI_STDIN) != null && Boolean.parseBoolean(this.getProperty(SQLCLI_STDIN).toString())) {
            this.putProperty(SQLCLI_STDIN, Boolean.TRUE);
            return true;
        }
        return false;
    }

    public boolean isVerifyOn() {
        return this._verify;
    }

    public String popDbmsOutput() {
        if (this.m_dbmsOutput == null) {
            return null;
        }
        String sTemp = this.m_dbmsOutput.toString();
        this.m_dbmsOutput = null;
        return sTemp;
    }

    public String prependCD(String fileFragment) {
        String[] stArray;
        Object retVal = fileFragment;
        String inputFile = fileFragment;
        boolean prependDirectory = false;
        if (System.getProperty("os.name").startsWith("Windows")) {
            if (inputFile.length() <= 3 || (inputFile.charAt(1) != ':' || inputFile.charAt(2) != '/' && inputFile.charAt(2) != '\\') && (inputFile.charAt(0) != '/' || inputFile.charAt(2) != ':' || inputFile.charAt(3) != '/')) {
                prependDirectory = true;
            }
        } else if (!inputFile.startsWith("/")) {
            prependDirectory = true;
        }
        String changepwd = (String)this.getProperty(CDPATH);
        if (prependDirectory && changepwd != null && (stArray = changepwd.split(File.pathSeparator)) != null && stArray.length > 0 && stArray[0] != null && new File(stArray[0]).isDirectory()) {
            changepwd = stArray[0];
            retVal = changepwd.endsWith(File.separator) ? changepwd + (String)retVal : changepwd + File.separator + (String)retVal;
        }
        return retVal;
    }

    public void pushDbmsOutput(String s) {
        if (this.m_dbmsOutput == null) {
            this.m_dbmsOutput = new StringBuffer();
        }
        this.m_dbmsOutput.append(s);
    }

    public void putParamMap(String setName, HashMap<String, String> parms) {
        this.putProperty(setName, parms);
    }

    public void putProperty(String name, Object value) {
        this._props.put(name, value);
    }

    public final void reInitClear() {
        if (this.getProperty(JLINE_SETTING) == null) {
            this.deferredReInitClear();
        }
        try {
            this.getMap().put(SqlplusVariable._PWD.toString(), Paths.get(".", new String[0]).toRealPath(new LinkOption[0]).toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reInitNoExit() {
        if (this.getProperty(JLINE_SETTING) == null) {
            this.deferredReInitNoExit();
        }
    }

    public void reInitOnExit() {
        this.clearCurrent();
        Boolean choice = (Boolean)this.getProperty(REINIT_ON_EXIT);
        if (choice != null && !choice.booleanValue()) {
            this.reInitNoExit();
        } else {
            this.reInitClear();
        }
    }

    public Object removeProperty(String name) {
        return this._props.remove(name);
    }

    public void resetUnknown() {
        this.unknownStatements = 0;
    }

    /*
     * Exception decompiling
     */
    public String save(String filename, int mode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void set_autoprint(int _autoprint) {
        this._autoprint = _autoprint;
    }

    public void setAliasTypeAttributesMap(HashMap<String, String> m_AliasTypeAttributesMap) {
        this.m_AliasTypeAttributesMap = m_AliasTypeAttributesMap;
    }

    public void setBaseConnection(Connection baseConnection) {
        this.baseConnection = baseConnection;
    }

    public void setBasePrompt(String string) {
        this.m_basePrompt = string;
    }

    public void setBatchVarMap(Map<String, List<DataValue>> map) {
        this.varBatchMap = map;
    }

    public void setBTitle(BottomTitle titleObj) {
        this.m_bTitle = titleObj;
    }

    public void setBTitleCmd(String bottomTitle) {
        this.m_bTitleCmd = bottomTitle;
    }

    public void setBTitleFlag(boolean flag) {
        this.m_bTitleFlag = flag;
    }

    public void setCloseConnection(boolean closeConnection) {
        this.closeConnection = closeConnection;
    }

    public void setColumnMap(Map<String, String> columnMap) {
        this.columnMap = columnMap;
    }

    public void setConnectFieldsProvider(IGetPromptedConnectFieldsProvider provider) {
        this.m_getConnectFieldsProvider = provider;
    }

    public void setCurrentConnection(Connection conn) {
        if (this.m_currentConnection != null && (conn == null || !conn.equals(this.m_currentConnection)) || conn == null) {
            this.doAllNullSqlplusVar();
        }
        this.m_currentConnection = conn;
    }

    public void setdbmsEnable(boolean enabled) {
        this.dbmsOutputEnable = enabled;
    }

    public void setDMLResult(int[] nums) {
        this.dmlResult = nums;
    }

    public void setEcho(boolean echo) {
        this._echo = echo;
    }

    public void setEncoding(String encoding) {
        String correctEncodingName = this.correctEncodingName(encoding);
        String newEncoding = correctEncodingName != null ? correctEncodingName : encoding;
        try {
            "".getBytes(newEncoding);
            this.m_encoding = newEncoding;
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(encoding, ex);
        }
    }

    public void setErrWriter(PrintWriter errW) {
        this._errWriter = errW;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
    }

    public void setExited(boolean exited) {
        Integer exitVal;
        this.exited = exited;
        if (exited && (exitVal = (Integer)this.getProperty(EXIT_INT)) == null) {
            this.putProperty(EXIT_INT, 0);
        }
    }

    public void setFeedback(int feed) {
        this.feedback = feed;
    }

    public void setFeedbackSQLID(boolean flag) {
        this.feedback_sqlid = flag ? -10 : 0;
    }

    public void setHandlePauseProvider(IGetHandlePauseProvider provider) {
        this.m_getHandlePauseProvider = provider;
    }

    public void setHandleSetPauseProvider(IGetHandlePauseProvider provider) {
        this.m_getHandleSetPauseProvider = provider;
    }

    public void setInterrupted(boolean interrupted) {
        this._interrupted.set(interrupted);
    }

    public void setIsRunScript(boolean isRunScript) {
        this.m_isRunScript = isRunScript;
    }

    public void setJSONOutput(boolean jsonOutput) {
        this._jsonOutput = jsonOutput;
    }

    public void setJSONQueryRun(boolean jsonQuery) {
        this._jsonQuery = jsonQuery;
    }

    public void setLastUrl(URL lastUrl) {
        this._lastUrl = lastUrl;
    }

    public void setMap(Map<String, String> map) {
        this.map = map;
    }

    public void setNLSMap(Map<String, String> nlsMap) {
        this.m_nlsMap = nlsMap;
    }

    public void setObjectTypeAttributes(HashMap<String, HashMap<String, HashMap<String, String>>> m_objectTypeAttributesMap) {
        this.m_objectTypeAttributesMap = m_objectTypeAttributesMap;
    }

    public void setOsError(int osError) {
        this.osError = osError;
    }

    public void setOutputComponent(Object outputComp) {
        this._outputComp = outputComp;
    }

    public void setOutputStreamWrapper(BufferedOutputStream out) {
        if (this.getOutputStream() == null) {
            if (out instanceof WrapListenBufferOutputStream) {
                this._props.put(OUT_STREAM_WRAPPER, out);
            } else if (this._jsonOutput) {
                this._props.put(OUT_STREAM_WRAPPER, new JSONWrapBufferedOutputStream((OutputStream)out, this));
            } else {
                this._props.put(OUT_STREAM_WRAPPER, new WrapListenBufferOutputStream((OutputStream)out, this));
            }
        } else {
            try {
                BufferedOutputStream bos = out;
                while (bos instanceof WrapListenBufferOutputStream) {
                    bos = ((WrapListenBufferOutputStream)bos).getMainStream();
                }
                this.getOutputStream().replaceMainStream(bos);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    public void setOVColumnMap(Map<String, String> columnMap) {
        this.ovcolumnMap = columnMap;
    }

    public void setPasswordFieldsProvider(IGetPromptedPasswordFieldsProvider provider) {
        this.m_getPasswordFieldsProvider = provider;
    }

    public void setPostCommand(String cmd) {
        this._props.put(POST_COMMAND, cmd);
    }

    public void setPreCommand(String cmd) {
        this._props.put(PRE_COMMAND, cmd);
    }

    public void setPrompt(String string) {
        this._sqlPrompt = string;
    }

    public void setPromptedFieldProvider(IGetPromptedFieldProvider provider) {
        this.m_getPromptedFieldProvider = provider;
    }

    public void setRestrictedLevel(RunnerRestrictedLevel.Level restrictedLevel) {
        this.restrictedLevel = restrictedLevel;
    }

    public void setReturnExited(boolean returnExited) {
        this.returnExited = returnExited;
    }

    public void setSavepoints(HashMap<String, Savepoint> sps) {
        this.savepoints = sps;
    }

    public void setScanOn(boolean scanOn) {
        this.scanOn = scanOn;
    }

    public void setScriptText(int startIndex, int endIndex) {
        this.m_scriptStartIndex = startIndex;
        this.m_scriptEndIndex = endIndex;
    }

    public void setSourceRef(String base) {
        if (base == null || base.equals("")) {
            this.putProperty(SETSOURCEREF, "");
            return;
        }
        int frontSlash = base.indexOf("/");
        int backSlash = base.indexOf("\\");
        if (frontSlash == -1 && backSlash == -1 || base.endsWith("/") || base.endsWith("\\")) {
            this.putProperty(SETSOURCEREF, "");
            return;
        }
        String lower = base.toLowerCase(Locale.US);
        if (FileUtils.startsWithHttpOrFtp(lower)) {
            this.putProperty(SETSOURCEREF, base);
        } else {
            if (File.separator.equals("/")) {
                base = base.replace("\\", "/");
            } else if (!base.startsWith("//")) {
                base = base.replace("/", "\\");
            }
            this.putProperty(SETSOURCEREF, base);
        }
    }

    public void setSpoolFilterProvider(IGetSpoolFilterProvider provider) {
        this.m_getSpoolFilterProvider = provider;
    }

    public void setSqlError(int sqlError) {
        this.sqlError = sqlError;
    }

    public void setSQLPlusBuffer(IBuffer buffer) {
        this._sqlplusBuffer = buffer;
    }

    public void setSQLPlusCmdLineLogin() {
        this.getProperties().put(SQLPLUS_CMDLINE_LOGIN, "true");
    }

    public void setSQLPlusConsoleReader(IConsoleReader reader) {
        this._sqlplusConsoleReader = reader;
    }

    public void setStoredBreakCmds(LinkedHashMap<String, ArrayList<String>> cmds) {
        this.m_breakCmdList = cmds;
    }

    public void setStoredComputeCmds(TreeMap<String, ArrayList<TreeMap<String, HashMap<String, String>>>> cmds) {
        this.m_computeCmdList = cmds;
    }

    public void setStoredFormatCmds(HashMap<String, ArrayList<String>> cmds) {
        this.m_formatCmdList = cmds;
    }

    public void setSubstitutionChar(char substitutionChar) {
        this.substitutionChar = substitutionChar;
    }

    public void setSubstitutionFieldProvider(IGetPromptedFieldProvider provider) {
        this.m_getSubstitutionFieldProvider = provider;
    }

    public void setSubstitutionOn(boolean substitutionOn) {
        this.substitutionOn = substitutionOn;
    }

    public void setSubstitutionTerminateChar(Character substitutionTerminateChar) {
        this.substitutionTerminateChar = substitutionTerminateChar;
    }

    public void setSupressOutput(boolean supress) {
        this.supressOutput = supress;
    }

    public void setTaskProgressUpdater(IRaptorTaskProgressUpdater taskProgressUpdater) {
        this.m_taskProgressUpdater = taskProgressUpdater;
    }

    public void setTerminateChar(char terminateChar) {
        this.terminateChar = terminateChar;
    }

    public void setTopLevel(boolean topLevel) {
        this.topLevel = topLevel;
    }

    public void setTTitle(TopTitle titleObj) {
        this.m_tTitle = titleObj;
    }

    public void setTTitleCmd(String topTitle) {
        this.m_tTitleCmd = topTitle;
    }

    public void setTTitleFlag(boolean flag) {
        this.m_tTitleFlag = flag;
    }

    public void setVarMap(Map<String, Bind> map) {
        this.varMap = map;
    }

    public void setVerify(boolean id) {
        this._verify = id;
    }

    public void setVersion(Version version) {
        this.cmdlineVersion = version;
    }

    public void stopSpool() {
        new SetSpool().stopSpool(this);
    }

    public byte[] stringToByteArrayForScriptRunnerNonStatic(String in) {
        if (in == null) {
            in = "";
        }
        try {
            return in.getBytes(this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            return in.getBytes();
        }
    }

    public void updateColumn(String[] columns, String[] values, String[] types) {
        boolean valuesIsNull;
        Map<String, String> cMap = this.getColumnMap();
        boolean bl = valuesIsNull = values == null;
        if (cMap.size() == 0) {
            return;
        }
        for (int i = 1; i < columns.length; ++i) {
            String theSubVariable;
            String columnName = columns[i];
            String s = null;
            if (!valuesIsNull) {
                s = values[i];
            }
            if (s == null) {
                s = "";
            }
            String dataType = null;
            if (types != null) {
                dataType = types[i];
            }
            if ((theSubVariable = cMap.get(columnName.toUpperCase())) == null) continue;
            if (!valuesIsNull || !this.getMap().containsKey(theSubVariable.toUpperCase())) {
                this.getMap().put(theSubVariable.toUpperCase(), s);
                if (dataType != null) {
                    this.subvartypeMap.put(theSubVariable.toUpperCase(), dataType);
                }
            }
            if (!valuesIsNull || this.getMap().containsKey(theSubVariable.toUpperCase())) continue;
            this.getMap().put(theSubVariable.toUpperCase(), "");
        }
    }

    public void updateOVColumn(String[] columns, String[] values, String[] types) {
        boolean valuesIsNull;
        Map<String, String> cMap = this.getOVColumnMap();
        boolean bl = valuesIsNull = values == null;
        if (cMap.size() == 0) {
            return;
        }
        for (int i = 1; i < columns.length; ++i) {
            String theSubVariable;
            String columnName = columns[i];
            String s = null;
            if (!valuesIsNull) {
                s = values[i];
            }
            if (s == null) {
                s = "";
            }
            String dataType = null;
            if (types != null) {
                dataType = types[i];
            }
            if ((theSubVariable = cMap.get(columnName.toUpperCase())) == null) continue;
            if (!valuesIsNull || !this.getMap().containsKey(theSubVariable.toUpperCase())) {
                this.getMap().put(theSubVariable.toUpperCase(), s);
                if (dataType != null) {
                    this.subvartypeMap.put(theSubVariable.toUpperCase(), dataType);
                }
            }
            if (!valuesIsNull || this.getMap().containsKey(theSubVariable.toUpperCase())) continue;
            this.getMap().put(theSubVariable.toUpperCase(), "");
        }
    }

    public void write(String s) {
        if (s == null) {
            s = "";
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "ScriptRunnerContest write was sent null");
        }
        if (this.isConsumerRunning() && !this.shouldInterrupt() && !this.isInterrupted()) {
            if (!this.isCommandLine()) {
                s = AnsiUtils.stripAnsi(s);
            }
            try {
                this.getOutputStream().write(this.stringToByteArrayForScriptRunnerNonStatic(s));
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, Messages.getString("ScriptRunnerContext.15"), e);
            }
        } else if (this.isInterrupted() || this.shouldInterrupt()) {
            this.logger.log(Level.INFO, "The command was interrupted.");
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "The following was not written to the Script Runner Result Window as the outputStream was closed:" + s);
        }
    }

    public void writeDisconnectWarning() {
        if (this.getProperty(JLINE_SETTING) == null) {
            this.getMap().put(SqlplusVariable._CONNECT_IDENTIFIER.toString(), (String)this.getProperty(BASECONNECTIONID));
            this.putProperty(BASECONNECTIONID, null);
            this.getMap().put(SqlplusVariable._PRIVILEGE.toString(), null);
            this.write(Messages.getString("WRITEDISCONNECTWARNING") + "\n");
        }
        try {
            this.getOutputStream().flush();
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getStackTrace()[0].toString(), e);
        }
    }

    public void writeln(String s) {
        this.write(s + "\n");
    }

    public <T> T getService(Class<T> type) {
        return this.container.getService(type);
    }

    public Environment getEnvironment() {
        return this.getService(Environment.class);
    }

    public class Parameters {
        public Object getParameter(String setName, String paramName) {
            if (this.getParameters(setName) != null) {
                return this.getParameters(setName).get(paramName);
            }
            return null;
        }

        public Boolean getParameterAsBoolean(String setName, String paramName) {
            if (this.getParameter(setName, paramName) == null) {
                return false;
            }
            if (this.getParameter(setName, paramName) instanceof String) {
                return Boolean.parseBoolean((String)this.getParameter(setName, paramName));
            }
            if (this.getParameter(setName, paramName) instanceof Boolean) {
                return (boolean)((Boolean)this.getParameter(setName, paramName));
            }
            return null;
        }

        public Integer getParameterAsInt(String setName, String paramName) {
            if (this.getParameter(setName, paramName) == null) {
                return null;
            }
            if (this.getParameter(setName, paramName) instanceof String) {
                return Integer.parseInt((String)this.getParameter(setName, paramName));
            }
            if (this.getParameter(setName, paramName) instanceof Integer) {
                return (int)((Integer)this.getParameter(setName, paramName));
            }
            return null;
        }

        public List<String> getParameterAsList(String setName, String paramName) {
            if (this.getParameter(setName, paramName) != null && this.getParameter(setName, paramName) instanceof String) {
                return new ArrayList<String>(Arrays.asList(((String)this.getParameter(setName, paramName)).split(",")));
            }
            return null;
        }

        public String getParameterAsString(String setName, String paramName) {
            if (this.getParameter(setName, paramName) == null) {
                return null;
            }
            if (this.getParameter(setName, paramName) instanceof String) {
                return (String)this.getParameter(setName, paramName);
            }
            return String.valueOf(this.getParameter(setName, paramName));
        }

        public HashMap<String, Object> getParameters(String setName) {
            Object parms = ScriptRunnerContext.this.getProperty(setName);
            if (parms instanceof HashMap) {
                return (HashMap)parms;
            }
            return null;
        }

        public boolean parametersContains(String setName) {
            return ScriptRunnerContext.this.getProperty(setName) != null;
        }

        public boolean setContains(String setName, String paramName) {
            if (this.getParameters(setName) != null) {
                return this.getParameters(setName).get(paramName) != null;
            }
            return false;
        }

        public HashMap<?, ?> initParameters(String setName) {
            HashMap parms = new HashMap();
            ScriptRunnerContext.this.putProperty(setName, parms);
            return parms;
        }

        public void initParametersNull(String setName) {
            ScriptRunnerContext.this.putProperty(setName, null);
        }

        public void printParametersAsRow(String setName) {
            ScriptRunnerContext.this.write("Parameters\n---------------------------------------------\n");
            this.getParameters(setName).forEach((key, value) -> ScriptRunnerContext.this.write(key + "=" + String.valueOf(value) + " "));
            ScriptRunnerContext.this.write("\n---------------------------------------------\nEnd Parameters\n\n");
        }

        public void printParametersAsTable(String setName) {
            this.printParametersAsTable(setName, null);
        }

        public void printParametersAsTable(String setName, Map<String, Object> defaultMap) {
            HashMap<String, Object> getParams = this.getParameters(setName);
            TreeMap<Object, Object> sortedMap = new TreeMap();
            if (getParams != null) {
                sortedMap = new TreeMap<String, Object>(this.getParameters(setName));
            }
            ScriptRunnerContext.this.write("Parameters\n---------------------------------------------\n");
            for (String key : sortedMap.keySet()) {
                if (defaultMap == null || defaultMap.size() == 0) {
                    ScriptRunnerContext.this.write(MessageFormat.format("{0} : {1}\n", this.pad(key, 30), sortedMap.get(key)));
                    continue;
                }
                if (sortedMap.get(key) != defaultMap.get(key)) {
                    ScriptRunnerContext.this.write(MessageFormat.format("{0} : {1}\n", this.pad(key, 30), this.colorNonDefault((String)sortedMap.get(key))));
                    continue;
                }
                ScriptRunnerContext.this.write(MessageFormat.format("{0} : {1}\n", this.pad(key, 30), sortedMap.get(key)));
            }
            ScriptRunnerContext.this.write("---------------------------------------------\nEnd Parameters\n\n");
        }

        private String colorNonDefault(String value) {
            Object ret = "";
            ret = !value.equals("ON") && !value.equals("NEVER") ? "\u001b[0;33m" + value + "\u001b[0m" : value;
            return ret;
        }

        private String pad(String word, int newLength) {
            while (((String)word).length() < newLength) {
                word = (String)word + " ";
            }
            return word;
        }

        public void putParameter(String setName, final String name, final Object value) {
            if (ScriptRunnerContext.this.getProperty(setName) != null) {
                if (ScriptRunnerContext.this.getProperty(setName) instanceof HashMap) {
                    ((HashMap)ScriptRunnerContext.this.getProperty(setName)).put(name, value);
                } else {
                    this.resetParameters(setName);
                    ((HashMap)ScriptRunnerContext.this.getProperty(setName)).put(name, value);
                }
            } else {
                ScriptRunnerContext.this.putProperty(setName, new HashMap<String, Object>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.put(name, value);
                    }
                });
            }
        }

        public void putParameterSet(String setName, Map<String, Object> map) {
            ScriptRunnerContext.this.putProperty(setName, map);
        }

        public void resetParameters(String setName) {
            this.initParameters(setName);
        }
    }

    public static enum SqlplusVariable {
        _DATE,
        _CONNECT_IDENTIFIER,
        _USER,
        _PRIVILEGE,
        _SQLPLUS_RELEASE,
        _EDITOR,
        _O_VERSION,
        _O_RELEASE,
        _PWD,
        _SQL_ID,
        _PROJECT;

    }

    public static enum COLLATION {
        NEVER,
        ALWAYS,
        NON_DEFAULT;

    }
}

