/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunner;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;

public class JSONWrapBufferedOutputStream
extends WrapListenBufferOutputStream {
    OutputStream _out = null;
    boolean _firstDecoratedLine = true;
    ArrayList<String> _extraStmtInfo = new ArrayList();
    ArrayList<String> _dbmsOutput = new ArrayList();

    public JSONWrapBufferedOutputStream(OutputStream out, ScriptRunnerContext ctx) {
        super(out, ctx);
        this._out = out;
    }

    public void newStmt() {
        this._firstDecoratedLine = true;
    }

    public void write(byte[] b, boolean decorate) throws IOException {
        this.checkForExit();
        if (decorate && this.shouldDecorate(b)) {
            super.write(this.decorate(b));
        } else {
            super.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkForExit();
        byte[] subArray = Arrays.copyOfRange(b, off, len);
        if (this.shouldDecorate(subArray)) {
            byte[] decorated = this.decorate(subArray);
            super.write(decorated, 0, decorated.length);
        } else {
            super.write(b, off, len);
        }
    }

    private boolean shouldDecorate(byte[] b) {
        try {
            if (Arrays.equals("force_print".getBytes("UTF8"), b) || Arrays.equals(ScriptRunner.FORCE_PRINT_BYTES, b)) {
                return false;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, true);
    }

    private byte[] decorate(byte[] b) {
        try {
            if (this._firstDecoratedLine) {
                this._firstDecoratedLine = false;
                return JSONWrapBufferedOutputStream.quote(new String(b, "UTF-8"), true).getBytes("UTF-8");
            }
            return ("," + JSONWrapBufferedOutputStream.quote(new String(b, "UTF-8"), true)).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return b;
        }
    }

    @Override
    public void close() throws IOException {
        super.flush();
        if (!((Boolean)this.getScriptRunnerContext().getProperty("script.runner.using.systemout")).booleanValue()) {
            super.close();
        }
    }

    public void addStmtInfo(String errorInfo) {
        if (!this._extraStmtInfo.contains(errorInfo)) {
            this._extraStmtInfo.add(errorInfo);
        }
    }

    public void writeExtraInfo() {
        try {
            for (String extraStmtInfo : this._extraStmtInfo) {
                if (extraStmtInfo == null || extraStmtInfo.trim().equals("")) continue;
                this.write(",".getBytes("UTF-8"), false);
                this.write(extraStmtInfo.getBytes("UTF-8"), false);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
        }
        finally {
            this._extraStmtInfo.clear();
        }
    }

    public static String quote(String string, boolean addQuotes) {
        if (string == null || string.length() == 0) {
            if (addQuotes) {
                return "\"\"";
            }
            return "";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        if (addQuotes && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            addQuotes = false;
        }
        if (addQuotes) {
            sb.append('\"');
        }
        block9: for (int i = 0; i < len; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    if (addQuotes) {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        if (addQuotes) {
            sb.append('\"');
        }
        return sb.toString();
    }

    public ArrayList<String> getExtraInfo() {
        return this._extraStmtInfo;
    }
}

