/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.util.Set;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLStatementTypes;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;

public class CoreScriptParser {
    static final int INITIAL = 0;
    static final int INSINGLELINECOMMENT = 1;
    static final int INMULTILINECOMMENT = 2;
    static final int INALIAS = 3;
    static final int INSINGLEQUOTE = 4;
    static final int INQUOTEDQUOTE = 5;
    private int m_state = 0;
    private boolean m_firstLine = true;
    private StringBuilder m_lastLine = new StringBuilder();
    private String m_quoteString = "";
    private String m_leftOver = null;
    private String m_setLeftOver = null;
    protected ISQLCommand createRefine = null;
    protected boolean createRefineReturnOnSemicolon = false;
    protected boolean createRefineSemiColonTerminates = false;
    protected StringBuffer createRefineLineSoFar = null;
    private static String[][] m_startAndEnd = new String[][]{{"", "", "0"}, {"--", "\n", "1"}, {"/*", "*/", "2"}, {"\"", "\"", "3"}, {"'", "'", "4"}, {"q'", "'", "5"}};

    public CoreScriptParser() {
        this.standaloneConfig();
    }

    public void standaloneConfig() {
        this.initialiseState();
        this.m_firstLine = true;
        this.m_quoteString = "";
        this.m_leftOver = null;
        this.m_setLeftOver = null;
        this.m_lastLine.setLength(0);
        this.createRefine = null;
        this.createRefineReturnOnSemicolon = false;
        this.createRefineSemiColonTerminates = false;
        this.createRefineLineSoFar = null;
    }

    public boolean incrementalOkForSubst(ISQLCommand cmd, String inString, boolean concat, boolean withNewline) {
        this.numberOfQuotes(inString, concat, withNewline);
        return this.okForSubst(cmd);
    }

    public static boolean amIInitial(String inString, boolean concat, boolean withNewline) {
        CoreScriptParser coreParse = new CoreScriptParser();
        coreParse.standaloneConfig();
        coreParse.numberOfQuotes(inString, true, withNewline);
        return coreParse.okForAt();
    }

    public static String getEndQuoteString(String inQuote) {
        String retVal = inQuote;
        if (retVal.equals("[")) {
            retVal = "]";
        } else if (retVal.equals("{")) {
            retVal = "}";
        } else if (retVal.equals("<")) {
            retVal = ">";
        } else if (retVal.equals("(")) {
            retVal = ")";
        }
        return retVal;
    }

    public String stripLine(String line) {
        String comp = line;
        comp = comp.replaceAll("/\\*.*\\*/", "");
        comp = comp.replaceAll("--.*?\n", "");
        comp = comp.replaceAll(" ", "");
        comp = comp.replaceAll("\n", "");
        comp = comp.replaceAll("\r", "");
        comp = comp.replaceAll("\t", "");
        comp = comp.toLowerCase();
        return comp;
    }

    protected SQLCommand getPropertiesWhenMulitpleTokensKnown(String line) {
        String strippedLine = this.stripLine(line.trim());
        Set<String> keys = SQLStatementTypes.multiToken.keySet();
        for (String key : keys) {
            if (!strippedLine.startsWith(key)) continue;
            return SQLStatementTypes.multiToken.get(key);
        }
        return null;
    }

    void setFirstLine(String inString, boolean withNewline) {
        if (this.m_firstLine && withNewline && (!(String.valueOf(this.m_lastLine) + inString).replaceAll("\\s+$", "").endsWith("-") || (String.valueOf(this.m_lastLine) + inString).replaceAll("^\\s+", "").startsWith("--"))) {
            this.m_firstLine = false;
        }
    }

    public void initialiseState() {
        this.m_state = 0;
    }

    public boolean stateInitial() {
        return this.m_state == 0;
    }

    public String getLeftOver() {
        return this.m_leftOver;
    }

    public void setLeftOver(String inLeft) {
        this.m_leftOver = inLeft;
    }

    public String getSetLeftOver() {
        return this.m_setLeftOver;
    }

    public void setSetLeftOver(String inLeft) {
        this.m_setLeftOver = inLeft;
    }

    private void createRefineRecalculate() {
        if (this.createRefine == null) {
            return;
        }
        if (this.createRefine.getProperty("CREATEREFINE") == null || this.createRefine.getProperty("CREATEREFINE").equals(Boolean.FALSE)) {
            return;
        }
        if (!(this.createRefine.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CREATE_UNKNOWN) || this.createRefine.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_WITH) && this.createRefine.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQL))) {
            return;
        }
        String stripSoFar = ScriptUtils.stripFirstN(this.createRefineLineSoFar.toString(), 400, true, false);
        SQLCommand command = this.getPropertiesWhenMulitpleTokensKnown(stripSoFar);
        if (command != null && (command.isCreatePLSQLCmd() || command.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_WITH) && command.getStmtType().equals((Object)SQLCommand.StmtType.G_C_PLSQL))) {
            this.createRefineReturnOnSemicolon = false;
            this.createRefineSemiColonTerminates = false;
            this.createRefine.setStmtType(command.getStmtType());
            this.createRefine.setStmtClass(command.getStmtClass());
            this.createRefine.setStmtSubType(command.getStmtSubType());
            this.createRefine.setResultsType(command.getResultsType());
            this.createRefine.setExecutable(command.getExecutable());
            this.createRefine.setRunnable(command.getRunnable());
        }
        this.createRefine.setProperty("CREATEREFINE", Boolean.FALSE);
    }

    public int[] numberOfQuotes(String inString, boolean concat) {
        return this.numberOfQuotes(inString, concat, true);
    }

    public int[] numberOfQuotes(String inString, boolean concat, boolean withNewline) {
        int noOfQuotes = 0;
        int position = 0;
        int embeddedSemicolon = 0;
        int initialSemicolon = -1;
        if ((inString = inString.replaceAll("\r", "")).indexOf(10) != -1) {
            int[] retVal = null;
            int lengthSoFar = 0;
            String[] lineArray = inString.split("\n", -1);
            for (int lineNo = 0; lineNo < lineArray.length; ++lineNo) {
                String s = lineArray[lineNo];
                retVal = lineNo == lineArray.length - 1 ? this.numberOfQuotes(s, concat, withNewline) : this.numberOfQuotes(s, concat);
                noOfQuotes += retVal[0];
                if (this.createRefineReturnOnSemicolon && retVal[2] != -1) {
                    return new int[]{noOfQuotes, retVal[1], retVal[2] + lengthSoFar};
                }
                lengthSoFar = lengthSoFar + s.length() + "\n".length();
            }
            return new int[]{noOfQuotes, retVal[1], retVal[2]};
        }
        while (true) {
            if (this.m_state == 0) {
                int nextSemi;
                int nextMatch;
                int lowestMatch = 100000;
                int matchVal = 0;
                int i = 1;
                for (i = 1; i < m_startAndEnd.length; ++i) {
                    nextMatch = inString.indexOf(m_startAndEnd[i][0], position);
                    if (nextMatch == -1 || nextMatch >= lowestMatch || i == 5 && nextMatch + 2 == inString.length()) continue;
                    lowestMatch = nextMatch;
                    matchVal = i;
                }
                i = 5;
                nextMatch = inString.indexOf("Q'", position);
                if (nextMatch != -1 && nextMatch < lowestMatch && (i != 5 || nextMatch + 2 != inString.length())) {
                    lowestMatch = nextMatch;
                    matchVal = i;
                }
                if (this.createRefine != null && this.createRefine.getProperty("CREATEREFINE") != null && this.createRefine.getProperty("CREATEREFINE").equals(Boolean.TRUE) && this.createRefineReturnOnSemicolon && (nextSemi = inString.indexOf(";", position)) != -1 && nextSemi < lowestMatch) {
                    this.createRefineRecalculate();
                }
                if (this.createRefineReturnOnSemicolon && (nextMatch = inString.indexOf(";", position)) != -1 && nextMatch < lowestMatch) {
                    this.setFirstLine(inString, withNewline);
                    initialSemicolon = nextMatch;
                    this.updateLastLine(withNewline, this.m_lastLine, inString);
                    int[] retval = new int[]{noOfQuotes, 0, initialSemicolon};
                    return retval;
                }
                if (matchVal == 5) {
                    this.m_quoteString = inString.substring(lowestMatch + 2, lowestMatch + 3);
                    this.m_quoteString = CoreScriptParser.getEndQuoteString(this.m_quoteString);
                }
                if (matchVal == 5) {
                    ++noOfQuotes;
                    this.m_state = 5;
                    position = lowestMatch + 3;
                    continue;
                }
                if (matchVal == 4) {
                    ++noOfQuotes;
                    this.m_state = 4;
                    position = lowestMatch + 1;
                    continue;
                }
                if (matchVal == 1 && this.m_firstLine && withNewline && inString.substring(lowestMatch).replaceAll("\\s+$", "").equals("--") && !(String.valueOf(this.m_lastLine) + inString).replaceAll("\\s+$", "").replaceAll("^\\s+", "").equals("--")) {
                    position = lowestMatch + 1;
                    continue;
                }
                if (matchVal == 0) {
                    this.setFirstLine(inString, withNewline);
                    this.updateLastLine(withNewline, this.m_lastLine, inString);
                    int[] retval = new int[]{noOfQuotes, 0, initialSemicolon};
                    return retval;
                }
                this.m_state = matchVal;
                position = lowestMatch + m_startAndEnd[matchVal][0].length();
                continue;
            }
            Object endString = m_startAndEnd[this.m_state][1];
            if (this.m_state == 5) {
                endString = this.m_quoteString + (String)endString;
            }
            boolean stillGrabbing = false;
            int newPos = inString.indexOf((String)endString, position);
            if (concat && this.m_firstLine && this.m_state == 1) {
                if (newPos == -1 && (!withNewline || withNewline && (String.valueOf(this.m_lastLine) + inString).replaceAll("\\s+$", "").endsWith("-") && !(String.valueOf(this.m_lastLine) + inString).replaceAll("^\\s+", "").startsWith("--"))) {
                    stillGrabbing = true;
                }
                while (newPos != -1) {
                    boolean grabAgain;
                    boolean bl = grabAgain = inString.substring(position, newPos).replaceAll("\\s+$", "").endsWith("-") && !(String.valueOf(this.m_lastLine) + inString).replaceAll("^\\s+", "").startsWith("--");
                    if (!grabAgain) break;
                    if (newPos + 1 <= inString.length()) {
                        newPos = inString.indexOf((String)endString, newPos + 1);
                        continue;
                    }
                    stillGrabbing = true;
                    newPos = -1;
                }
            }
            if (newPos == -1) {
                if (this.m_state == 1 && withNewline) {
                    if (!stillGrabbing) {
                        this.m_state = 0;
                    }
                    if (inString.trim().endsWith(";")) {
                        embeddedSemicolon = 1;
                    }
                } else if (this.m_state != 0 && withNewline && inString.trim().endsWith(";")) {
                    embeddedSemicolon = 1;
                }
                this.setFirstLine(inString, withNewline);
                this.updateLastLine(withNewline, this.m_lastLine, inString);
                int[] retval = new int[]{noOfQuotes, embeddedSemicolon, initialSemicolon};
                return retval;
            }
            position = newPos + ((String)endString).length();
            if (this.m_state == 4 || this.m_state == 5) {
                ++noOfQuotes;
                this.m_quoteString = "";
            }
            this.m_state = 0;
        }
    }

    void updateLastLine(boolean withNewline, StringBuilder lastLine, String inString) {
        if (withNewline) {
            lastLine.setLength(0);
        } else {
            lastLine.append(inString);
        }
    }

    boolean okForAt() {
        return this.m_state == 0;
    }

    boolean okForSubst(ISQLCommand cmd) {
        return cmd.getStmtType().equals((Object)SQLCommand.StmtType.G_C_SQLPLUS) || this.m_state != 1 && this.m_state != 2;
    }
}

