/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.sql.Connection;
import java.util.Arrays;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public abstract class CommandListener {
    public abstract boolean handleEvent(Connection var1, ScriptRunnerContext var2, ISQLCommand var3);

    public abstract void beginEvent(Connection var1, ScriptRunnerContext var2, ISQLCommand var3);

    public abstract void endEvent(Connection var1, ScriptRunnerContext var2, ISQLCommand var3);

    public void beginScript(Connection conn, ScriptRunnerContext ctx) {
    }

    public void endScript(Connection conn, ScriptRunnerContext ctx) {
    }

    public boolean requiresDatabase(Connection conn, ScriptRunnerContext ctx) {
        return true;
    }

    public Type getParserType() {
        return null;
    }

    public boolean startsWithAlias(String cmd, String[] aliases) {
        if (cmd == null || cmd.trim().length() == 0) {
            return false;
        }
        String[] pieces = cmd.trim().split("\\s+");
        return Arrays.stream(aliases).anyMatch(pieces[0]::equalsIgnoreCase);
    }

    public static boolean matches(String cmd, String userCmd) {
        String baseCmd = cmd.length() > 4 ? cmd.substring(0, 4) : cmd;
        StringBuilder regex = new StringBuilder();
        regex.append("(?i:" + baseCmd + "(?i:");
        for (int i = 4; i < cmd.length(); ++i) {
            regex.append("|" + cmd.substring(4, i + 1));
        }
        regex.append("))($| .*)");
        return userCmd.trim().matches(regex.toString());
    }
}

