/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metadata;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.metadata.AbstractObjectAction;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.scripting.Script;

public abstract class AbstractDisplayModel<DM extends AbstractDisplayModel<DM, OA>, OA extends AbstractObjectAction<?>> {
    protected List<OA> m_actions = null;
    protected List<DM> m_children = null;
    protected ClassLoader m_cl = null;
    protected Connection m_conn = null;
    protected Object m_customValue = null;
    protected Version m_dbVersion = null;
    protected Script m_deleteScript = null;
    protected String m_description = null;
    protected String m_drillClass = null;
    protected Boolean m_enable = Boolean.TRUE;
    protected Map<String, String> m_extAttrs = null;
    protected Map<String, String> m_extValues = null;
    protected String m_iconName = null;
    protected Icon m_icon = null;
    protected String m_id = null;
    protected Script m_insertScript = null;
    protected String m_name = null;
    protected boolean m_noRefresh = false;
    protected DM m_parent;
    protected String m_path = null;
    protected List<Query> m_queries = null;
    protected List<Bind> m_queriesBinds = null;
    protected Map<String, Object> m_queriesBindMap = null;
    protected String m_style = null;
    protected String m_tooltip = null;
    protected String m_type = null;
    protected Script m_updateScript = null;
    protected String m_connType = "Oracle";
    protected String m_objectType = null;

    public void addQuery(Query query) {
        if (this.m_queries == null) {
            this.m_queries = new ArrayList<Query>();
        }
        this.m_queries.add(query);
    }

    public void addChild(DM child) {
        if (child != null) {
            if (this.getChildren() == null) {
                this.setChildren(new ArrayList());
            }
            this.getChildren().add(child);
            child.setParent((AbstractDisplayModel)this);
        }
    }

    public String getName() {
        return this.m_name == null || this.m_name.equals("null") ? "" : this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setActions(List<OA> actions) {
        this.m_actions = actions;
    }

    public List<OA> getActions() {
        return this.m_actions;
    }

    protected Version getDbVersion() {
        return this.m_dbVersion;
    }

    protected void setDbVersion(Connection conn) {
        this.m_dbVersion = conn != null ? VersionTracker.getDbVersion(DefaultConnectionIdentifier.createIdentifier(conn)) : null;
    }

    public Boolean getEnable() {
        return this.m_enable;
    }

    public void setEnable(String enable) {
        this.setEnable(Boolean.parseBoolean(enable));
    }

    public void setEnable(Boolean enable) {
        this.m_enable = enable;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getToolTip() {
        return this.m_tooltip;
    }

    public void setToolTip(String tooltip) {
        this.m_tooltip = tooltip;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public void setIcon(Icon icon) {
        this.m_icon = icon;
    }

    public String getDrillClass() {
        return this.m_drillClass;
    }

    public void setDrillClass(String drillClass) {
        this.m_drillClass = drillClass;
    }

    public String getType() {
        if (this.m_type == null) {
            return "Child";
        }
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String getStyle() {
        if (this.m_style == null) {
            if (!this.isChangeable()) {
                return "Table";
            }
            return "UpdableTable";
        }
        return this.m_style;
    }

    public boolean isChangeable() {
        return this.m_insertScript != null || this.m_updateScript != null || this.m_deleteScript != null;
    }

    public boolean isChild() {
        return this.getType().equals("Child");
    }

    public void setStyle(String style) {
        this.m_style = style;
    }

    public void setCustomValue(Object customValue) {
        this.m_customValue = customValue;
    }

    public Object getCustomValue() {
        return this.m_customValue;
    }

    public List<Query> getQueries() {
        return this.m_queries;
    }

    public void setQueries(List<Query> queries) {
        this.m_queries = queries;
    }

    public List<Bind> getQueriesBinds() {
        return this.m_queriesBinds;
    }

    public void setQueriesBinds(List<Bind> binds) {
        this.m_queriesBinds = binds;
    }

    public Map<String, Object> getQueriesBindMap() {
        return this.m_queriesBindMap;
    }

    public void setQueriesBindMap(Map<String, Object> binds) {
        this.m_queriesBindMap = binds;
    }

    public List<DM> getChildren() {
        return this.m_children;
    }

    public boolean hasChildren() {
        List<DM> children = this.getChildren();
        return children != null && children.size() > 0;
    }

    public void setChildren(List<DM> children) {
        this.m_children = children;
    }

    public Query getQuery() {
        return this.getQuery(false, false, false);
    }

    public Query getQuery(boolean strict) {
        return this.getQuery(false, false, strict);
    }

    protected Query getQuery(boolean prependDBA, boolean cacheOnlyCheck, boolean strict) {
        if (this.m_queries == null) {
            this.m_queries = this.getQueries();
        }
        Query query = QueryUtils.getQuery(this.m_queries, DefaultConnectionIdentifier.createIdentifier(this.m_conn), prependDBA, cacheOnlyCheck);
        if (!strict && query == null && this.m_queries != null && this.m_queries.size() > 0) {
            query = this.m_queries.get(0);
        }
        return query;
    }

    public Map<String, String> getExtAttributes() {
        if (this.m_extAttrs == null) {
            this.m_extAttrs = new HashMap<String, String>();
        }
        return this.m_extAttrs;
    }

    public void setExtAttributes(Map<String, String> attrs) {
        this.m_extAttrs = attrs;
    }

    public Map<String, String> getExtValues() {
        if (this.m_extValues == null) {
            this.m_extValues = new HashMap<String, String>();
        }
        return this.m_extValues;
    }

    public void setExtValues(Map<String, String> values) {
        this.m_extValues = values;
    }

    public String getPath() {
        return this.m_path;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public String getID() {
        return this.m_id;
    }

    public void setID(String id) {
        this.m_id = id;
    }

    public void setIconName(String iconName) {
        this.m_iconName = iconName;
    }

    public String getIconName() {
        return this.m_iconName;
    }

    public DM getParent() {
        return this.m_parent;
    }

    public void setParent(DM parent) {
        this.m_parent = parent;
    }

    public Script getInsertScript() {
        return this.m_insertScript;
    }

    public void setInsertScript(Script insertScript) {
        this.m_insertScript = insertScript;
    }

    public Script getDeleteScript() {
        return this.m_deleteScript;
    }

    public void setDeleteScript(Script deleteScript) {
        this.m_deleteScript = deleteScript;
    }

    public void setUpdateScript(Script updateScript) {
        this.m_updateScript = updateScript;
    }

    public Script getUpdateScript() {
        return this.m_updateScript;
    }

    public void setConnType(String m_connType) {
        this.m_connType = m_connType;
    }

    public String getConnType() {
        return this.m_connType;
    }

    public String getObjectType() {
        return this.m_objectType;
    }

    public void setObjectType(String m_connType) {
        this.m_objectType = m_connType;
    }

    public ClassLoader getCl() {
        if (this.m_cl == null) {
            this.m_cl = this.getClass().getClassLoader();
        }
        return this.m_cl;
    }

    public void setCl(ClassLoader cl) {
        this.m_cl = cl;
    }

    public boolean isNoRefresh() {
        return this.m_noRefresh;
    }

    public void setNoRefresh(Boolean b) {
        this.m_noRefresh = b == null ? Boolean.FALSE : b;
    }
}

