/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extendedtype;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import oracle.dbtools.raptor.extendedtype.GenericBlobType;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.BLOB;
import oracle.sql.BlobDBAccess;

public class BLOBType
extends GenericBlobType {
    protected BLOBType(int sqlType, BLOB origValue) {
        super(sqlType, (Blob)origValue);
    }

    public BLOBType(BLOB blob) {
        this(2004, blob);
    }

    public BLOBType() {
        this((BLOB)null);
    }

    @Override
    public BLOB getOrigValue() {
        return (BLOB)super.getOrigValue();
    }

    public BLOB getOrigBlob() {
        return this.getOrigValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToDb(Connection conn, String tableName, String columnName, String rowId, String rowScn, boolean dataIntegrity, List<String> log) throws SQLException, IOException {
        Statement prep = null;
        URL loadFromURL = this.getLoadFromURL();
        if (loadFromURL != null) {
            this.in = loadFromURL.openStream();
            if (this.in != null) {
                BLOB blob = DataTypesUtil.getTemporaryBLOB(conn);
                try {
                    boolean bl;
                    OutputStream blobOutputStream = null;
                    try {
                        blob.truncate(0L);
                        blobOutputStream = blob.setBinaryStream(1L);
                        int bufferSize = blob.getBufferSize();
                        bufferSize = bufferSize > 0 ? bufferSize : 10240;
                        byte[] buffer = new byte[bufferSize];
                        int nread = -1;
                        while ((nread = this.in.read(buffer)) != -1) {
                            blobOutputStream.write(buffer, 0, nread);
                        }
                        blobOutputStream.flush();
                        StringBuffer sqlBuff = new StringBuffer();
                        sqlBuff.append("UPDATE ").append(tableName).append(" SET ").append(columnName).append("=:value WHERE ROWID=:sqldevrowid");
                        if (dataIntegrity && rowScn != null) {
                            sqlBuff.append(" AND ORA_ROWSCN=:sqldevrowscn");
                        }
                        log.add(sqlBuff.toString());
                        prep = conn.prepareStatement(sqlBuff.toString());
                        prep.setObject(1, blob);
                        prep.setString(2, rowId);
                        if (dataIntegrity && rowScn != null) {
                            prep.setString(3, rowScn);
                        }
                        int updates = prep.executeUpdate();
                        loadFromURL = null;
                        bl = updates == 1;
                    }
                    catch (Throwable throwable) {
                        this.in.close();
                        if (blobOutputStream != null) {
                            blobOutputStream.close();
                        }
                        this.setOrigValue(blob);
                        throw throwable;
                    }
                    this.in.close();
                    if (blobOutputStream != null) {
                        blobOutputStream.close();
                    }
                    this.setOrigValue(blob);
                    return bl;
                }
                finally {
                    try {
                        if (prep != null) {
                            prep.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            try {
                int updates;
                StringBuffer insertEmptySql = new StringBuffer();
                String value = this.isSetNULL() ? "= NULL" : "= EMPTY_BLOB()";
                insertEmptySql.append("UPDATE " + tableName + " SET " + columnName + value + " WHERE ROWID=:sqldevrowid");
                if (dataIntegrity && rowScn != null) {
                    insertEmptySql.append(" AND ORA_ROWSCN=:sqldevrowscn");
                }
                log.add(insertEmptySql.toString());
                prep = conn.prepareStatement(insertEmptySql.toString());
                int i = 0;
                prep.setString(++i, rowId);
                if (dataIntegrity && rowScn != null) {
                    prep.setString(++i, rowScn);
                }
                if ((updates = prep.executeUpdate()) == 1) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (prep != null) {
                        prep.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String selectRowscn(Connection conn, String tableName, String rowId) {
        String selectRowscn = "SELECT ORA_ROWSCN FROM " + tableName + " WHERE ROWID = ?";
        ResultSet rs = null;
        PreparedStatement prep2 = null;
        try {
            prep2 = conn.prepareStatement(selectRowscn);
            prep2.setString(1, rowId);
            rs = prep2.executeQuery();
            if (!rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (prep2 != null) {
                    prep2.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return null;
    }

    @Override
    public void setLoadFromURL(URL url) {
        this.setSuperLoadFromURL(url);
    }

    public InputStream asciiStreamValue() throws SQLException {
        return this.getOrigValue().asciiStreamValue();
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        return this.getOrigValue().bigDecimalValue();
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getOrigValue().binaryStreamValue();
    }

    public boolean booleanValue() throws SQLException {
        return this.getOrigValue().booleanValue();
    }

    public byte byteValue() throws SQLException {
        return this.getOrigValue().byteValue();
    }

    public Reader characterStreamValue() throws SQLException {
        return this.getOrigValue().characterStreamValue();
    }

    public void close() throws SQLException {
        this.getOrigValue().close();
    }

    public Date dateValue() throws SQLException {
        return this.getOrigValue().dateValue();
    }

    public double doubleValue() throws SQLException {
        return this.getOrigValue().doubleValue();
    }

    public float floatValue() throws SQLException {
        return this.getOrigValue().floatValue();
    }

    public void freeTemporary() throws SQLException {
        this.getOrigValue().freeTemporary();
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.getOrigValue().getBinaryOutputStream();
    }

    public OutputStream getBinaryOutputStream(long arg0) throws SQLException {
        return this.getOrigValue().getBinaryOutputStream(arg0);
    }

    public InputStream getBinaryStream(long arg0) throws SQLException {
        return this.getOrigValue().getBinaryStream(arg0);
    }

    public int getBufferSize() throws SQLException {
        return this.getOrigValue().getBufferSize();
    }

    public byte[] getBytes() {
        return this.getOrigValue().getBytes();
    }

    public int getBytes(long arg0, int arg1, byte[] arg2) throws SQLException {
        return this.getOrigValue().getBytes(arg0, arg1, arg2);
    }

    public int getChunkSize() throws SQLException {
        return this.getOrigValue().getChunkSize();
    }

    public OracleConnection getConnection() throws SQLException {
        return this.getOrigValue().getConnection();
    }

    public BlobDBAccess getDBAccess() throws SQLException {
        return this.getOrigValue().getDBAccess();
    }

    public oracle.jdbc.internal.OracleConnection getInternalConnection() throws SQLException {
        return this.getOrigValue().getInternalConnection();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return this.getOrigValue().getJavaSqlConnection();
    }

    public long getLength() {
        return this.getOrigValue().getLength();
    }

    public byte[] getLocator() {
        return this.getOrigValue().getLocator();
    }

    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        return this.getOrigValue().getOracleConnection();
    }

    public InputStream getStream() {
        return this.getOrigValue().getStream();
    }

    public int intValue() throws SQLException {
        return this.getOrigValue().intValue();
    }

    public boolean isConvertibleTo(Class arg0) {
        return this.getOrigValue().isConvertibleTo(arg0);
    }

    public boolean isEmptyLob() throws SQLException {
        return this.getOrigValue().isEmptyLob();
    }

    public boolean isOpen() throws SQLException {
        return this.getOrigValue().isOpen();
    }

    public boolean isTemporary() throws SQLException {
        return this.getOrigValue().isTemporary();
    }

    public long longValue() throws SQLException {
        return this.getOrigValue().longValue();
    }

    public Object makeJdbcArray(int arg0) {
        return this.getOrigValue().makeJdbcArray(arg0);
    }

    public void open(int arg0) throws SQLException {
        this.getOrigValue().open(arg0);
    }

    public int putBytes(long arg0, byte[] arg1, int arg2) throws SQLException {
        return this.getOrigValue().putBytes(arg0, arg1, arg2);
    }

    public int putBytes(long arg0, byte[] arg1) throws SQLException {
        return this.getOrigValue().putBytes(arg0, arg1);
    }

    public void setBytes(byte[] arg0) {
        this.getOrigValue().setBytes(arg0);
    }

    public void setLocator(byte[] arg0) {
        this.getOrigValue().setLocator(arg0);
    }

    public void setPhysicalConnectionOf(Connection arg0) {
        this.getOrigValue().setPhysicalConnectionOf(arg0);
    }

    public void setShareBytes(byte[] arg0) {
        this.getOrigValue().setShareBytes(arg0);
    }

    public byte[] shareBytes() {
        return this.getOrigValue().shareBytes();
    }

    public String stringValue() throws SQLException {
        return this.getOrigValue().stringValue();
    }

    public Timestamp timestampValue() throws SQLException {
        return this.getOrigValue().timestampValue();
    }

    public Time timeValue() throws SQLException {
        return this.getOrigValue().timeValue();
    }

    public Object toJdbc() throws SQLException {
        return this.getOrigValue().toJdbc();
    }

    public void trim(long arg0) throws SQLException {
        this.getOrigValue().trim(arg0);
    }

    @Override
    public InputStream getCharStream() throws SQLException {
        return this.asciiStreamValue();
    }

    @Override
    public String toString() {
        return this.isSetNULL() ? "(NULL BLOB)" : "(BLOB)";
    }
}

