/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStrategySplitMode;
import oracle.dbtools.raptor.datatypes.BindingStyle;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataParameter;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.PLSQLBlockComponent;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingBase;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingSplit;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.Datum;

public class CallableBindingDatumAtName<S extends OracleCallableStatement, P extends DataBinding>
extends CallableBindingBase<S, P> {
    public CallableBindingDatumAtName(BindContext<S> context, P param) {
        this(context, param, param.getDataType());
    }

    public CallableBindingDatumAtName(BindContext<S> context, P param, DataType dataType) {
        this(context, param, dataType, param.getMode());
    }

    public CallableBindingDatumAtName(BindContext<S> context, P param, BindingMode modeOverride) {
        this(context, param, param.getDataType(), modeOverride);
    }

    protected CallableBindingDatumAtName(BindContext<S> context, P param, DataType dataType, BindingMode modeOverride) {
        super(context, param, dataType, modeOverride);
    }

    @Override
    public BindingStyle getBindingStyle(BindingMode mode) {
        if (mode.getEffectiveMode() == BindingMode.IN && this.getByNameBindToken() != null) {
            return BindingStyle.NAME;
        }
        return BindingStyle.POSITION;
    }

    @Override
    public String getBindToken(BindingMode mode) {
        if (this.getBindingStyle(mode) == BindingStyle.NAME) {
            return this.getByNameBindToken();
        }
        return this.getByPositionBindToken();
    }

    @Override
    protected DataValue customOutput() throws SQLException {
        return this.customOutput(this.getBindContext().remapPosition(this.getByPositionBindToken()));
    }

    @Override
    protected PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder builder) {
        String name = this.getParameter().getName();
        if (this.getParameter() instanceof DataParameter) {
            switch (this.getMode()) {
                case RETURN: {
                    builder.addComponent(PLSQLBlockComponent.PreCallWrapper, "%s := ", this.getBindToken(this.getMode()));
                    break;
                }
                default: {
                    builder.addComponent(PLSQLBlockComponent.ParamBinding, name + "=>%s", this.getBindToken(this.getMode()));
                    break;
                }
            }
        } else {
            switch (this.getMode()) {
                case IN: {
                    builder.addComponent(PLSQLBlockComponent.PreCallBlocks, name + " := %s;", this.getBindToken(this.getMode()));
                    break;
                }
                case OUT: {
                    builder.addComponent(PLSQLBlockComponent.PostCallBlocks, "%s := " + name + ";", this.getBindToken(this.getMode()));
                }
            }
        }
        return builder;
    }

    @Override
    protected void customBindIN(DataValue value) throws SQLException {
        if (this.getBindingStyle(this.getMode()) == BindingStyle.NAME) {
            this.customBindIN(value, this.getByNameBindToken());
        } else {
            this.customBindIN(value, this.getBindContext().remapPosition(this.getByPositionBindToken()));
        }
    }

    protected void customBindIN(DataValue value, int pos) throws SQLException {
        Object typedValue;
        Object object = typedValue = value != null ? value.getTypedValue(this.getBindContext().getDataTypeConnectionProvider(), ValueType.DATUM) : null;
        if (typedValue != null) {
            ((OracleCallableStatement)this.getStatement()).setObject(pos, typedValue, this.getDataType().getSqlDataType(ValueType.DATUM));
        } else {
            ((OracleCallableStatement)this.getStatement()).setNull(pos, this.getDataType().getSqlDataType(ValueType.DATUM));
        }
    }

    protected void customBindIN(DataValue value, String name) throws SQLException {
        Object typedValue;
        Object object = typedValue = value != null ? value.getTypedValue(this.getBindContext().getDataTypeConnectionProvider(), ValueType.DATUM) : null;
        if (typedValue != null) {
            ((OracleCallableStatement)this.getStatement()).setObjectAtName(name, typedValue, this.getDataType().getSqlDataType(ValueType.DATUM));
        } else {
            String userTypeName = this.getDataType().getUserDataTypeString();
            if (userTypeName != null) {
                ((OracleCallableStatement)this.getStatement()).setNull(name, this.getDataType().getSqlDataType(ValueType.DATUM), userTypeName);
            } else {
                ((OracleCallableStatement)this.getStatement()).setNull(name, this.getDataType().getSqlDataType(ValueType.DATUM));
            }
        }
    }

    @Override
    protected void customBindOUT() throws SQLException {
        if (this.getBindingStyle(this.getMode()) == BindingStyle.NAME) {
            this.customBindOUT(this.getByNameBindToken());
        } else {
            this.customBindOUT(this.getBindContext().remapPosition(this.getByPositionBindToken()));
        }
    }

    protected void customBindOUT(String bindToken) throws SQLException {
        String userTypeName = this.getDataType().getUserDataTypeString();
        if (userTypeName != null) {
            ((OracleCallableStatement)this.getStatement()).registerOutParameter(bindToken, this.getDataType().getSqlDataType(ValueType.DATUM), userTypeName);
        } else {
            ((OracleCallableStatement)this.getStatement()).registerOutParameter(bindToken, this.getDataType().getSqlDataType(ValueType.DATUM));
        }
    }

    protected void customBindOUT(int pos) throws SQLException {
        String userTypeName = this.getDataType().getUserDataTypeString();
        if (userTypeName != null) {
            ((OracleCallableStatement)this.getStatement()).registerOutParameter(pos, this.getDataType().getSqlDataType(ValueType.DATUM), userTypeName);
        } else {
            ((OracleCallableStatement)this.getStatement()).registerOutParameter(pos, this.getDataType().getSqlDataType(ValueType.DATUM));
        }
    }

    @Override
    protected void customReportBinding(StringBuilder buffer, String nullToken, DataValue value) {
        this.reportBinding(buffer, nullToken, this.getBindToken(this.getMode()), value.getDataType(), this.getMode().getEffectiveMode(), value.getStringValue().toString());
    }

    @Override
    protected BindingStrategySplitMode<S, P> customSplitModeBinding() {
        CallableBindingSplit binding = new CallableBindingSplit(this.getBindContext(), this.getParameter(), this.getDataType(), this.getMode());
        binding.setByNameBindToken(this.getByNameBindToken());
        binding.setByPositionBindToken(this.getByPositionBindToken());
        return binding;
    }

    protected DataValue customOutput(int pos) throws SQLException {
        Datum result;
        block2: {
            result = null;
            try {
                result = ((OracleCallableStatement)this.getStatement()).getOracleObject(pos);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 17021) break block2;
                throw ex;
            }
        }
        return this.getDataType().getDataValue(result);
    }
}

