/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.utils.DataTypesUtil;

public class BOOLEAN
extends Datum {
    private DataValue trueValue = null;
    private DataValue falseValue = null;

    protected BOOLEAN(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataValue getTrueValue() {
        DataValue value = this.trueValue;
        if (value == null) {
            BOOLEAN bOOLEAN = this;
            synchronized (bOOLEAN) {
                value = this.trueValue;
                if (value == null) {
                    this.trueValue = value = this.getDataValue(Boolean.TRUE);
                }
            }
        }
        return this.trueValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataValue getFalseValue() {
        DataValue value = this.falseValue;
        if (value == null) {
            BOOLEAN bOOLEAN = this;
            synchronized (bOOLEAN) {
                value = this.falseValue;
                if (value == null) {
                    this.falseValue = value = this.getDataValue(Boolean.FALSE);
                }
            }
        }
        return this.falseValue;
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        return new StringValue(this.internalStringValue(value.getInternalValue()));
    }

    private String internalStringValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return ((Boolean)value).toString();
        }
        if (value instanceof oracle.sql.BOOLEAN) {
            try {
                return Boolean.valueOf(((oracle.sql.BOOLEAN)value).booleanValue()).toString();
            }
            catch (SQLException e) {
                return Boolean.FALSE.toString();
            }
        }
        String stringValue = DataTypesUtil.stringValue(value, null);
        if (stringValue != null) {
            Boolean boolValue = null;
            try {
                BigDecimal numericValue = new BigDecimal(stringValue);
                boolValue = numericValue.signum() != 0;
            }
            catch (Exception e) {
                boolValue = "true".equalsIgnoreCase(stringValue) || "yes".equalsIgnoreCase(stringValue) || "y".equalsIgnoreCase(stringValue) || "t".equalsIgnoreCase(stringValue);
            }
            return boolValue.toString();
        }
        return Boolean.FALSE.toString();
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        switch (valueType) {
            case DATUM: {
                return new oracle.sql.BOOLEAN((Boolean)value.getInternalValue());
            }
        }
        return super.customTypedValue(connectionProvider, value, valueType, target);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return oracle.sql.BOOLEAN.class;
            }
            case DEFAULT: {
                return Boolean.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return 16;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        if (value instanceof Boolean) {
            return value;
        }
        return Boolean.valueOf(this.internalStringValue(value));
    }

    @Override
    protected String customPlainDataTypeString() {
        return "BOOLEAN";
    }

    @Override
    protected String customBaseDataTypeString() {
        return "BOOLEAN";
    }

    @Override
    public boolean isEnumeration() {
        return true;
    }

    @Override
    public List<DataValue> getEnumerationValues() {
        final DataValue trueValue = this.getTrueValue();
        final DataValue falseValue = this.getFalseValue();
        return new LinkedList<DataValue>(){
            {
                this.add(trueValue);
                this.add(falseValue);
            }
        };
    }
}

