/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalUtil;
import oracle.dbtools.raptor.nls.Messages;
import oracle.dbtools.raptor.nls.OraConstants;
import oracle.dbtools.raptor.nls.OraConversions;
import oracle.sql.Datum;

public abstract class OraTemporalDatum
implements OraConstants,
Cloneable,
Comparable<OraTemporalDatum> {
    public static final String TIMEZONE = "TIMEZONE";
    public static final String TIME = "TIME";
    public static final String SECONDSTIME = "SECONDSTIME";
    public static final String NANOS = "NANOS";
    public static final String PRECISION = "PRECISION";
    public static final String FRACTIONALPRECISION = "FRACTIONALPRECISION";
    private OraTemporalDatumImpl datumImpl;
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final ZoneId UTC_ID = UTC.toZoneId();

    public static final ZoneId getDefaultDatumZone() {
        return ZoneId.systemDefault();
    }

    public static final ZoneId getDefaultDatumZone(ZoneId zone) {
        return zone != null ? zone : OraTemporalDatum.getDefaultDatumZone();
    }

    public static final TimeZone getDefaultTimeZone(TimeZone timezone) {
        return timezone != null ? timezone : TimeZone.getDefault();
    }

    public static final Locale getDefaultLocale(Locale locale) {
        return locale != null ? locale : Locale.getDefault();
    }

    public static final GregorianCalendar getGregorianInstance(TimeZone timezone, Locale locale) {
        return new GregorianCalendar(OraTemporalDatum.getDefaultTimeZone(timezone), OraTemporalDatum.getDefaultLocale(locale));
    }

    protected static final boolean areEqual(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    protected OraTemporalDatum(OraTemporalDatumImpl dataumImpl) {
        this.datumImpl = dataumImpl;
    }

    protected OraTemporalDatumImpl getImpl() {
        return this.datumImpl;
    }

    public final void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.datumImpl.addPropertyChangeListener(pcl);
    }

    public final void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.datumImpl.removePropertyChangeListener(pcl);
    }

    public Datum getDatum() {
        return this.datumImpl.getDatum();
    }

    public final boolean nanosSupported() {
        return this.datumImpl.nanosSupported();
    }

    public final boolean userTimeZoneSupported() {
        return this.datumImpl.userTimeZoneSupported();
    }

    public final boolean localSupported() {
        return this.datumImpl.localSupported();
    }

    public final boolean sessionTimeZoneAdjusted() {
        return this.datumImpl.sessionZoneAdjusted();
    }

    public final Resolution getResolution() {
        return this.datumImpl.getResolution();
    }

    public final void setFractionalPrecision(int precision) {
        if (this.nanosSupported()) {
            this.datumImpl.setFractionalPrecision(precision);
        }
    }

    public final int getFractionalPrecision() {
        return this.datumImpl.getFractionalPrecision();
    }

    public final void setPrecision(Precision precision) {
        this.datumImpl.setPrecision(precision);
    }

    public final Precision getPrecision() {
        return this.datumImpl.getPrecision();
    }

    public final Calendar getCalendar(Calendar target) {
        return this.datumImpl.getCalendar(target);
    }

    @Deprecated
    public final void setCalendar(Calendar calendar) {
        this.setCalendar(calendar, null);
    }

    @Deprecated
    public void setCalendar(Calendar calendar, Integer nanos) {
        this.datumImpl.with(OraConversions.toInstant(calendar, nanos));
    }

    public final ZonedDateTime toZonedDateTime() {
        return this.datumImpl.getZonedDateTime();
    }

    public final ZonedDateTime toSessionZonedDateTime() {
        return this.datumImpl.getSessionZonedDateTime();
    }

    public final Timestamp toTimestamp() {
        return Timestamp.from(this.toInstant());
    }

    public final LocalDateTime toLocalDateTime() {
        return this.datumImpl.toLocalDateTime();
    }

    public final Instant toInstant() {
        return this.datumImpl.toInstant();
    }

    public final Instant toSessionInstant() {
        return this.datumImpl.toSessionInstant();
    }

    public final Timestamp toSessionTimestamp() {
        return Timestamp.from(this.toSessionInstant());
    }

    public final void setToday() {
        this.datumImpl.today();
    }

    public final void setNow() {
        this.datumImpl.now();
    }

    public final void replicate(OraTemporalDatum src) {
        this.datumImpl.replicate(src.getImpl());
    }

    public final void setValue(OraTemporalDatum src) {
        this.datumImpl.setValue(src.getImpl());
    }

    public final void setTimeInMillis(long timeInMillis) {
        this.setTimeInMillis(timeInMillis, null);
    }

    public final void setTimeInMillis(long timeInMillis, Integer nanos) {
        this.datumImpl.with(OraConversions.toInstant(timeInMillis, nanos));
    }

    public final long getTimeInMillis() {
        return this.datumImpl.getTimeInMillis();
    }

    public final void setTime(java.util.Date date) {
        this.setTime(date.toInstant());
    }

    public final void setTime(Instant instant) {
        this.datumImpl.with(instant);
    }

    public final void setTime(LocalDateTime datetime) {
        this.datumImpl.with(datetime);
    }

    public final java.util.Date getTime() {
        return this.toTimestamp();
    }

    public final void setDate(Date date) {
        this.setTime(date);
    }

    public final void setDate(LocalDate datetime) {
        this.datumImpl.with(datetime);
    }

    public final Date getDate() {
        return new Date(this.getTimeInMillis());
    }

    public final void setNanos(int nanos) {
        this.datumImpl.withNano(nanos);
    }

    public final int getNanos() {
        return this.datumImpl.getNano();
    }

    public final TimeZone getTimeZone() {
        return TimeZone.getTimeZone(this.getZone());
    }

    public final ZoneId getZone() {
        return this.datumImpl.getZone();
    }

    public final TimeZone getSessionTimeZone() {
        ZoneId zone = this.getSessionZone();
        return zone != null ? TimeZone.getTimeZone(zone) : null;
    }

    public final ZoneId getSessionZone() {
        return this.datumImpl.getSessionZone();
    }

    public OraTemporalDatum setSessionTimeZone(TimeZone sessionTimeZone) {
        return this.setSessionZone(sessionTimeZone != null ? sessionTimeZone.toZoneId() : null);
    }

    public OraTemporalDatum setSessionZone(ZoneId sessionZoneId) {
        this.datumImpl.setSessionZone(sessionZoneId);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        OraTemporalDatum another = (OraTemporalDatum)obj;
        return OraTemporalDatum.areEqual(this.datumImpl, another.datumImpl);
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + this.datumImpl.hashCode();
        return hash;
    }

    @Override
    public int compareTo(OraTemporalDatum another) {
        int ret = 0;
        if (this != another) {
            ret = this.datumImpl.compareTo(another.datumImpl);
        }
        return ret;
    }

    public Object clone() {
        try {
            OraTemporalDatum other = (OraTemporalDatum)super.clone();
            other.datumImpl = (OraTemporalDatumImpl)this.datumImpl.clone();
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected static abstract class OraTemporalDatumImpl
    implements OraTemporalDatumMetadata,
    OraConstants,
    Cloneable,
    Comparable<OraTemporalDatumImpl> {
        private ZoneId sessionZone;
        private ZonedDateTime resolved;
        private Precision precision;
        private int fractionalPrecision;
        private PropertyChangeSupport changesSupport;

        protected void addPropertyChangeListener(PropertyChangeListener pcl) {
            this.changesSupport.addPropertyChangeListener(pcl);
        }

        protected void removePropertyChangeListener(PropertyChangeListener pcl) {
            this.changesSupport.removePropertyChangeListener(pcl);
        }

        private void fireEpochSecondsChange(long oldSecs, long newSecs) {
            this.changesSupport.firePropertyChange(OraTemporalDatum.SECONDSTIME, oldSecs, newSecs);
        }

        private void fireTimeInMillisChange(long oldMillis, long newMillis) {
            this.changesSupport.firePropertyChange(OraTemporalDatum.TIME, oldMillis, newMillis);
        }

        private void fireNanosChange(int oldNanos, int newNanos) {
            this.changesSupport.firePropertyChange(OraTemporalDatum.NANOS, oldNanos, newNanos);
        }

        private void fireZoneChange(TimeZone oldTZ, TimeZone newTZ) {
            this.changesSupport.firePropertyChange(OraTemporalDatum.TIMEZONE, oldTZ, newTZ);
        }

        private void fireZoneChange(ZoneId oldZI, ZoneId newZI) {
            this.fireZoneChange(TimeZone.getTimeZone(oldZI), TimeZone.getTimeZone(newZI));
        }

        private void firePrecisionChange(Precision oldPrecision, Precision newPrecision) {
            this.changesSupport.firePropertyChange(OraTemporalDatum.PRECISION, (Object)oldPrecision, (Object)newPrecision);
        }

        private void fireFractionalPrecisionChange(int oldFractionPrecision, int newFractionalPrecision) {
            this.changesSupport.firePropertyChange(OraTemporalDatum.FRACTIONALPRECISION, oldFractionPrecision, newFractionalPrecision);
        }

        protected OraTemporalDatumImpl(ZoneId datumZone) {
            this(ZonedDateTime.now(OraTemporalDatum.getDefaultDatumZone(datumZone)));
        }

        protected OraTemporalDatumImpl(Instant instant, ZoneId datumZone) {
            this(instant.atZone(OraTemporalDatum.getDefaultDatumZone(datumZone)));
        }

        protected OraTemporalDatumImpl(LocalDateTime ldt, ZoneId datumZone) {
            this(ZonedDateTime.of(ldt, OraTemporalDatum.getDefaultDatumZone(datumZone)));
        }

        protected OraTemporalDatumImpl(ZonedDateTime zdt) {
            this.resolved = zdt;
            this.sessionZone = null;
            this.precision = Precision.NANOSECOND;
            this.fractionalPrecision = 9;
            this.changesSupport = new PropertyChangeSupport(this);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            OraTemporalDatumImpl another = (OraTemporalDatumImpl)obj;
            return this.resolved.equals(another.resolved);
        }

        public int hashCode() {
            int hash = 7;
            hash = hash * 31 + this.resolved.hashCode();
            hash = hash * 31 + this.precision.hashCode();
            hash = hash * 31 + Integer.valueOf(this.fractionalPrecision).hashCode();
            return hash;
        }

        @Override
        public int compareTo(OraTemporalDatumImpl another) {
            int ret = 0;
            if (this != another) {
                ret = this.resolved.compareTo(another.resolved);
            }
            return ret;
        }

        public Change replicate(OraTemporalDatumImpl src) {
            Change a = this.setPrecision(src.getPrecision());
            Change b = this.setFractionalPrecision(src.getFractionalPrecision());
            this.sessionZone = src.sessionZone;
            return Change.combine(a, b);
        }

        public abstract Change setValue(OraTemporalDatumImpl var1);

        public Object clone() {
            try {
                OraTemporalDatumImpl other = (OraTemporalDatumImpl)super.clone();
                other.resolved = this.resolved;
                other.precision = this.precision;
                other.fractionalPrecision = this.fractionalPrecision;
                other.sessionZone = this.sessionZone;
                other.changesSupport = new PropertyChangeSupport(other);
                return other;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public abstract Resolution getResolution();

        public abstract boolean sessionZoneAdjusted();

        public abstract Datum getDatum();

        public final ZoneId getSessionZone() {
            return this.sessionZone;
        }

        public final int getFractionalPrecision() {
            return this.fractionalPrecision;
        }

        public final Precision getPrecision() {
            return this.precision;
        }

        public final Calendar getCalendar(Calendar target) {
            target.setTimeZone(TimeZone.getTimeZone(this.getZone()));
            target.setTimeInMillis(this.getTimeInMillis());
            return target;
        }

        protected final Calendar getCalendar() {
            return this.getCalendar(new GregorianCalendar());
        }

        public final ZonedDateTime getZonedDateTime() {
            return this.resolved;
        }

        public ZonedDateTime getSessionZonedDateTime() {
            return this.getZonedDateTime();
        }

        public Instant toInstant() {
            return this.getZonedDateTime().toInstant();
        }

        public Instant toSessionInstant() {
            return this.getSessionZonedDateTime().toInstant();
        }

        public LocalDateTime toLocalDateTime() {
            return this.getZonedDateTime().toLocalDateTime();
        }

        public LocalDate toLocalDate() {
            return this.toLocalDateTime().toLocalDate();
        }

        public final ZoneId getZone() {
            return this.getZonedDateTime().getZone();
        }

        public final int getNano() {
            return this.toInstant().getNano();
        }

        public final long getSecondsInMillis() {
            return this.getTimeInMillis() / 1000L * 1000L;
        }

        public final long getTimeInMillis() {
            return this.toInstant().toEpochMilli();
        }

        public Change setSessionZone(ZoneId sessionZone) {
            this.sessionZone = sessionZone;
            return Change.NONE;
        }

        public Change setFractionalPrecision(int precision) {
            if (precision < 0 || precision > 9 || precision > this.precision.getMaxFractionalSecondPrecision()) {
                throw new IllegalArgumentException(Messages.getString("OraSimpleDATEFormat.65"));
            }
            Change change = Change.NONE;
            if (precision != this.fractionalPrecision) {
                int oldPrecision = this.fractionalPrecision;
                this.fractionalPrecision = precision;
                if (precision < oldPrecision) {
                    change = this.recompute();
                }
                this.fireFractionalPrecisionChange(oldPrecision, precision);
            }
            return change;
        }

        public Change setPrecision(Precision precision) {
            Change change = Change.NONE;
            if (precision != this.precision) {
                int maxFractrionalPrecision = precision.getMaxFractionalSecondPrecision();
                if (this.getFractionalPrecision() > maxFractrionalPrecision) {
                    this.setFractionalPrecision(maxFractrionalPrecision);
                }
                Precision oldPrecision = this.precision;
                this.precision = precision;
                if (precision.ordinal() > oldPrecision.ordinal()) {
                    change = this.recompute();
                }
                this.firePrecisionChange(oldPrecision, precision);
            }
            return change;
        }

        public Change setZonedDateTime(ZonedDateTime newZDT) {
            Change change;
            ZonedDateTime oldZDT = this.resolved;
            Instant oldInstant = oldZDT.toInstant();
            ZoneId oldZone = oldZDT.getZone();
            Change instantChange = Change.NONE;
            Change zoneChange = Change.NONE;
            ZoneId candidateZone = newZDT.getZone();
            Instant candidateInstant = OraTemporalUtil.round(newZDT.toInstant(), this.getFractionalPrecision());
            if (this.getPrecision() != Precision.NANOSECOND) {
                GregorianCalendar candidateCal = new GregorianCalendar(TimeZone.getTimeZone(candidateZone));
                candidateCal.setTimeInMillis(candidateInstant.toEpochMilli());
                candidateInstant = OraTemporalUtil.truncate(candidateCal, candidateInstant, this.getPrecision());
            }
            if (!candidateInstant.equals(oldInstant)) {
                instantChange = Change.INSTANT;
            }
            if (!candidateZone.equals(oldZone)) {
                zoneChange = Change.ZONE;
            }
            if ((change = Change.combine(instantChange, zoneChange)) != Change.NONE) {
                this.resolved = ZonedDateTime.ofInstant(candidateInstant, candidateZone);
                if (zoneChange != Change.NONE) {
                    this.fireZoneChange(oldZone, candidateZone);
                }
                if (instantChange != Change.NONE) {
                    boolean nanochanged;
                    boolean millischanged = oldInstant.toEpochMilli() != candidateInstant.toEpochMilli();
                    boolean secschanged = oldInstant.getEpochSecond() != candidateInstant.getEpochSecond();
                    boolean bl = nanochanged = oldInstant.getNano() != candidateInstant.getNano();
                    if (secschanged) {
                        this.fireEpochSecondsChange(oldInstant.getEpochSecond(), candidateInstant.getEpochSecond());
                    }
                    if (millischanged) {
                        this.fireTimeInMillisChange(oldInstant.toEpochMilli(), candidateInstant.toEpochMilli());
                    }
                    if (nanochanged) {
                        this.fireNanosChange(oldInstant.getNano(), candidateInstant.getNano());
                    }
                }
            }
            return change;
        }

        public Change today() {
            return this.with(ZonedDateTime.now(this.getZone()).toLocalDate());
        }

        public Change now() {
            return this.with(Instant.now());
        }

        public Change with(Instant instant) {
            return this.setZonedDateTime(this.getZonedDateTime().with(instant));
        }

        public Change with(LocalDateTime ldt) {
            return this.setZonedDateTime(this.getZonedDateTime().with(ldt));
        }

        public Change with(LocalDate ld) {
            return this.with(LocalDateTime.of(ld, this.getZonedDateTime().toLocalTime()));
        }

        public Change withZoneSameInstant(ZoneId zone) {
            return this.setZonedDateTime(this.getZonedDateTime().withZoneSameInstant(zone));
        }

        public Change withZoneSameLocal(ZoneId zone) {
            return this.setZonedDateTime(OraTemporalUtil.withZoneSameLocal(this.getCalendar(), this.toInstant(), zone));
        }

        public Change withNano(int nano) {
            return this.setZonedDateTime(this.getZonedDateTime().withNano(nano));
        }

        public Change recompute() {
            return this.setZonedDateTime(this.getZonedDateTime());
        }

        protected final void packDatumBytes(byte[] bytes) {
            this.packDatumBytes(bytes, 9);
        }

        protected void packDatumBytes(byte[] bytes, int fractionalPrecision) {
            this.packDatumBytes(bytes, this.toInstant(), fractionalPrecision, this.getZone());
        }

        protected final void packDatumBytes(byte[] bytes, Instant instant, ZoneId zone) {
            this.packDatumBytes(bytes, instant, 9, zone);
        }

        protected void packDatumBytes(byte[] bytes, Instant instant, int fractionalPrecision, ZoneId zone) {
            OraTemporalUtil.packDatumBytes(bytes, instant, fractionalPrecision, zone);
        }

        static ZonedDateTime unpackTemporalDatum(byte[] bytes, int fractionPrecision, ZoneId zone) {
            return OraTemporalUtil.unpackDatumBytes(bytes, fractionPrecision, zone);
        }

        static ZonedDateTime unpackTemporalDatum(byte[] bytes, ZoneId zone) {
            return OraTemporalDatumImpl.unpackTemporalDatum(bytes, 9, zone);
        }

        static ZonedDateTime unpackTemporalDatum(byte[] bytes) {
            return OraTemporalDatumImpl.unpackTemporalDatum(bytes, UTC_ID);
        }
    }

    public static enum Resolution {
        LOCAL,
        INSTANT,
        ZONED;

    }

    static enum Change {
        NONE,
        ALL,
        INSTANT,
        ZONE;


        public static Change combine(Change a, Change b) {
            if (a == b) {
                return a;
            }
            if (a == ALL || b == ALL) {
                return ALL;
            }
            if (a == NONE) {
                return b;
            }
            if (b == NONE) {
                return a;
            }
            return ALL;
        }
    }

    public static enum Precision {
        NANOSECOND(1.0E-6, 9),
        MICROSECOND(0.001, 6),
        MILLISECOND(1, 3),
        SECOND(1000, 0),
        MINUTE(60000, 0),
        DATE(86400000, 0);

        private final int milliSecondFactor;
        private final int nanoSecondFactor;
        private final int maxSecondPrecision;

        private Precision(int milliSecondFactor, int maxSecondPrecision) {
            this.milliSecondFactor = milliSecondFactor;
            this.nanoSecondFactor = milliSecondFactor * 1000000;
            this.maxSecondPrecision = maxSecondPrecision;
        }

        private Precision(double milliSecondFactor, int maxSecondPrecision) {
            this.milliSecondFactor = milliSecondFactor < 1.0 ? 0 : new Double(milliSecondFactor).intValue();
            this.nanoSecondFactor = new Double(milliSecondFactor * 1000000.0).intValue();
            this.maxSecondPrecision = maxSecondPrecision;
        }

        public int getMilliSecondFactor() {
            return this.milliSecondFactor;
        }

        public int getNanoSecondFactor() {
            return this.nanoSecondFactor;
        }

        public int getMaxFractionalSecondPrecision() {
            return this.maxSecondPrecision;
        }
    }

    public static interface OraTemporalDatumMetadata {
        public boolean nanosSupported();

        public boolean userTimeZoneSupported();

        public boolean localSupported();
    }
}

