/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes;

import java.text.MessageFormat;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeArb;
import oracle.dbtools.raptor.datatypes.DataTypeException;
import oracle.dbtools.raptor.datatypes.DataValue;

public class DataTypeMarshallingException
extends DataTypeException {
    private static final long serialVersionUID = 1L;

    public DataTypeMarshallingException(DataValue value) {
        super(DataTypeMarshallingException.formatMessage(value.getName(), value.getDataType()));
    }

    public DataTypeMarshallingException(DataValue value, Throwable t) {
        super(DataTypeMarshallingException.formatMessage(value.getName(), value.getDataType()), t);
    }

    public DataTypeMarshallingException(String name, DataType dataType) {
        super(DataTypeMarshallingException.formatMessage(name, dataType));
    }

    public DataTypeMarshallingException(String name, DataType dataType, Throwable t) {
        super(DataTypeMarshallingException.formatMessage(name, dataType), t);
    }

    private static String formatMessage(String name, DataType dataType) {
        if (name == null) {
            return MessageFormat.format(DataTypeArb.getString("ILLEGAL_DATA_MARSHALL"), dataType.getDataTypeString());
        }
        return MessageFormat.format(DataTypeArb.getString("ILLEGAL_NAMED_DATA_MARSHALL"), dataType.getDataTypeString(), name);
    }
}

