/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.net.URLDecoder;
import java.sql.Connection;
import java.util.Properties;
import oracle.dbtools.db.ConnectionResolverImplementation;
import oracle.dbtools.db.DefaultConnectionResolver;
import oracle.dbtools.util.Logger;

public abstract class ConnectionResolver {
    public static final String ORACLE_TYPE = "Oracle";
    public static final String TIMES_TEN_TYPE = "TimesTen";
    public static final String GENERIC_TYPE = "Generic";

    static void setConnectionResolver(ConnectionResolverImplementation impl) {
        Holder.sInstance = impl;
    }

    public static Connection getConnection(String name) throws Exception {
        return Holder.sInstance.getConnectionImpl(name);
    }

    public static Connection getConnection(String name, boolean reconnect) throws Exception {
        return Holder.sInstance.getConnectionImpl(name, reconnect);
    }

    public static String getConnectionName(Connection conn) {
        return Holder.sInstance.getConnectionNameImpl(conn);
    }

    public static String getDisplayName(String name) {
        String dName = name;
        try {
            String decode = URLDecoder.decode(name, "utf-8");
            int idx = decode.indexOf(35);
            if (idx != -1) {
                dName = decode.substring(idx + 1);
            }
        }
        catch (Exception ex) {
            Logger.severe(ConnectionResolver.class, ex);
        }
        return dName;
    }

    public static String[] getConnectionNames() {
        return Holder.sInstance.getConnNamesImpl();
    }

    public static Properties getConnectionInfo(String name) {
        return Holder.sInstance.getConnectionInfoImpl(name);
    }

    public static boolean isOracle(Connection conn) {
        return Holder.sInstance.isOracleImpl(conn);
    }

    public static boolean isTimesTen(Connection conn) {
        return Holder.sInstance.isTimesTenImpl(conn);
    }

    public static String getConnectionType(Connection conn) {
        return Holder.sInstance.getConnectionTypeImpl(conn);
    }

    public static String getQualifiedConnectionName(String name) {
        return Holder.sInstance.getQualifiedName(name);
    }

    public static Connection getUniqueConnection(String name) throws Exception {
        return Holder.sInstance.getUniqueConnectionImpl(name);
    }

    private static class Holder {
        private static ConnectionResolverImplementation sInstance = new DefaultConnectionResolver();

        private Holder() {
        }
    }
}

