/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.security;

import oracle.dbtools.connections.ReferencePair;
import oracle.dbtools.connections.StringReferencePair;
import oracle.dbtools.connections.security.SecureReferenceData;

public final class SecureReferencePair<T>
extends ReferencePair<SecureReferenceData<T>> {
    private final SecureReferenceData<T> data;

    public static SecureReferencePair<char[]> convertToSecureReference(StringReferencePair ref) {
        String name = ref.getKey();
        String value = ref.getValue();
        SecureReferenceData<char[]> data = SecureReferenceData.buildCredentialReference(value != null ? value.toCharArray() : new char[]{});
        return new SecureReferencePair<char[]>(name, data);
    }

    static <T> SecureReferencePair<T> createSecureReference(String key, SecureReferenceData<T> data) {
        return new SecureReferencePair<T>(key, data);
    }

    private SecureReferencePair(String key, SecureReferenceData<T> data) {
        super(key);
        this.data = data;
    }

    @Override
    public SecureReferenceData<T> getValue() {
        return this.data;
    }
}

