/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.db.ora;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collection;
import java.util.Properties;
import oracle.dbtools.connections.db.AbstractConnectionCreator;
import oracle.dbtools.connections.db.DatabaseProviderHelper;

public abstract class AbstractOracleConnCreator
extends AbstractConnectionCreator {
    protected AbstractOracleConnCreator() {
    }

    @Override
    protected void setCustomProperties(Properties connProps, Properties jdbcProps) {
        String role = connProps.getProperty("role");
        if (this.hasLength(role)) {
            jdbcProps.put("internal_logon", role);
        }
        AbstractOracleConnCreator.setSessionProps(jdbcProps);
        super.setCustomProperties(connProps, jdbcProps);
    }

    private static void addPropertyIfSet(Properties jdbcProps, String sysPropName, String propName) {
        String value = System.getProperty(sysPropName, null);
        if (value != null) {
            AbstractOracleConnCreator.setProperty(jdbcProps, propName, value);
        }
    }

    private static void setSessionProps(Properties jdbcProps) {
        String process;
        AbstractOracleConnCreator.addPropertyIfSet(jdbcProps, "jdbc.terminal", "v$session.terminal");
        AbstractOracleConnCreator.addPropertyIfSet(jdbcProps, "jdbc.machine", "v$session.machine");
        String program = System.getProperty("jdbc.program", null);
        if (program == null) {
            program = DatabaseProviderHelper.getProgramName();
        }
        if (program != null) {
            AbstractOracleConnCreator.setProperty(jdbcProps, "v$session.program", program);
        }
        if ((process = System.getProperty("jdbc.process", null)) == null) {
            String jvm = System.getProperty("java.vm.name");
            if (!(System.getProperty("disablePIDCheck") != null || jvm != null && jvm.equals("OJVM Client VM"))) {
                try {
                    int at;
                    String beanName;
                    RuntimeMXBean rtbean = ManagementFactory.getRuntimeMXBean();
                    if (rtbean != null && (beanName = rtbean.getName()) != null && (at = beanName.indexOf(64)) >= 0) {
                        process = beanName.substring(0, at);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (process != null) {
            AbstractOracleConnCreator.setProperty(jdbcProps, "v$session.process", process);
        }
        AbstractOracleConnCreator.setProperty(jdbcProps, "oracle.net.CONNECT_TIMEOUT", "300000");
    }

    private static void setProperty(Properties jdbcProps, String propName, String value) {
        if (value != null) {
            jdbcProps.setProperty(propName, value);
        }
    }

    public static void main(String[] args) {
        Properties props = new Properties();
        AbstractOracleConnCreator.setSessionProps(props);
        AbstractOracleConnCreator.dumpProps(props);
        System.out.println("\nSystem Properties:");
        AbstractOracleConnCreator.dumpProps(System.getProperties());
    }

    private static void dumpProps(Properties props) {
        for (Object key : props.keySet()) {
            System.out.println(String.valueOf(key) + "\t => \t" + String.valueOf(props.get(key)));
        }
    }

    @Override
    public Collection<String> listAllowedProperties() {
        Collection<String> retval = super.listAllowedProperties();
        retval.add("role");
        retval.add("hostname");
        retval.add("port");
        retval.add("sid");
        return retval;
    }
}

