/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection0;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.app.injection0.SqlInjectionGraph;
import oracle.dbtools.app.injection0.ValueNode;

public class PlsqlType {
    private final PlsqlType subtypeOf;

    public PlsqlType(PlsqlType subtypeOf) {
        this.subtypeOf = subtypeOf;
    }

    public boolean isInjectable() {
        return false;
    }

    public String toString() {
        return "subtype of " + String.valueOf(this.subtypeOf);
    }

    public static class Exception
    extends PlsqlType {
        Exception() {
            super(null);
        }
    }

    public static class Function
    extends PlsqlType {
        String name;
        List<ValueNode.IdentifierNode> parms;
        PlsqlType returnType;
        List<int[]> outParmSafetyParmIndexes;
        int[] returnSafetyParmIndexes;
        List<Boolean> inParmThrowsOnDanger;

        Function(String name, PlsqlType returnType, List<ValueNode.IdentifierNode> parms) {
            super(null);
            this.name = name;
            this.parms = parms;
            this.returnType = returnType;
        }

        Function(String name, PlsqlType returnType, PlsqlType ... posParms) {
            this(name, returnType, posParms.length, false, posParms);
        }

        Function(String name, PlsqlType returnType, int minParms, boolean repeatLastParm, PlsqlType ... posParms) {
            super(null);
            this.name = name;
            this.parms = new ArrayList<ValueNode.IdentifierNode>(posParms.length);
            for (PlsqlType parm : posParms) {
                this.parms.add(new ValueNode.IdentifierNode("PREDEFINED", SqlInjectionGraph.fakeParseNode(-1), "", parm));
            }
            this.returnType = returnType;
            this.outParmSafetyParmIndexes = null;
            this.returnSafetyParmIndexes = new int[posParms.length];
            for (int i = 0; i < posParms.length; ++i) {
                this.returnSafetyParmIndexes[i] = i;
            }
            this.inParmThrowsOnDanger = null;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer(this.name + "(");
            String comma = "";
            for (ValueNode.IdentifierNode parm : this.parms) {
                sb.append(comma + String.valueOf(parm));
                comma = ",";
            }
            sb.append(")");
            if (this.returnType != null) {
                sb.append(": " + String.valueOf(this.returnType));
            }
            return sb.toString();
        }

        public Function returnSafetyDependsOn(int[] parmIndexes) {
            this.returnSafetyParmIndexes = parmIndexes;
            return this;
        }
    }

    static enum DataType {
        PLS_INTEGER(ScalarClass.NUMERIC),
        BINARY_INTEGER(ScalarClass.NUMERIC),
        BINARY_FLOAT(ScalarClass.NUMERIC),
        BINARY_DOUBLE(ScalarClass.NUMERIC),
        NUMBER(ScalarClass.NUMERIC),
        CHAR(ScalarClass.CHARACTER),
        VARCHAR2(ScalarClass.CHARACTER),
        RAW(ScalarClass.CHARACTER),
        NCHAR(ScalarClass.CHARACTER),
        NVARCHAR2(ScalarClass.CHARACTER),
        LONG(ScalarClass.CHARACTER),
        LONG_RAW(ScalarClass.CHARACTER),
        ROWID(ScalarClass.CHARACTER),
        UROWID(ScalarClass.CHARACTER),
        BOOLEAN(ScalarClass.BOOLEAN),
        DATE(ScalarClass.DATETIME_INTERVAL),
        TIMESTAMP(ScalarClass.DATETIME_INTERVAL),
        INTERVAL(ScalarClass.DATETIME_INTERVAL),
        BFILE(ScalarClass.LOB),
        BLOB(ScalarClass.LOB),
        CLOB(ScalarClass.LOB),
        NCLOB(ScalarClass.LOB);

        ScalarClass scalarClass;

        ScalarClass getScalarClass() {
            return this.scalarClass;
        }

        private DataType(ScalarClass scalarClass) {
            this.scalarClass = scalarClass;
        }
    }

    static enum ScalarClass {
        NUMERIC,
        CHARACTER,
        BOOLEAN,
        DATETIME_INTERVAL,
        LOB;

    }

    public static class Scalar
    extends PlsqlType {
        private final DataType dataType;
        private final int size;

        Scalar(DataType dataType, int size) {
            super(null);
            this.dataType = dataType;
            this.size = size;
        }

        Scalar(DataType dataType) {
            this(dataType, -1);
        }

        DataType getDataType() {
            return this.dataType;
        }

        ScalarClass getScalarClass() {
            return this.dataType.getScalarClass();
        }

        int getSize() {
            return this.size;
        }

        boolean sizeSafe(int fromSize) {
            return this.size >= 0 && fromSize >= 0 && fromSize <= this.size;
        }

        @Override
        public boolean isInjectable() {
            return this.getScalarClass() == ScalarClass.CHARACTER;
        }

        @Override
        public String toString() {
            return String.valueOf((Object)this.dataType) + (String)(this.size >= 0 ? " [" + this.size + "]" : "");
        }
    }

    static enum CLASS {
        SCALAR,
        COLLECTION,
        RECORD,
        FUNCTION,
        EXCEPTION;

    }
}

