/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import oracle.dbtools.app.injection.Dotted;
import oracle.dbtools.parser.ParseNode;

public class Loc
implements Comparable<Loc> {
    private LocType locType;
    private boolean synthetic;
    private String syntheticMsg;
    private String file;
    private ParseNode pos;
    Integer linenum;
    private Dotted dotted;

    Loc(ParseNode pos) {
        this.locType = LocType.PARSENODE;
        this.synthetic = false;
        this.pos = pos;
        this.linenum = null;
    }

    Loc(ParseNode pos1, String syntheticMsg) {
        this.locType = LocType.PARSENODE;
        this.pos = pos1;
        this.linenum = null;
        this.synthetic = true;
        this.syntheticMsg = syntheticMsg;
    }

    Loc(Dotted dotted) {
        this.locType = LocType.DBDECL;
        this.dotted = dotted;
    }

    Loc(Dotted dotted, String syntheticMsg) {
        this.locType = LocType.DBDECL;
        this.dotted = dotted;
        this.synthetic = true;
        this.syntheticMsg = syntheticMsg;
    }

    void setLinenum(Integer line) {
        this.linenum = line;
    }

    boolean isSynthetic() {
        return this.synthetic;
    }

    public LocType getLocType() {
        return this.locType;
    }

    public Dotted getDbDecl() {
        assert (this.locType == LocType.DBDECL);
        return this.dotted;
    }

    public ParseNode getParseNode() {
        assert (this.locType == LocType.PARSENODE);
        return this.pos;
    }

    public String getFile() {
        String synMsg = this.synthetic ? " " + (this.syntheticMsg == null ? "synthetic" : this.syntheticMsg) : "";
        switch (this.locType.ordinal()) {
            case 1: {
                return "DB:" + String.valueOf(this.dotted) + synMsg;
            }
            case 0: {
                return (this.file == null ? "" : this.file) + synMsg;
            }
        }
        throw new IllegalStateException("locType=" + String.valueOf((Object)this.locType));
    }

    String getSyntheticMsg() {
        return this.syntheticMsg;
    }

    public String toString() {
        return this.getFile() + (this.linenum == null ? " " + String.valueOf(this.pos) : ":" + this.linenum);
    }

    @Override
    public int compareTo(Loc o) {
        return 0;
    }

    static enum LocType {
        PARSENODE,
        DBDECL;

    }
}

