/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.pushdpopddirs.commands.popd;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Optional;
import oracle.dbtools.extension.pushdpopddirs.commands.Messages;
import oracle.dbtools.extension.pushdpopddirs.service.DirectoryManager;
import oracle.dbtools.extension.pushdpopddirs.utils.FileUtils;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class PopdCommand
extends CommandListener
implements IHelp {
    private final String POPD_CMD = "POPD";

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!this.matches(cmd.getSql())) {
            return false;
        }
        String command = this.handleMinusCase(cmd);
        Type type = this.getParserType();
        Parser parser = new Parser(type, ctx.getEnvironment());
        Optional parsedCommand = parser.parse(command, arg_0 -> ((ScriptRunnerContext)ctx).writeln(arg_0));
        if (parsedCommand.isPresent()) {
            String navParameter = (String)((ParsedCommand)parsedCommand.get()).getParameterValue((Id)Symbol.NAV);
            DirectoryManager directoryManager = (DirectoryManager)ctx.getService(DirectoryManager.class);
            try {
                if (navParameter == null) {
                    String nextDir = directoryManager.getDirectories().peekLast();
                    if (nextDir == null) {
                        ctx.writeln(Messages.getString("POPD_NO_DIRECTORIES_TO_POP"));
                        return true;
                    }
                    if (this.checkDirectoryPermissions(ctx, nextDir)) {
                        directoryManager.popDirectory();
                        FileUtils.changeDirectory(ctx, directoryManager.getCurrentDirectory());
                        directoryManager.printDirectories(ctx, directoryManager.getDirectories());
                    } else {
                        directoryManager.popDirectory();
                        ctx.writeln("popd: Cannot navigate to " + nextDir);
                    }
                } else {
                    this.handleCommandWithParams(navParameter, directoryManager, ctx);
                }
            }
            catch (IOException e) {
                ctx.writeln(e.getMessage());
            }
        }
        return true;
    }

    private void handleCommandWithParams(String navParameter, DirectoryManager directoryManager, ScriptRunnerContext ctx) {
        String navigationSign = navParameter.substring(0, 1);
        String navigationValue = navParameter.substring(1);
        if (!this.isNumber(navigationValue)) {
            try {
                String message = Messages.getString("POPD_INVALID_NUMBER_FORMAT");
                ctx.writeln(MessageFormat.format(message, navigationValue));
            }
            catch (Exception e) {
                ctx.writeln("popd: Invalid number format: " + navigationValue + ". Please use a number (e.g., popd +2)");
            }
            return;
        }
        if (navParameter == null || navParameter.length() < 2) {
            ctx.writeln(Messages.getString("POPD_INVALID_PARAMETER_FORMAT"));
            return;
        }
        if (!navigationSign.equals("+") && !navigationSign.equals("_")) {
            ctx.writeln(Messages.getString("POPD_INVALID_PARAMETER_FORMAT"));
            return;
        }
        int index = Integer.parseInt(navigationValue);
        try {
            if (navigationSign.equals("+") && this.isNumber(navigationValue)) {
                if (index >= directoryManager.getDirectories().size()) {
                    ctx.writeln(Messages.getString("DIRS_NO_SUCH_ENTRY"));
                    return;
                }
                String targetDir = directoryManager.popPlus(index);
                if (!this.checkDirectoryPermissions(ctx, targetDir)) {
                    ctx.writeln(Messages.getString("POPD_PERMISSION_DENIED_REMOVED" + targetDir));
                } else {
                    FileUtils.changeDirectory(ctx, targetDir);
                }
                directoryManager.printDirectories(ctx, directoryManager.getDirectories());
            } else if (navigationSign.equals("_") && this.isNumber(navigationValue)) {
                String targetDir = directoryManager.popMinest(index);
                if (!this.checkDirectoryPermissions(ctx, targetDir)) {
                    ctx.writeln(Messages.getString("POPD_PERMISSION_DENIED_REMOVED" + targetDir));
                } else {
                    FileUtils.changeDirectory(ctx, targetDir);
                }
                directoryManager.printDirectories(ctx, directoryManager.getDirectories());
            } else {
                ctx.writeln(Messages.getString("POPD_PARAMETER_NOT_RECOGNIZED"));
            }
        }
        catch (IndexOutOfBoundsException e) {
            ctx.writeln(Messages.getString("DIRS_NO_SUCH_ENTRY"));
        }
        catch (NumberFormatException e) {
            ctx.writeln(Messages.getString("POPD_INVALID_NUMBER_FORMAT:" + navParameter.substring(1)));
        }
        catch (Exception e) {
            ctx.writeln("popd: An error occurred: " + e.getMessage());
        }
    }

    private boolean isNumber(String navigationValue) {
        return navigationValue.chars().allMatch(Character::isDigit);
    }

    private String handleMinusCase(ISQLCommand command) {
        String trimmedCmd = command.getSql().trim();
        if (trimmedCmd.length() > "POPD".length()) {
            int firstSpaceIndex = 5;
            String parameter = trimmedCmd.substring(5).trim();
            boolean minusIndex = true;
            if (parameter.startsWith("-")) {
                command.setSql("POPD _" + parameter.substring(1));
            }
        }
        return command.getSql();
    }

    public Type createType() {
        return Factory.type((Id)Symbol.POPD).add(Factory.parameter((Id)Symbol.NAV).build()).build();
    }

    public Type getParserType() {
        return this.createType();
    }

    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        return this.createHelpPages(ctx, this.createType()).get(pagePath);
    }

    private HelpPages createHelpPages(ScriptRunnerContext ctx, Type type) {
        return new HelpPagesBuilder(ctx.getEnvironment()).enableColorCode(ctx.isCommandLine()).addHelpContainerFor((Object)this).addPages((Iterable)new CommandPageAssemblers(type, new Type[0])).build();
    }

    private boolean matches(String line) {
        String command;
        String trimmed = line.trim();
        if (trimmed.equalsIgnoreCase(command = this.getCommand())) {
            return true;
        }
        int firstSpace = trimmed.indexOf(" ");
        if (firstSpace > 0) {
            String firstWord = line.substring(0, firstSpace);
            return firstWord.equalsIgnoreCase(command);
        }
        return false;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public String getCommand() {
        return "POPD";
    }

    public boolean isSqlPlus() {
        return false;
    }

    public String getDescription() {
        return Messages.getString("EXTENSION_DESCRIPTION");
    }

    private boolean checkDirectoryPermissions(ScriptRunnerContext ctx, String directoryPath) {
        if (directoryPath == null) {
            ctx.writeln(Messages.getString("POPD_INVALID_DIRECTORY_PATH: null"));
            return false;
        }
        try {
            Path path = Paths.get(directoryPath, new String[0]);
            if (!Files.isReadable(path) || !Files.isExecutable(path)) {
                ctx.writeln(Messages.getString("DIRS_PERMISSION_DENIED: " + directoryPath));
                return false;
            }
            return true;
        }
        catch (InvalidPathException e) {
            ctx.writeln(Messages.getString("POPD_INVALID_DIRECTORY_PATH: " + directoryPath));
            return false;
        }
    }

    public static enum Symbol implements Id
    {
        NAV,
        POPD;

    }
}

