/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.io.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public abstract class FilesMigrator {
    protected final Path sourcePath;
    protected final Path destinationPath;

    protected FilesMigrator(Path sourcePath, Path destinationPath) {
        this.sourcePath = sourcePath;
        this.destinationPath = destinationPath;
    }

    public abstract void migrate() throws IOException;

    public static FilesMigrator filesAndDirectoriesMigrator(Path sourceFolder, Path destinationFolder) {
        return new FilesAndDirectoriesMigrator(sourceFolder, destinationFolder);
    }

    private static class FilesAndDirectoriesMigrator
    extends FilesMigrator {
        private FilesAndDirectoriesMigrator(Path sourceFolder, Path destinationFolder) {
            super(sourceFolder, destinationFolder);
        }

        @Override
        public void migrate() throws IOException {
            if (Files.notExists(this.sourcePath, new LinkOption[0]) || !Files.isDirectory(this.sourcePath, new LinkOption[0])) {
                return;
            }
            if (Files.notExists(this.destinationPath, new LinkOption[0])) {
                Files.createDirectories(this.destinationPath, new FileAttribute[0]);
            }
            Files.walkFileTree(this.sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path destFile = destinationPath.resolve(sourcePath.relativize(file));
                    if (Files.notExists(destFile, new LinkOption[0])) {
                        Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
                        Files.move(file, destFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path destDir = destinationPath.resolve(sourcePath.relativize(dir));
                    Files.createDirectories(destDir, new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (!dir.equals(sourcePath)) {
                        Files.delete(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

