/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.io;

import java.io.Flushable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import oracle.dbtools.core.io.PrintTrait;

abstract class PrintWriterAdaptor {
    private PrintWriterAdaptor() {
    }

    static PrintWriter of(PrintTrait<?> delegate) {
        WriterAdaptor writerAdaptor = new WriterAdaptor(delegate);
        return new PrintWriter(writerAdaptor);
    }

    private static class WriterAdaptor
    extends Writer {
        private final PrintTrait<?> delegate;

        private WriterAdaptor(PrintTrait<?> delegate) {
            this.delegate = delegate;
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void write(int c) throws IOException {
            try {
                this.delegate.write(c);
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this.delegate.write(cbuf);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            try {
                this.delegate.write(cbuf, off, len);
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }

        @Override
        public void write(String str) throws IOException {
            try {
                this.delegate.write(str);
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            try {
                this.delegate.write(str, off, len);
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }

        @Override
        public WriterAdaptor append(CharSequence csq) throws IOException {
            try {
                this.delegate.append(csq);
                return this;
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }

        @Override
        public WriterAdaptor append(CharSequence csq, int start, int end) throws IOException {
            try {
                this.delegate.append(csq, start, end);
                return this;
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }

        @Override
        public WriterAdaptor append(char c) throws IOException {
            try {
                this.delegate.append(c);
                return this;
            }
            catch (UncheckedIOException e) {
                throw e.getCause();
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.delegate instanceof Flushable) {
                ((Flushable)((Object)this.delegate)).flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.delegate instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)this.delegate)).close();
                }
                catch (UncheckedIOException e) {
                    throw e.getCause();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
    }
}

