/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import oracle.dbtools.core.connections.storage.ConnectionCredentials;
import oracle.dbtools.core.io.InputOutputStreams;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.security.pki.OraclePKIProvider;
import oracle.security.pki.OracleWallet;

public final class Wallet {
    private volatile ConnectionCredentials credentials;
    private final OracleWallet oraWallet;

    private Wallet(OracleWallet oraWallet) throws IOException {
        this.oraWallet = oraWallet;
        this.credentials = ConnectionCredentials.of(oraWallet);
    }

    static Wallet createWallet(Path walletPath) throws IOException {
        try (InputStream is = Files.newInputStream(walletPath, new OpenOption[0]);){
            InputOutputStreams streams = InputOutputStreams.instance();
            byte[] buffered = streams.asByteArray(is);
            OracleWallet oracleWallet = new OracleWallet();
            oracleWallet.setWalletArray(streams.asInputStream(buffered), null);
            Wallet wallet = new Wallet(oracleWallet);
            return wallet;
        }
    }

    static Wallet createEmptyWallet() {
        try {
            OracleWallet wallet = new OracleWallet();
            wallet.createSSO();
            return new Wallet(wallet);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Wallet createWallet(OracleWallet wallet) throws IOException {
        return new Wallet(wallet);
    }

    void writeWallet(OutputStream os) throws IOException {
        try (InputStream is = this.oraWallet.getWalletArray(true);){
            InputOutputStreams.instance().copy(is, os);
        }
    }

    public TextSecret getPassword() {
        return this.credentials.password();
    }

    public TextSecret getProxyPassword() {
        return this.credentials.proxyPassword();
    }

    void updateCredentials(String spec, String username, TextSecret pwd) throws IOException {
        this.credentials = this.credentials.modify().password(pwd).build();
        this.credentials.write(this.oraWallet);
    }

    static {
        if (null == Security.getProvider("OraclePKI")) {
            Security.insertProviderAt((Provider)new OraclePKIProvider(), Integer.MAX_VALUE);
        }
    }

    public static final class Credentials {
        private final String userName;
        private final TextSecret password;

        private Credentials(String userName, TextSecret password) {
            this.userName = userName;
            this.password = password;
        }

        public String getUsername() {
            return this.userName;
        }

        public char[] password() {
            return this.password.map(plainText -> Arrays.copyOf(plainText, plainText.length));
        }
    }
}

