/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.storage;

import java.nio.file.Path;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.ConnectionIdentifiers;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;

public abstract class ConnectionReference {
    private final Connections.Identifier identifier;

    public abstract String getConnectionName();

    public final Connections.Identifier getConnectionIdentifier() {
        return this.identifier;
    }

    public abstract String getDbtoolsProperty(String var1);

    public abstract ConnectionDefinition getConnectionDefinition();

    private ConnectionReference(Connections.Identifier identifier) {
        this.identifier = identifier;
    }

    static ConnectionReference of(Path directory) {
        Connections.Identifier identifier = ConnectionIdentifiers.createIdentifier(directory.getFileName().toString());
        return new DeferredReference(identifier, directory);
    }

    static ConnectionReference of(ConnectionDefinition connectionDefinition) {
        return null;
    }

    private static class DeferredReference
    extends ConnectionReference {
        private final ConfigurationProperties dbtoolsProperties;
        private final Path connectionDirectory;

        @Override
        public String getDbtoolsProperty(String propertyName) {
            return this.dbtoolsProperties.getProperty(propertyName);
        }

        @Override
        public ConnectionDefinition getConnectionDefinition() {
            return ConnectionDefinition.createConnectionDefinition(this.connectionDirectory);
        }

        @Override
        public String getConnectionName() {
            String connectionName = this.dbtoolsProperties.getProperty("name");
            return connectionName != null ? connectionName : this.getConnectionIdentifier().toString();
        }

        private DeferredReference(Connections.Identifier identifier, Path connectionDirectory) {
            super(identifier);
            this.connectionDirectory = connectionDirectory;
            Path dbTools = connectionDirectory.resolve("dbtools.properties");
            this.dbtoolsProperties = ConnectionStorage.loadProperties(dbTools);
        }
    }

    private static class DefinitionReference
    extends ConnectionReference {
        private final ConnectionDefinition connectionDefinition;

        private DefinitionReference(ConnectionDefinition definition) {
            super(definition.getIdentifier());
            this.connectionDefinition = definition;
        }

        @Override
        public String getConnectionName() {
            return this.connectionDefinition.getConnectionName();
        }

        @Override
        public String getDbtoolsProperty(String propertyName) {
            return this.connectionDefinition.getDbtoolsProperties().getProperty(propertyName);
        }

        @Override
        public ConnectionDefinition getConnectionDefinition() {
            return this.connectionDefinition;
        }
    }
}

