/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Level;
import oracle.dbtools.core.collections.ConfigurationProperties;
import oracle.dbtools.core.connections.ConnectionIdentifiers;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.connections.storage.PropertyNames;
import oracle.dbtools.core.connections.storage.StoreException;
import oracle.dbtools.core.connections.storage.Wallet;
import oracle.security.pki.OracleWallet;

public final class ConnectionDefinition
implements PropertyNames {
    public static final String CONNECTION_PROPERTIES = "connection.properties";
    public static final String WALLET_FILE = "cwallet.sso";
    public static final String CREDENTIALS_FILE = "credentials.sso";
    public static final String TNSNAMES_FILE = "tnsnames.ora";
    private final Connections.Identifier identifier;
    private final Path connectionDirectory;
    private final ConfigurationProperties dbtoolsProperties;
    private final ConfigurationProperties ojdbcProperties;
    private final Wallet wallet;
    private final boolean hasCertWallet;

    public static Builder builder(Connections.Identifier identifier) {
        return new Builder(identifier);
    }

    static ConnectionDefinition createConnectionDefinition(Path connectionDirectory) {
        ConnectionDefinition definition = null;
        String identifier = connectionDirectory.getFileName().toString();
        Path dbTools = connectionDirectory.resolve("dbtools.properties");
        ConfigurationProperties dbToolsProps = ConnectionStorage.loadProperties(dbTools);
        if (!dbToolsProps.isEmpty()) {
            Builder builder = new Builder(connectionDirectory).dbtoolsProperties(ConnectionStorage.loadProperties(dbTools));
            Path connectionProperties = connectionDirectory.resolve("ojdbc.properties");
            if (!Files.isRegularFile(connectionProperties, new LinkOption[0])) {
                connectionProperties = connectionDirectory.resolve(CONNECTION_PROPERTIES);
            }
            builder = builder.ojdbcProperties(ConnectionStorage.loadProperties(connectionProperties));
            Path credentials = connectionDirectory.resolve(CREDENTIALS_FILE);
            Path certs = connectionDirectory.resolve(WALLET_FILE);
            Path walletFile = null;
            if (Files.isRegularFile(credentials, new LinkOption[0])) {
                walletFile = credentials;
            }
            if (Files.isRegularFile(certs, new LinkOption[0])) {
                builder.hasCertWallet(true);
                if (walletFile == null) {
                    walletFile = certs;
                }
            }
            if (walletFile != null) {
                try {
                    builder = builder.wallet(walletFile);
                }
                catch (IOException e) {
                    ConnectionStorage.LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
            definition = builder.build();
        }
        return definition;
    }

    private ConnectionDefinition(Builder builder) {
        this.identifier = builder.identifier;
        this.connectionDirectory = builder.connectionDirectory;
        this.dbtoolsProperties = builder.dbtools.build();
        this.ojdbcProperties = builder.ojdbc.build();
        this.hasCertWallet = builder.hasCertWallet;
        Wallet defWallet = builder.wallet;
        this.wallet = defWallet != null ? defWallet : Wallet.createEmptyWallet();
    }

    public Connections.Identifier getIdentifier() {
        return this.identifier;
    }

    public ConfigurationProperties getDbtoolsProperties() {
        return this.dbtoolsProperties;
    }

    public ConfigurationProperties getOjdbcProperties() {
        return this.ojdbcProperties;
    }

    public Wallet getWallet() {
        return this.wallet;
    }

    public Path getConnectionDirectory() {
        return this.connectionDirectory;
    }

    public boolean hasCertificateWallet() {
        return this.hasCertWallet;
    }

    public String getConnectionType() {
        String type = null;
        if (this.dbtoolsProperties != null) {
            type = this.dbtoolsProperties.getProperty("type");
        }
        return type != null ? type : "UNKNOWN";
    }

    public String getConnectionName() {
        String name = null;
        if (this.dbtoolsProperties != null) {
            name = this.dbtoolsProperties.getProperty("name");
        }
        return name != null ? name : this.identifier.toString();
    }

    void write(ConnectionStorage store) throws StoreException {
        if (!this.ojdbcProperties.isEmpty()) {
            store.storeObject(this.identifier, "ojdbc.properties", this.ojdbcProperties, ConnectionDefinition::outputProperties);
        }
        if (!this.dbtoolsProperties.isEmpty()) {
            store.storeObject(this.identifier, "dbtools.properties", this.dbtoolsProperties, ConnectionDefinition::outputProperties);
        }
        store.storeObject(this.identifier, CREDENTIALS_FILE, this.wallet, Wallet::writeWallet);
    }

    public static void outputProperties(ConfigurationProperties props, OutputStream out) throws IOException {
        if (!props.isEmpty()) {
            props.write(out);
        }
    }

    public ConnectionDefinition clone(String newIdentifier) {
        this.copyDefinition(newIdentifier);
        return null;
    }

    public ConnectionDefinition clone(String newIdentifier, String username, char[] pwd) {
        this.copyDefinition(newIdentifier);
        return null;
    }

    private void copyDefinition(String newIdentifier) {
    }

    public static class Builder {
        private final ConfigurationProperties.Builder dbtools = ConfigurationProperties.builder();
        private final ConfigurationProperties.Builder ojdbc = ConfigurationProperties.builder();
        private Wallet wallet;
        private final Connections.Identifier identifier;
        private Path connectionDirectory;
        private boolean hasCertWallet;

        private Builder(Path dir) {
            this.connectionDirectory = dir;
            this.identifier = ConnectionIdentifiers.createIdentifier(this.connectionDirectory.getFileName().toString());
        }

        private Builder(Connections.Identifier identifier) {
            this.identifier = identifier;
        }

        public Builder dbtoolsProperties(ConfigurationProperties props) {
            this.dbtools.putAll(props);
            return this;
        }

        public Builder dbtoolsProperty(String key, String value) {
            this.dbtools.put(key, value);
            return this;
        }

        public Builder ojdbcProperties(ConfigurationProperties props) {
            this.ojdbc.putAll(props);
            return this;
        }

        public Builder ojdbcProperty(String key, String value) {
            this.ojdbc.put(key, value);
            return this;
        }

        public Builder wallet(Path wallet) throws IOException {
            this.wallet = Wallet.createWallet(wallet);
            return this;
        }

        public Builder wallet(OracleWallet wallet) throws IOException {
            this.wallet = Wallet.createWallet(wallet);
            return this;
        }

        public Builder hasCertWallet(boolean hasCertWallet) {
            this.hasCertWallet = hasCertWallet;
            return this;
        }

        public ConnectionDefinition build() {
            return new ConnectionDefinition(this);
        }
    }
}

