/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.dbtools.core.collections.Buffer;
import oracle.dbtools.core.collections.HasSize;
import oracle.dbtools.core.collections.HasStream;

public interface Slice<E>
extends HasSize,
HasStream<E>,
Iterable<E> {
    public static <E> Immutable<E> of() {
        return Slice.empty();
    }

    public static <E> Immutable<E> empty() {
        return Base.ArraySlice.empty();
    }

    @SafeVarargs
    public static <E> Immutable<E> of(E ... elements) {
        int size = elements.length;
        if (size == 0) {
            return Slice.empty();
        }
        return new Base.ArraySlice<E>(Arrays.copyOf(elements, size));
    }

    public static <E> Collector<E, Buffer<E>, Immutable<E>> toSlice(Supplier<Buffer<E>> bufferFactory) {
        class SliceCollector
        implements Collector<E, Buffer<E>, Immutable<E>> {
            final /* synthetic */ Supplier val$bufferFactory;

            SliceCollector(Supplier supplier) {
                this.val$bufferFactory = supplier;
            }

            @Override
            public Supplier<Buffer<E>> supplier() {
                return this.val$bufferFactory;
            }

            @Override
            public BiConsumer<Buffer<E>, E> accumulator() {
                return Buffer::add;
            }

            @Override
            public BinaryOperator<Buffer<E>> combiner() {
                return Buffer::add;
            }

            @Override
            public Function<Buffer<E>, Immutable<E>> finisher() {
                return Buffer::slice;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Set.of();
            }
        }
        return new SliceCollector(bufferFactory);
    }

    public static <E> Collector<E, Buffer<E>, Immutable<E>> toSlice() {
        return Slice.toSlice(Buffer::buffer);
    }

    public static <E> Immutable<E> of(Slice<? extends E> elements) {
        return Immutable.copyOf(elements);
    }

    public static <E> Immutable<E> of(Collection<? extends E> elements) {
        int size = elements.size();
        if (size == 0) {
            return Slice.empty();
        }
        Object[] items = elements.toArray();
        return Slice.of(items);
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static int hashCode(Slice<?> slice) {
        if (slice == null) {
            return 0;
        }
        int result = 1;
        for (Object element : slice) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public static boolean equals(Slice<?> expected, Slice<?> actual) {
        if (expected == actual) {
            return true;
        }
        if (expected != null && actual != null && expected.size() == actual.size()) {
            for (int i = 0; i < expected.size(); ++i) {
                Object actualElement;
                Object expectedElement = expected.get(i);
                if (Objects.equals(expectedElement, actualElement = actual.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    default public E first() {
        return this.get(0);
    }

    default public E last() {
        return this.get(this.size() - 1);
    }

    public E get(int var1) throws IndexOutOfBoundsException;

    default public Slice<E> slice(int offset, int length) {
        int size = this.size();
        if (length == 0) {
            return Slice.empty();
        }
        Objects.checkFromIndexSize(offset, length, size);
        return new Base.SubSlice(Immutable.copyOf(this), offset, length);
    }

    default public Slice<E> slice(int offset) {
        return this.slice(offset, this.size() - offset);
    }

    default public Slice<E> slice() {
        return this;
    }

    @Override
    default public Iterator<E> iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    default public String join() {
        return this.join("");
    }

    default public String join(CharSequence delimiter) {
        return this.join(delimiter, "", "");
    }

    default public String join(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.stream().map(Objects::toString).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    @Override
    default public Spliterator<E> spliterator() {
        return new Base.SliceSpliterator(this);
    }

    public static interface Immutable<E>
    extends Slice<E> {
        public static <E> Immutable<E> copyOf(Slice<? extends E> slice) {
            if (slice instanceof Immutable) {
                return (Immutable)slice;
            }
            return Base.of(slice.size(), slice::get);
        }
    }

    public static abstract class Base<E>
    implements Immutable<E> {
        protected Base() {
        }

        static <E> Immutable<E> of(int size, IntFunction<E> getter) {
            if (size == 0) {
                return Slice.empty();
            }
            Object[] elements = new Object[size];
            for (int i = 0; i < size; ++i) {
                E element = getter.apply(i);
                elements[i] = element;
            }
            Object[] items = elements;
            return new ArraySlice<Object>(items);
        }

        public final int hashCode() {
            return Slice.hashCode(this);
        }

        public final boolean equals(Object obj) {
            if (obj != null && Slice.class.isAssignableFrom(obj.getClass())) {
                Slice slice = (Slice)obj;
                return Slice.equals(this, slice);
            }
            return false;
        }

        public String toString() {
            return this.join(",", "[", "]");
        }

        private static class ArraySlice<E>
        extends Base<E> {
            private static final ArraySlice<Object> EMPTY = new ArraySlice<Object>(new Object[0]);
            private final E[] elements;

            ArraySlice(E[] elements) {
                Objects.requireNonNull(elements);
                this.elements = elements;
            }

            @Override
            public E get(int index) throws IndexOutOfBoundsException {
                return this.elements[index];
            }

            @Override
            public int size() {
                return this.elements.length;
            }

            static <E> ArraySlice<E> empty() {
                return EMPTY;
            }
        }

        public static class SliceSpliterator<E>
        extends Spliterators.AbstractSpliterator<E> {
            private final Slice<E> elements;
            private int index;

            protected SliceSpliterator(Slice<E> slice) {
                super(slice.size(), 1104);
                this.elements = slice;
            }

            @Override
            public boolean tryAdvance(Consumer<? super E> action) {
                if (this.index < this.elements.size()) {
                    E element = this.elements.get(this.index);
                    action.accept(element);
                    ++this.index;
                    return true;
                }
                return false;
            }
        }

        private static final class SubSlice<E>
        extends Base<E> {
            private final Immutable<E> buffer;
            private final int offset;
            private final int length;

            private SubSlice(Immutable<E> buffer, int offset, int length) {
                this.buffer = buffer;
                this.offset = offset;
                this.length = length;
            }

            @Override
            public E get(int index) throws IndexOutOfBoundsException {
                Objects.checkIndex(index, this.size());
                int absoluteOffset = this.offset + index;
                return this.buffer.get(absoluteOffset);
            }

            @Override
            public int size() {
                return this.length;
            }
        }
    }

    public static class Builder<E>
    implements Buffer<E> {
        private final List<E> elements = new ArrayList();

        private Builder() {
        }

        @Override
        public Builder<E> add(E element) {
            this.elements.add(element);
            return this;
        }

        @Override
        public Builder<E> add(Iterable<? extends E> elements) {
            Buffer.super.add(elements);
            return this;
        }

        @Override
        public Builder<E> add(Stream<? extends E> elements) {
            Buffer.super.add(elements);
            return this;
        }

        @Override
        public E get(int index) throws IndexOutOfBoundsException {
            return this.elements.get(index);
        }

        @Override
        public Builder<E> clear() {
            this.elements.clear();
            return this;
        }

        @Override
        public Immutable<E> slice() {
            return this.build();
        }

        public Immutable<E> build() {
            return Slice.of(this.elements);
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        public String toString() {
            return this.slice().toString();
        }
    }
}

