/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.OraLanguage;

public class JNLS {
    private static Hashtable m_langGroup = null;
    private static Hashtable m_commonCharsetsEbc = null;
    private static OraBoot m_oraBoot = OraBoot.getInstance();
    private static final String[] m_ncharCharacterSets = new String[]{"AL16UTF16", "UTF8"};
    private static final String[][] m_commonCharsetsUnicode = new String[][]{{"AL32UTF8", "UTF8"}, m_ncharCharacterSets};

    public static String[] getAllLanguage() {
        return m_oraBoot.availableLanguages();
    }

    public static String[] getAllTerritory() {
        return m_oraBoot.availableTerritories();
    }

    public static String getTerritory(String string) {
        return m_oraBoot.getTerritoryName(OraLanguage.getInstance(string).getDefaultTerritoryId());
    }

    public static String getCharset(String string) {
        return m_oraBoot.getCharSetName(OraLanguage.getInstance(string).getDefaultCharSetId());
    }

    public static String[][] getCommonCharsets(String[] stringArray, String string) {
        Object object;
        String[][] stringArrayArray;
        String string2 = null;
        string2 = string == null || string.length() == 0 ? ((stringArrayArray = System.getProperty("os.name")).startsWith("Windows") ? "WINDOWS" : "UNIX") : ((stringArrayArray = string.toUpperCase(Locale.US)).equals("WINDOWS") ? "WINDOWS" : (stringArrayArray.equals("EBCDIC") ? "EBCDIC" : "UNIX"));
        if ("WINDOWS".equals(string2) || "UNIX".equals(string2)) {
            Object object2;
            Serializable serializable;
            int n;
            boolean bl = "WINDOWS".equals(string2);
            if (stringArray == null || stringArray.length == 0) {
                return m_commonCharsetsUnicode;
            }
            String[] stringArray2 = null;
            for (n = 0; n < stringArray.length && stringArray2 == null; ++n) {
                serializable = OraLanguage.getInstance(stringArray[n]);
                if (serializable == null) continue;
                stringArray2 = bl ? ((OraLanguage)serializable).getLocalCharsetsWin() : ((OraLanguage)serializable).getLocalCharacterSets();
            }
            serializable = new ArrayList();
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    serializable.add(stringArray2[i]);
                }
            }
            while (n < stringArray.length) {
                OraLanguage oraLanguage = OraLanguage.getInstance(stringArray[n]);
                if (oraLanguage != null) {
                    String[] stringArray3;
                    String[] stringArray4 = stringArray3 = bl ? oraLanguage.getLocalCharsetsWin() : oraLanguage.getLocalCharacterSets();
                    if (stringArray3 != null) {
                        object2 = new ArrayList();
                        for (int i = 0; i < stringArray3.length; ++i) {
                            object2.add(stringArray3[i]);
                        }
                        serializable.retainAll((Collection<?>)object2);
                    }
                }
                ++n;
            }
            if (serializable.isEmpty()) {
                return m_commonCharsetsUnicode;
            }
            String[] stringArray5 = new String[serializable.size()];
            int n2 = 0;
            object2 = serializable.iterator();
            while (object2.hasNext()) {
                stringArray5[n2] = (String)object2.next();
                ++n2;
            }
            return new String[][]{stringArray5, m_ncharCharacterSets};
        }
        if (m_langGroup == null) {
            m_langGroup = new Hashtable();
            m_langGroup.put("AMERICAN", "ENGLISH");
            m_langGroup.put("GERMAN", "LATIN-1");
            m_langGroup.put("FRENCH", "LATIN-1");
            m_langGroup.put("CANADIAN FRENCH", "LATIN-1");
            m_langGroup.put("SPANISH", "LATIN-1");
            m_langGroup.put("ITALIAN", "LATIN-1");
            m_langGroup.put("DUTCH", "LATIN-1");
            m_langGroup.put("SWEDISH", "LATIN-1");
            m_langGroup.put("NORWEGIAN", "LATIN-1");
            m_langGroup.put("DANISH", "LATIN-1");
            m_langGroup.put("FINNISH", "LATIN-1");
            m_langGroup.put("ICELANDIC", "LATIN-1");
            m_langGroup.put("GREEK", "GREEK");
            m_langGroup.put("PORTUGUESE", "LATIN-1");
            m_langGroup.put("TURKISH", "TURKISH");
            m_langGroup.put("BRAZILIAN PORTUGUESE", "LATIN-1");
            m_langGroup.put("MEXICAN SPANISH", "LATIN-1");
            m_langGroup.put("RUSSIAN", "CYRILLIC");
            m_langGroup.put("POLISH", "LATIN-2");
            m_langGroup.put("HUNGARIAN", "LATIN-2");
            m_langGroup.put("CZECH", "LATIN-2");
            m_langGroup.put("LITHUANIAN", "BALTIC");
            m_langGroup.put("SLOVAK", "LATIN-2");
            m_langGroup.put("CATALAN", "LATIN-1");
            m_langGroup.put("BULGARIAN", "CYRILLIC");
            m_langGroup.put("ROMANIAN", "LATIN-2");
            m_langGroup.put("SLOVENIAN", "LATIN-2");
            m_langGroup.put("HEBREW", "HEBREW");
            m_langGroup.put("EGYPTIAN", "ARABIC");
            m_langGroup.put("CROATIAN", "LATIN-2");
            m_langGroup.put("ARABIC", "ARABIC");
            m_langGroup.put("THAI", "THAI");
            m_langGroup.put("JAPANESE", "JAPANESE");
            m_langGroup.put("KOREAN", "KOREAN");
            m_langGroup.put("SIMPLIFIED CHINESE", "SCHINESE");
            m_langGroup.put("TRADITIONAL CHINESE", "TCHINESE");
            m_langGroup.put("ENGLISH", "ENGLISH");
            m_langGroup.put("LATIN AMERICAN SPANISH", "LATIN-1");
            m_langGroup.put("UKRAINIAN", "CYRILLIC");
            m_langGroup.put("ESTONIAN", "BALTIC");
            m_langGroup.put("GERMAN DIN", "LATIN-1");
            m_langGroup.put("MALAY", "LATIN-1");
            m_langGroup.put("VIETNAMESE", "VIETNAM");
            m_langGroup.put("BENGALI", "UNICODE");
            m_langGroup.put("LATVIAN", "BALTIC");
            m_langGroup.put("INDONESIAN", "LATIN-1");
            m_langGroup.put("HINDI", "UNICODE");
            m_langGroup.put("TAMIL", "UNICODE");
            m_langGroup.put("KANNADA", "UNICODE");
            m_langGroup.put("TELUGU", "UNICODE");
            m_langGroup.put("ORIYA", "UNICODE");
            m_langGroup.put("MALAYALAM", "UNICODE");
            m_langGroup.put("ASSAMESE", "UNICODE");
            m_langGroup.put("GUJARATI", "UNICODE");
            m_langGroup.put("MARATHI", "UNICODE");
            m_langGroup.put("PUNJABI", "UNICODE");
            m_langGroup.put("BANGLA", "UNICODE");
        }
        if (m_commonCharsetsEbc == null) {
            m_commonCharsetsEbc = new Hashtable();
            stringArrayArray = new String[][]{{"WE8EBCDIC37", "WE8EBCDIC284", "WE8EBCDIC285", "WE8EBCDIC500", "WE8EBCDIC871", "WE8EBCDIC1047", "WE8EBCDIC1140", "WE8EBCDIC1145", "WE8EBCDIC1146", "WE8EBCDIC1148", "UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("ENGLISH", stringArrayArray);
            String[][] stringArrayArray2 = new String[][]{{"WE8EBCDIC1140", "WE8EBCDIC37", "WE8EBCDIC284", "WE8EBCDIC285", "WE8EBCDIC500", "WE8EBCDIC871", "WE8EBCDIC1047", "WE8EBCDIC1145", "WE8EBCDIC1146", "WE8EBCDIC1148", "UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("LATIN-1", stringArrayArray2);
            object = new String[][]{{"EE8EBCDIC870", "UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("LATIN-2", object);
            String[][] stringArrayArray3 = new String[][]{{"BLT8EBCDIC1112", "UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("BALTIC", stringArrayArray3);
            String[][] stringArrayArray4 = new String[][]{{"CL8EBCDIC1025", "UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("CYRILLIC", stringArrayArray4);
            String[][] stringArrayArray5 = new String[][]{{"AR8EBCDICX", "AR8EBCDIC420S", "AR8XBASIC", "UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("ARABIC", stringArrayArray5);
            String[][] stringArrayArray6 = new String[][]{{"EL8EBCDIC875", "UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("GREEK", stringArrayArray6);
            String[][] stringArrayArray7 = new String[][]{{"IW8EBCDIC424", "IW8EBCDIC1086", "UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("HEBREW", stringArrayArray7);
            String[][] stringArrayArray8 = new String[][]{{"JA16DBCS", "JA16EBCDIC930", "UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("JAPANESE", stringArrayArray8);
            String[][] stringArrayArray9 = new String[][]{{"KO16DBCS", "UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("KOREAN", stringArrayArray9);
            String[][] stringArrayArray10 = new String[][]{{"ZHS16DBCS", "UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("SCHINESE", stringArrayArray10);
            String[][] stringArrayArray11 = new String[][]{{"TH8TISEBCDIC", "UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("THAI", stringArrayArray11);
            String[][] stringArrayArray12 = new String[][]{{"ZHT16DBCS", "UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("TCHINESE", stringArrayArray12);
            String[][] stringArrayArray13 = new String[][]{{"TR8EBCDIC1026", "UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("TURKISH", stringArrayArray13);
            String[][] stringArrayArray14 = new String[][]{{"UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("VIETNAM", stringArrayArray14);
            String[][] stringArrayArray15 = new String[][]{{"UTFE"}, {"AL16UTF16", "UTF8"}};
            m_commonCharsetsEbc.put("UNICODE", stringArrayArray15);
        }
        stringArrayArray = new Hashtable();
        if (stringArray == null || stringArray.length == 0) {
            stringArrayArray.put("UNICODE", "1");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i] == null ? null : (String)m_langGroup.get(stringArray[i].toUpperCase(Locale.US));
                if (object == null) {
                    object = "UNICODE";
                }
                if (stringArrayArray.containsKey(object)) continue;
                stringArrayArray.put(object, "1");
            }
        }
        String string3 = null;
        if (stringArrayArray.containsKey("UNICODE")) {
            string3 = "UNICODE";
        } else if (stringArrayArray.size() >= 3) {
            string3 = "UNICODE";
        } else if (stringArrayArray.size() == 2) {
            if (stringArrayArray.containsKey("ENGLISH")) {
                stringArrayArray.remove("ENGLISH");
                string3 = (String)stringArrayArray.keys().nextElement();
            } else {
                string3 = "UNICODE";
            }
        } else {
            string3 = (String)stringArrayArray.keys().nextElement();
        }
        return (String[][])m_commonCharsetsEbc.get(string3);
    }

    public static String getCharset(int n) {
        return m_oraBoot.getCharSetName(String.valueOf(n));
    }

    public static int getCharsetID(String string) {
        String string2 = m_oraBoot.getCharSetId(string);
        if (string2 == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public static String[] getAllCharset() {
        return m_oraBoot.availableCharacterSets();
    }

    public static String[] getAsciiCharset() {
        List list = m_oraBoot.getCharSetIsAscii();
        return list.toArray(new String[0]);
    }

    public static String[] getEbcdicCharset() {
        List list = m_oraBoot.getCharSetIsEbcdic();
        return list.toArray(new String[0]);
    }

    public static String[] getFixedCharset() {
        List list = m_oraBoot.getCharSetIsFixed();
        return list.toArray(new String[0]);
    }

    public static String[] getNationalCharset() {
        return new String[]{"UTF8", "AL16UTF16"};
    }

    public static String[] getStorageCharset() {
        List list = m_oraBoot.getCharSetIsStorage();
        return list.toArray(new String[0]);
    }

    public static int getLangID(String string) {
        String string2 = m_oraBoot.getLanguageFileName(string);
        return string2 != null ? Integer.valueOf(string2.substring(2), 16) : -1;
    }

    public static int getLangDirection(int n) {
        String string = m_oraBoot.getLanguageName(Integer.toString(n));
        if (string == null) {
            return 0;
        }
        String string2 = OraLanguage.getInstance(string).getWritingDirection();
        int n2 = string2.indexOf(44);
        if (n2 > 0) {
            string2 = string2.substring(0, n2);
        }
        return "Left_To_Right".equals(string2) ? 0 : 1;
    }
}

