/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.resourcesearch;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.resourcesearch.ResourceSearchAsync;
import com.oracle.bmc.resourcesearch.model.ResourceSummaryCollection;
import com.oracle.bmc.resourcesearch.model.ResourceType;
import com.oracle.bmc.resourcesearch.requests.GetResourceTypeRequest;
import com.oracle.bmc.resourcesearch.requests.ListResourceTypesRequest;
import com.oracle.bmc.resourcesearch.requests.SearchResourcesRequest;
import com.oracle.bmc.resourcesearch.responses.GetResourceTypeResponse;
import com.oracle.bmc.resourcesearch.responses.ListResourceTypesResponse;
import com.oracle.bmc.resourcesearch.responses.SearchResourcesResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceSearchAsyncClient
extends BaseAsyncClient
implements ResourceSearchAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("RESOURCESEARCH").serviceEndpointPrefix("query").serviceEndpointTemplate("https://query.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ResourceSearchAsyncClient.class);

    ResourceSearchAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<GetResourceTypeResponse> getResourceType(GetResourceTypeRequest request, AsyncHandler<GetResourceTypeRequest, GetResourceTypeResponse> handler) {
        Validate.notBlank((String)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetResourceTypeResponse::builder).logger(LOG, "getResourceType").serviceDetails("ResourceSearch", "GetResourceType", "https://docs.oracle.com/iaas/api/#/en/search/20180409/ResourceType/GetResourceType").method(Method.GET).requestBuilder(GetResourceTypeRequest::builder).basePath("/20180409").appendPathParam("resourceTypes").appendPathParam(request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ResourceType.class, GetResourceTypeResponse.Builder::resourceType).handleResponseHeaderString("opc-request-id", GetResourceTypeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListResourceTypesResponse> listResourceTypes(ListResourceTypesRequest request, AsyncHandler<ListResourceTypesRequest, ListResourceTypesResponse> handler) {
        return this.clientCall(request, ListResourceTypesResponse::builder).logger(LOG, "listResourceTypes").serviceDetails("ResourceSearch", "ListResourceTypes", "https://docs.oracle.com/iaas/api/#/en/search/20180409/ResourceType/ListResourceTypes").method(Method.GET).requestBuilder(ListResourceTypesRequest::builder).basePath("/20180409").appendPathParam("resourceTypes").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ResourceType.class, ListResourceTypesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListResourceTypesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListResourceTypesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<SearchResourcesResponse> searchResources(SearchResourcesRequest request, AsyncHandler<SearchResourcesRequest, SearchResourcesResponse> handler) {
        Objects.requireNonNull(request.getSearchDetails(), "searchDetails is required");
        return this.clientCall(request, SearchResourcesResponse::builder).logger(LOG, "searchResources").serviceDetails("ResourceSearch", "SearchResources", "https://docs.oracle.com/iaas/api/#/en/search/20180409/ResourceSummary/SearchResources").method(Method.POST).requestBuilder(SearchResourcesRequest::builder).basePath("/20180409").appendPathParam("resources").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("tenantId", (Object)request.getTenantId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ResourceSummaryCollection.class, SearchResourcesResponse.Builder::resourceSummaryCollection).handleResponseHeaderString("opc-next-page", SearchResourcesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", SearchResourcesResponse.Builder::opcPreviousPage).handleResponseHeaderString("opc-request-id", SearchResourcesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ResourceSearchAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ResourceSearchAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ResourceSearchAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ResourceSearchAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ResourceSearchAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ResourceSearchAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ResourceSearchAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ResourceSearchAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ResourceSearchAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ResourceSearchAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ResourceSearchAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ResourceSearchAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ResourceSearchAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ResourceSearchAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ResourceSearchAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "resourcesearch";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"resourcesearch");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ResourceSearchAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ResourceSearchAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

