/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.diff;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.arbori.util.IO;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

public class TypeInfo {
    Parsed target;
    String name = null;
    List<ParseNode> methods = new LinkedList<ParseNode>();
    List<ParseNode> fields = new LinkedList<ParseNode>();
    Map<ParseNode, ParseNode> fieldsInAlters = new TreeMap<ParseNode, ParseNode>();
    List<ParseNode> extraAlters = new LinkedList<ParseNode>();

    public TypeInfo(Parsed parsed) throws Exception {
        this.target = parsed;
        String prg = IO.readFile(TypeInfo.class, (String)"typeDiff.arbori");
        SqlProgram program = new SqlProgram(prg);
        program.eval(this.target, new Object(){

            public void typeName(Parsed target, Map<String, ParseNode> tuple) {
                TypeInfo.this.name = TypeInfo.this.name == null ? tuple.get("node").content(target.getSrc()) : TypeInfo.this.name + "." + tuple.get("node").content(target.getSrc());
            }

            public void methods(Parsed target, Map<String, ParseNode> tuple) {
                TypeInfo.this.methods.add(tuple.get("node"));
            }

            public void fields(Parsed target, Map<String, ParseNode> tuple) {
                TypeInfo.this.fields.add(tuple.get("field"));
            }

            public void fieldsInAlters(Parsed target, Map<String, ParseNode> tuple) {
                ParseNode alter = tuple.get("alter^^");
                if (!alter.contains("alter_type")) {
                    alter = alter.parent();
                }
                TypeInfo.this.fieldsInAlters.put(tuple.get("field"), alter);
            }

            public void extraAlters(Parsed target, Map<String, ParseNode> tuple) {
                TypeInfo.this.extraAlters.add(tuple.get("node"));
            }
        });
    }

    ParseNode findInAlters(String field) {
        for (ParseNode n : this.fieldsInAlters.keySet()) {
            if (!LexerToken.equals((String)this.target.content(n), (String)field)) continue;
            return n;
        }
        return null;
    }

    ParseNode findInFields(String field) {
        for (ParseNode n : this.fields) {
            if (!LexerToken.equals((String)this.target.content(n), (String)field)) continue;
            return n;
        }
        return null;
    }

    String methodName(ParseNode node) {
        for (ParseNode desc : node.descendants()) {
            if (!desc.contains("decl_id")) continue;
            return desc.content(this.target.getSrc());
        }
        return null;
    }
}

