/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.diff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.arbori.util.IO;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

public class SchedulerInfo {
    Parsed target;
    Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    boolean isEnabled = false;
    Map<String, Map<String, Object>> chainSteps = new HashMap<String, Map<String, Object>>();
    Map<String, Map<String, Object>> chainRules = new HashMap<String, Map<String, Object>>();

    public SchedulerInfo(Parsed parsed) throws Exception {
        this.target = parsed;
        String prg = IO.readFile(SchedulerInfo.class, (String)"schedulerDiff.arbori");
        SqlProgram program = new SqlProgram(prg);
        program.eval(this.target, new Object(){

            public void attributes(Parsed target, Map<String, ParseNode> tuple) {
                SchedulerInfo.this.attributes.computeIfAbsent(tuple.get("name").content(target).toLowerCase(), k -> new ArrayList()).add(tuple.get("value").content(target));
            }

            public void enabled(Parsed target, Map<String, ParseNode> tuple) {
                SchedulerInfo.this.isEnabled = true;
            }

            public void steps_attributes(Parsed target, Map<String, ParseNode> tuple) {
                String stepString = tuple.get("node").content(target);
                HashMap<String, String> stepAttributes = new HashMap<String, String>();
                Pattern pattern = Pattern.compile("(\\w+)\\s*=>\\s*(?:'([^']*)'|([^,\\s]+))");
                Matcher matcher = pattern.matcher(stepString);
                while (matcher.find()) {
                    String key = matcher.group(1).trim();
                    String value = matcher.group(2) != null ? matcher.group(2).trim() : matcher.group(3).trim();
                    stepAttributes.put(key, value);
                }
                String stepName = (String)stepAttributes.get("step_name");
                stepAttributes.remove("step_name");
                Map stepObject = SchedulerInfo.this.chainSteps.computeIfAbsent(stepName, k -> new HashMap());
                stepObject.put("attributes", stepAttributes);
                SchedulerInfo.this.chainSteps.put(stepName, stepObject);
            }

            public void steps_additional_attributes(Parsed target, Map<String, ParseNode> tuple) {
                String stepString = tuple.get("node").content(target);
                HashMap<String, String> stepNewAdditionalAttribute = new HashMap<String, String>();
                Pattern pattern = Pattern.compile("(\\w+)\\s*=>\\s*(?:'([^']*)'|([^,\\s]+))");
                Matcher matcher = pattern.matcher(stepString);
                while (matcher.find()) {
                    String key = matcher.group(1).trim();
                    String value = matcher.group(2) != null ? matcher.group(2).trim() : matcher.group(3).trim();
                    stepNewAdditionalAttribute.put(key, value);
                }
                String stepName = (String)stepNewAdditionalAttribute.get("step_name");
                stepNewAdditionalAttribute.remove("step_name");
                Map stepObject = SchedulerInfo.this.chainSteps.computeIfAbsent(stepName, k -> new HashMap());
                List additionalAttributes = stepObject.getOrDefault("additional_attributes", new ArrayList());
                additionalAttributes.add(stepNewAdditionalAttribute);
                stepObject.put("additional_attributes", additionalAttributes);
                SchedulerInfo.this.chainSteps.put(stepName, stepObject);
            }

            public void rules_attributes(Parsed target, Map<String, ParseNode> tuple) {
                String ruleString = tuple.get("node").content(target);
                HashMap<String, String> ruleAttributes = new HashMap<String, String>();
                Pattern pattern = Pattern.compile("(\\w+)\\s*=>\\s*(?:'([^']*)'|([^,\\s]+))");
                Matcher matcher = pattern.matcher(ruleString);
                while (matcher.find()) {
                    String key = matcher.group(1).trim();
                    String value = matcher.group(2) != null ? matcher.group(2).trim() : matcher.group(3).trim();
                    ruleAttributes.put(key, value);
                }
                String ruleName = (String)ruleAttributes.get("rule_name");
                ruleAttributes.remove("rule_name");
                Map ruleObject = SchedulerInfo.this.chainRules.computeIfAbsent(ruleName, k -> new HashMap());
                ruleObject.put("attributes", ruleAttributes);
                SchedulerInfo.this.chainRules.put(ruleName, ruleObject);
            }
        });
    }
}

