/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.diff;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.extension.project.diff.ObjectDiff;
import oracle.dbtools.extension.project.diff.SchedulerInfo;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.ParsedSql;

public class SchedulerDiff
extends ObjectDiff {
    SchedulerInfo s1 = null;
    SchedulerInfo s2 = null;

    public SchedulerDiff(ParsedSql parsed1, ParsedSql parsed2) throws Exception {
        super(parsed1, parsed2);
        this.s1 = new SchedulerInfo((Parsed)parsed1);
        this.s2 = new SchedulerInfo((Parsed)parsed2);
    }

    @Override
    public String alters() {
        String name = "";
        if (this.s1.attributes.get("schedule_name") != null) {
            name = this.s1.attributes.get("schedule_name").get(0);
        } else if (this.s1.attributes.get("program_name") != null && this.s1.attributes.get("chain_name") == null) {
            name = this.s1.attributes.get("program_name").get(0);
        } else if (this.s1.attributes.get("job_name") != null) {
            name = this.s1.attributes.get("job_name").get(0);
        } else if (this.s1.attributes.get("job_class_name") != null) {
            name = this.s1.attributes.get("job_class_name").get(0);
        } else if (this.s1.attributes.get("group_name") != null) {
            name = this.s1.attributes.get("group_name").get(0);
        } else if (this.s1.attributes.get("chain_name") != null) {
            name = this.s1.attributes.get("chain_name").get(0);
        }
        List<String> sourceAttributes = this.s1.attributes.get("attribute");
        List<String> currentAttributes = this.s2.attributes.get("attribute");
        List<String> sourceAttributesValues = this.s1.attributes.get("value");
        List<String> currentAttributesValues = this.s2.attributes.get("value");
        Map<String, List<String>> sourceChainAttributes = this.s1.attributes;
        Map<String, List<String>> currentChainAttributes = this.s2.attributes;
        Map<String, Map<String, Object>> chainSourceSteps = this.s1.chainSteps;
        Map<String, Map<String, Object>> chainCurrentSteps = this.s2.chainSteps;
        Map<String, Map<String, Object>> chainSourceRules = this.s1.chainRules;
        Map<String, Map<String, Object>> chainCurrentRules = this.s2.chainRules;
        Object ret = "BEGIN\n";
        if (this.s1.attributes.get("job_name") == null && this.s1.attributes.get("chain_name") == null) {
            ret = this.handleNonJobObject(name, (String)ret, currentAttributes, sourceAttributes, currentAttributesValues, sourceAttributesValues);
        } else if (this.s1.attributes.get("job_name") != null) {
            ret = this.handleJobObject(name, (String)ret, currentAttributes, sourceAttributes, currentAttributesValues, sourceAttributesValues);
        } else if (this.s1.attributes.get("chain_name") != null) {
            ret = this.handleChainObject(name, (String)ret, chainCurrentSteps, chainSourceSteps, chainCurrentRules, chainSourceRules, currentChainAttributes, sourceChainAttributes);
        }
        ret = (String)ret + "END;\n/";
        return ret;
    }

    public String setAttribute(String name, String attr, String value) {
        attr = this.normalizeQuotedString(attr);
        return "DBMS_SCHEDULER.set_attribute (\nname      => " + name + ",\nattribute => '" + attr + "',\nvalue     => " + value + ");\n";
    }

    public String nullifyAttribute(String name, String attr) {
        attr = this.normalizeQuotedString(attr);
        return "DBMS_SCHEDULER.set_attribute_null (\nname      => " + name + ",\nattribute => '" + attr + "');\n";
    }

    public String enableObject(String name) {
        return "DBMS_SCHEDULER.enable(" + name + ");\n";
    }

    public String disableObject(String name) {
        return "DBMS_SCHEDULER.disable(" + name + ");\n";
    }

    public String handleNonJobObject(String name, String ret, List<String> currentAttributes, List<String> sourceAttributes, List<String> currentAttributesValues, List<String> sourceAttributesValues) {
        ret = this.applyNormalAlterLogic(name, ret, currentAttributes, sourceAttributes, currentAttributesValues, sourceAttributesValues);
        return ret;
    }

    public String handleJobObject(String name, String ret, List<String> currentAttributes, List<String> sourceAttributes, List<String> currentAttributesValues, List<String> sourceAttributesValues) {
        boolean sourceIsJobEnabledState = this.s1.isEnabled;
        boolean currentIsJobEnabledState = this.s2.isEnabled;
        if (!sourceIsJobEnabledState && !currentIsJobEnabledState) {
            ret = this.applyNormalAlterLogic(name, (String)ret, currentAttributes, sourceAttributes, currentAttributesValues, sourceAttributesValues);
        } else if (sourceIsJobEnabledState && currentIsJobEnabledState) {
            ret = (String)ret + this.disableObject(name);
            ret = this.applyNormalAlterLogic(name, (String)ret, currentAttributes, sourceAttributes, currentAttributesValues, sourceAttributesValues);
            ret = (String)ret + this.enableObject(name);
        } else if (sourceIsJobEnabledState) {
            ret = (String)ret + this.disableObject(name);
            ret = this.applyNormalAlterLogic(name, (String)ret, currentAttributes, sourceAttributes, currentAttributesValues, sourceAttributesValues);
        } else {
            ret = this.applyNormalAlterLogic(name, (String)ret, currentAttributes, sourceAttributes, currentAttributesValues, sourceAttributesValues);
            ret = (String)ret + this.enableObject(name);
        }
        return ret;
    }

    public String handleChainObject(String name, String ret, Map<String, Map<String, Object>> chainCurrentSteps, Map<String, Map<String, Object>> chainSourceSteps, Map<String, Map<String, Object>> chainCurrentRules, Map<String, Map<String, Object>> chainSourceRules, Map<String, List<String>> currentChainAttributes, Map<String, List<String>> sourceChainAttributes) {
        List<String> allowedAttributesForNormalAlters = List.of("rule_set_name", "evaluation_interval", "comments");
        currentChainAttributes.entrySet().removeIf(entry -> !allowedAttributesForNormalAlters.contains(entry.getKey()));
        sourceChainAttributes.entrySet().removeIf(entry -> !allowedAttributesForNormalAlters.contains(entry.getKey()));
        ret = this.applyChainAlterLogic(name, (String)ret, currentChainAttributes, sourceChainAttributes);
        boolean sourceIsEnabledState = this.s1.isEnabled;
        boolean currentIsEnabledState = this.s2.isEnabled;
        for (Map.Entry<String, Map<String, Object>> step : chainSourceSteps.entrySet()) {
            if (!chainCurrentSteps.containsKey(step.getKey())) {
                ret = (String)ret + this.dropChainStep(name, step.getKey());
                continue;
            }
            Map stepSourceAttributes = (Map)step.getValue().get("attributes");
            List stepSourceAdditionalAttributes = (List)step.getValue().get("additional_attributes");
            Map stepCurrentAttributes = (Map)chainCurrentSteps.get(step.getKey()).get("attributes");
            List stepCurrentAdditionalAttributes = (List)chainCurrentSteps.get(step.getKey()).get("additional_attributes");
            for (Map.Entry stepAttribute : stepSourceAttributes.entrySet()) {
                if (((String)stepCurrentAttributes.get(stepAttribute.getKey())).equals(stepAttribute.getValue())) continue;
                ret = (String)ret + this.addChainStep(name, step.getKey(), stepCurrentAttributes);
                break;
            }
            for (Map sourceAttributeMap : stepSourceAdditionalAttributes) {
                for (Map currentAttributeMap : stepCurrentAdditionalAttributes) {
                    if (!((String)sourceAttributeMap.get("attribute")).equalsIgnoreCase((String)currentAttributeMap.get("attribute")) || ((String)sourceAttributeMap.get("value")).equalsIgnoreCase((String)currentAttributeMap.get("value"))) continue;
                    ret = (String)ret + this.applyAlterStep(name, step.getKey(), (String)sourceAttributeMap.get("attribute"), (String)currentAttributeMap.get("value"));
                }
            }
        }
        for (Map.Entry<String, Map<String, Object>> step : chainCurrentSteps.entrySet()) {
            if (chainSourceSteps.containsKey(step.getKey())) continue;
            Map stepCurrentAttributes = (Map)step.getValue().get("attributes");
            ret = (String)ret + this.addChainStep(name, step.getKey(), stepCurrentAttributes);
            List stepCurrentAdditionalAttributes = (List)chainCurrentSteps.get(step.getKey()).get("additional_attributes");
            for (Map currentAttributeMap : stepCurrentAdditionalAttributes) {
                ret = (String)ret + this.applyAlterStep(name, step.getKey(), (String)currentAttributeMap.get("attribute"), (String)currentAttributeMap.get("value"));
            }
        }
        block6: for (Map.Entry<String, Map<String, Object>> rule : chainSourceRules.entrySet()) {
            if (!chainCurrentRules.containsKey(rule.getKey())) {
                ret = (String)ret + this.dropChainRule(name, rule.getKey());
                continue;
            }
            Map ruleSourceAttributes = (Map)rule.getValue().get("attributes");
            Map ruleCurrentAttributes = (Map)chainCurrentRules.get(rule.getKey()).get("attributes");
            for (Map.Entry ruleAttribute : ruleSourceAttributes.entrySet()) {
                if (((String)ruleCurrentAttributes.get(ruleAttribute.getKey())).equals(ruleAttribute.getValue())) continue;
                ret = (String)ret + this.addChainRule(name, rule.getKey(), ruleCurrentAttributes);
                continue block6;
            }
        }
        for (Map.Entry<String, Map<String, Object>> rule : chainCurrentRules.entrySet()) {
            if (chainSourceRules.containsKey(rule.getKey())) continue;
            Map ruleCurrentAttributes = (Map)rule.getValue().get("attributes");
            ret = (String)ret + this.addChainRule(name, rule.getKey(), ruleCurrentAttributes);
        }
        if (currentIsEnabledState && !sourceIsEnabledState) {
            ret = (String)ret + this.enableObject(name);
        } else if (!currentIsEnabledState && sourceIsEnabledState) {
            ret = (String)ret + this.disableObject(name);
        }
        return ret;
    }

    public String applyChainAlterLogic(String name, String ret, Map<String, List<String>> currentChainAttributes, Map<String, List<String>> sourceChainAttributes) {
        for (Map.Entry<String, List<String>> entry : currentChainAttributes.entrySet()) {
            String sourceValue;
            String currentValue = entry.getValue().get(0);
            if (currentValue.equals(sourceValue = sourceChainAttributes.get(entry.getKey()).get(0))) continue;
            if (!currentValue.equalsIgnoreCase("null")) {
                ret = (String)ret + this.setAttribute(name, entry.getKey(), currentValue);
                continue;
            }
            ret = (String)ret + this.nullifyAttribute(name, entry.getKey());
        }
        return ret;
    }

    public String applyNormalAlterLogic(String name, String ret, List<String> currentAttributes, List<String> sourceAttributes, List<String> currentAttributesValues, List<String> sourceAttributesValues) {
        String sourceEnabledState = null;
        String currentEnabledState = null;
        for (String attr : this.s1.attributes.keySet()) {
            if (attr.equals(name) || attr.equals("attribute") || attr.equals("value") || attr.equals("name")) continue;
            if (attr.equals("enabled") && this.s1.attributes.get("job_name") == null) {
                sourceEnabledState = this.s1.attributes.get(attr).get(0);
                currentEnabledState = this.s2.attributes.get(attr).get(0);
                continue;
            }
            String value1 = this.s1.attributes.get(attr).get(0);
            String value2 = this.s2.attributes.get(attr).get(0);
            if (this.s1.attributes.get("group_name") != null && attr.equals("member")) {
                if (value1.startsWith("'") && value1.endsWith("'")) {
                    value1 = value1.substring(1, value1.length() - 1);
                }
                if (value2.startsWith("'") && value2.endsWith("'")) {
                    value2 = value2.substring(1, value2.length() - 1);
                }
                List<String> sourceMembers = Arrays.asList(value1.split(","));
                List<String> currentMembers = Arrays.asList(value2.split(","));
                ret = (String)ret + this.handleGroupMembers(name, currentMembers, sourceMembers);
                continue;
            }
            if (value1.equalsIgnoreCase(value2)) continue;
            if (!value2.equalsIgnoreCase("null")) {
                ret = (String)ret + this.setAttribute(name, attr, value2);
                continue;
            }
            ret = (String)ret + this.nullifyAttribute(name, attr);
        }
        if (currentAttributes != null && !currentAttributes.isEmpty()) {
            for (String attr : currentAttributes) {
                int indexOfAttr = currentAttributes.indexOf(attr);
                String valueOfAttr = currentAttributesValues.get(indexOfAttr);
                if (sourceAttributes != null && !sourceAttributes.isEmpty()) {
                    boolean existsInSource = sourceAttributes.contains(attr);
                    if (!existsInSource) {
                        ret = (String)ret + this.setAttribute(name, attr, currentAttributesValues.get(indexOfAttr));
                        continue;
                    }
                    String sourceValue = sourceAttributesValues.get(sourceAttributes.indexOf(attr));
                    if (sourceValue.equalsIgnoreCase(valueOfAttr)) continue;
                    ret = (String)ret + this.setAttribute(name, attr, valueOfAttr);
                    continue;
                }
                ret = (String)ret + this.setAttribute(name, attr, valueOfAttr);
            }
        }
        if (sourceAttributes != null && !sourceAttributes.isEmpty()) {
            for (String attr : sourceAttributes) {
                if (currentAttributes != null && !currentAttributes.isEmpty()) {
                    boolean existInCurrent = currentAttributes.contains(attr);
                    if (existInCurrent) continue;
                    ret = (String)ret + this.nullifyAttribute(name, attr);
                    continue;
                }
                ret = (String)ret + this.nullifyAttribute(name, attr);
            }
        }
        if (this.s1.attributes.get("job_name") == null && sourceEnabledState != null && currentEnabledState != null && !sourceEnabledState.equalsIgnoreCase(currentEnabledState)) {
            ret = currentEnabledState.equalsIgnoreCase("true") ? (String)ret + this.enableObject(name) : (String)ret + this.disableObject(name);
        }
        return ret;
    }

    public String normalizeQuotedString(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        if (input.startsWith("'") && input.endsWith("'") && input.length() > 1) {
            input = input.substring(1, input.length() - 1);
        }
        return input.replace("'", "''");
    }

    public String handleGroupMembers(String name, List<String> currentGroupMembers, List<String> sourceGroupMembers) {
        int i;
        StringBuilder newMembersTemp = new StringBuilder();
        StringBuilder oldMembersTemp = new StringBuilder();
        if (sourceGroupMembers.isEmpty() && !currentGroupMembers.isEmpty()) {
            return this.addGroupMembers(name, String.join((CharSequence)",", currentGroupMembers));
        }
        if (currentGroupMembers.isEmpty() && !sourceGroupMembers.isEmpty()) {
            return this.removeGroupMembers(name, String.join((CharSequence)",", sourceGroupMembers));
        }
        for (i = 0; i < currentGroupMembers.size(); ++i) {
            if (sourceGroupMembers.contains(currentGroupMembers.get(i))) continue;
            newMembersTemp.append(currentGroupMembers.get(i));
            if (i >= currentGroupMembers.size() - 1) continue;
            newMembersTemp.append(",");
        }
        for (i = 0; i < sourceGroupMembers.size(); ++i) {
            if (currentGroupMembers.contains(sourceGroupMembers.get(i))) continue;
            oldMembersTemp.append(sourceGroupMembers.get(i));
            if (i >= sourceGroupMembers.size() - 1) continue;
            oldMembersTemp.append(",");
        }
        if (!newMembersTemp.toString().contentEquals(oldMembersTemp)) {
            if (newMembersTemp.toString().isEmpty()) {
                return this.removeGroupMembers(name, oldMembersTemp.toString());
            }
            if (oldMembersTemp.toString().isEmpty()) {
                return this.addGroupMembers(name, newMembersTemp.toString());
            }
            return this.addGroupMembers(name, newMembersTemp.toString()) + this.removeGroupMembers(name, oldMembersTemp.toString());
        }
        return "";
    }

    public String addGroupMembers(String name, String newMembers) {
        return "DBMS_SCHEDULER.add_group_member (\ngroup_name      => " + name + ",\nmember => '" + newMembers + "');\n";
    }

    public String removeGroupMembers(String name, String oldMembers) {
        return "DBMS_SCHEDULER.remove_group_member (\ngroup_name      => " + name + ",\nmember => '" + oldMembers + "');\n";
    }

    public String dropChainStep(String chainName, String stepName) {
        return "DBMS_SCHEDULER.drop_chain_step (\nchain_name      => " + chainName + ",\nstep_name      => '" + stepName + "'\n        --force        => true -- Uncomment to forcibly drop the step\n);\n";
    }

    public String dropChainRule(String chainName, String ruleName) {
        return "DBMS_SCHEDULER.drop_chain_rule (\nchain_name      => " + chainName + ",\nrule_name      => '" + ruleName + "'\n        --force        => true -- Uncomment to forcibly drop the rule\n);\n";
    }

    public String addChainStep(String chainName, String stepName, Map<String, String> stepAttributes) {
        String result = "DBMS_SCHEDULER.define_chain_step (\nchain_name      => " + chainName + ",\nstep_name      => '" + stepName + "',\n";
        Iterator<Map.Entry<String, String>> iterator = stepAttributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            Object value = entry.getValue();
            if (!((String)value).equalsIgnoreCase("null")) {
                value = "'" + (String)value + "'";
            }
            result = result + entry.getKey() + "      => " + (String)value;
            if (iterator.hasNext()) {
                result = result + ",\n";
                continue;
            }
            result = result + "\n);\n";
        }
        return result;
    }

    public String addChainRule(String chainName, String ruleName, Map<String, String> ruleAttributes) {
        String result = "DBMS_SCHEDULER.define_chain_rule (\nchain_name      => " + chainName + ",\nrule_name      => '" + ruleName + "',\n";
        Iterator<Map.Entry<String, String>> iterator = ruleAttributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            Object value = entry.getValue();
            if (!((String)value).equalsIgnoreCase("null")) {
                value = "'" + (String)value + "'";
            }
            result = result + entry.getKey() + "      => " + (String)value;
            if (iterator.hasNext()) {
                result = result + ",\n";
                continue;
            }
            result = result + "\n);\n";
        }
        return result;
    }

    public String applyAlterStep(String chainName, String stepName, String attributeName, String attributeValue) {
        return "DBMS_SCHEDULER.alter_chain (\nchain_name      => " + chainName + ",\nstep_name      => '" + stepName + "',\nattribute      => '" + attributeName + "',\nvalue      => " + attributeValue + "\n);\n";
    }
}

