/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.stage;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.extension.project.commands.stage.utils.StageConstants;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.ParsedSql;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import org.eclipse.jgit.api.DiffCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class StageSourceDiff
implements VerifyServiceInterface {
    private static int srcDiffsToDistDiscrepancyCount = 0;
    private static int distToSrcDiffsDiscrepancyCount = 0;
    private static String currentBranch = "";

    @Override
    public String getName() {
        return "stagesourcediff";
    }

    @Override
    public String getGroup() {
        return "stage";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        srcDiffsToDistDiscrepancyCount = 0;
        distToSrcDiffsDiscrepancyCount = 0;
        currentBranch = "";
        String comparedBranch = (String)params.get("comparedBranch");
        if (comparedBranch == null) {
            comparedBranch = ProjectSettings.getSettingAsString("git.defaultBranch");
        }
        try {
            HashMap<DiffEntry.ChangeType, List<Path>> srcModifiedFiles = this.getSrcModifiedFiles(comparedBranch);
            List<Path> distModifiedFiles = this.getDistModifiedFiles();
            boolean isError = false;
            Object finalMessage = "";
            String messageSrcDiffsToDistDiscrepancies = this.getSrcDiffsToDistDiscrepanciesMessage(srcModifiedFiles, distModifiedFiles);
            if (!messageSrcDiffsToDistDiscrepancies.isEmpty()) {
                Object errorMessage = "";
                errorMessage = srcDiffsToDistDiscrepancyCount == 1 ? (String)errorMessage + VerifyMessages.getString("STAGESRCDIFFS_DIST_ERROR") : (String)errorMessage + VerifyMessages.format("STAGESRCDIFFS_DIST_ERRORS", srcDiffsToDistDiscrepancyCount);
                errorMessage = (String)errorMessage + messageSrcDiffsToDistDiscrepancies;
                isError = true;
                finalMessage = (String)finalMessage + (String)errorMessage;
            } else {
                finalMessage = (String)finalMessage + VerifyMessages.getString("STAGESRCDIFFS_ALL_REPRESENTED_IN_DIST");
            }
            String messageDistToSrcDiffsDiscrepancies = this.getDistToSrcDiffsDiscrepanciesMessage(srcModifiedFiles, distModifiedFiles);
            if (!messageDistToSrcDiffsDiscrepancies.isEmpty()) {
                Object errorMessage = "";
                errorMessage = distToSrcDiffsDiscrepancyCount == 1 ? (String)errorMessage + VerifyMessages.getString("STAGESRCDIFFS_SRC_ERROR") : (String)errorMessage + VerifyMessages.format("STAGESRCDIFFS_SRC_ERRORS", distToSrcDiffsDiscrepancyCount);
                errorMessage = (String)errorMessage + messageDistToSrcDiffsDiscrepancies;
                isError = true;
                finalMessage = (String)finalMessage + "\n";
                finalMessage = (String)finalMessage + (String)errorMessage;
            } else {
                finalMessage = (String)finalMessage + "\n";
                finalMessage = (String)finalMessage + VerifyMessages.getString("STAGESRCDIFFS_ALL_REPRESENTED_IN_SRC");
            }
            if (isError) {
                this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, (String)finalMessage);
                return false;
            }
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, (String)finalMessage);
            return true;
        }
        catch (IOException | GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    private String getSrcDiffsToDistDiscrepanciesMessage(HashMap<DiffEntry.ChangeType, List<Path>> srcModifiedFiles, List<Path> distModifiedFiles) {
        StringBuilder message = new StringBuilder();
        for (Map.Entry<DiffEntry.ChangeType, List<Path>> entry : srcModifiedFiles.entrySet()) {
            DiffEntry.ChangeType changeType = entry.getKey();
            List<Path> srcModifiedFilesList = entry.getValue();
            for (Path currentSrcFile : srcModifiedFilesList) {
                if (this.isSrcPathContainedInDistList(currentSrcFile, distModifiedFiles)) continue;
                ++srcDiffsToDistDiscrepancyCount;
                String messageType = "";
                if (changeType.equals((Object)DiffEntry.ChangeType.ADD)) {
                    messageType = VerifyMessages.format("STAGESRCDIFFS_ADDED_MISSING", currentSrcFile);
                } else if (changeType.equals((Object)DiffEntry.ChangeType.DELETE)) {
                    messageType = VerifyMessages.format("STAGESRCDIFFS_DELETED_MISSING", currentSrcFile);
                } else if (changeType.equals((Object)DiffEntry.ChangeType.MODIFY)) {
                    messageType = VerifyMessages.format("STAGESRCDIFFS_MODIFIED_MISSING", currentSrcFile);
                }
                message.append("\n");
                message.append(messageType);
            }
        }
        return message.toString();
    }

    private boolean isSrcPathContainedInDistList(Path currentSrcFile, List<Path> distModifiedFiles) {
        Path srcDatabasePath = Paths.get("src/database", new String[0]);
        String relativizedSrcFile = srcDatabasePath.relativize(currentSrcFile).toString();
        List relativeDistPaths = distModifiedFiles.stream().map(path -> {
            String pathAsString = path.toString();
            if (pathAsString.contains("changes")) {
                Path changesPath = Paths.get("dist/releases/next/changes/" + currentBranch, new String[0]);
                return changesPath.relativize((Path)path).toString();
            }
            if (pathAsString.contains("code")) {
                Path distBranchCodeFilesPath = Paths.get("dist/releases/next/code/", new String[0]);
                return distBranchCodeFilesPath.relativize((Path)path).toString();
            }
            return null;
        }).collect(Collectors.toList());
        return relativeDistPaths.contains(relativizedSrcFile);
    }

    private boolean isDistPathContainedInSrcDiffList(Path currentDistFile, List<Path> srcDiffFiles) {
        Path srcDatabasePath = Paths.get("src/database", new String[0]);
        List relativeSrcDiffFiles = srcDiffFiles.stream().map(path -> srcDatabasePath.relativize((Path)path).toString()).collect(Collectors.toList());
        String relativizedDistFile = this.getRelativizedDistFile(currentDistFile);
        return relativeSrcDiffFiles.contains(relativizedDistFile);
    }

    private boolean isDistPathValidToSrc(Path currentDistFile) throws IOException {
        Path srcDatabasePath = Paths.get("src/database", new String[0]);
        ArrayList<Path> srcFiles = new ArrayList<Path>();
        StageSourceDiff.addFilesToList(srcDatabasePath, srcFiles);
        if (!this.isDistPathContainedInSrcDiffList(currentDistFile, srcFiles)) {
            String relativizedDistFile;
            List srcFilesString = srcFiles.stream().map(srcDatabasePath::relativize).map(Path::toString).collect(Collectors.toList());
            if (!srcFilesString.contains(relativizedDistFile = this.getRelativizedDistFile(currentDistFile))) {
                String dropComment = "/*  Uncomment drop statement after ensuring it is performing the correct actions";
                String cwd = FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext());
                Path currentDistFileAbsolutePath = Paths.get(cwd, currentDistFile.toString());
                try (BufferedReader reader = Files.newBufferedReader(currentDistFileAbsolutePath);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.contains(dropComment)) {
                            boolean bl = true;
                            return bl;
                        }
                        List fullSrc = Lexer.parse((String)line, (boolean)true);
                        for (LexerToken t : fullSrc) {
                            String commented;
                            if (t.type != Token.COMMENT || !new ParsedSql(commented = t.content.substring(2, t.content.length() - 2)).contains("'DROP'")) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
                return false;
            }
            return true;
        }
        return true;
    }

    private String getRelativizedDistFile(Path currentDistFile) {
        String relativizedDistFile = "";
        if (currentDistFile.toString().contains("changes")) {
            Path changesPath = Paths.get("dist/releases/next/changes/" + currentBranch, new String[0]);
            relativizedDistFile = changesPath.relativize(currentDistFile).toString();
        } else if (currentDistFile.toString().contains("code")) {
            Path distBranchCodeFilesPath = Paths.get("dist/releases/next/code/", new String[0]);
            relativizedDistFile = distBranchCodeFilesPath.relativize(currentDistFile).toString();
        }
        return relativizedDistFile;
    }

    private String getDistToSrcDiffsDiscrepanciesMessage(HashMap<DiffEntry.ChangeType, List<Path>> srcModifiedFiles, List<Path> distModifiedFiles) throws IOException {
        List<Path> srcModifiedFilesFlattened = srcModifiedFiles.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        StringBuilder message = new StringBuilder();
        for (Path currentDistFile : distModifiedFiles) {
            if (this.isDistPathContainedInSrcDiffList(currentDistFile, srcModifiedFilesFlattened) || this.isDistPathValidToSrc(currentDistFile)) continue;
            ++distToSrcDiffsDiscrepancyCount;
            message.append("\n");
            message.append(VerifyMessages.format("STAGESRCDIFFS_SRC_MISSING", currentDistFile));
        }
        return message.toString();
    }

    private List<Path> getDistModifiedFiles() throws IOException, GitAPIException {
        ArrayList<Path> result = new ArrayList<Path>();
        try (Git git = Git.open((File)new File(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext())));){
            Repository repository = git.getRepository();
            currentBranch = repository.getBranch();
            Path distBranchChangesFilesPath = Paths.get("dist/releases/next/changes/" + currentBranch, new String[0]);
            StageSourceDiff.addFilesToList(distBranchChangesFilesPath, result);
            if (StageConstants.isReleaseIsolation()) {
                Path distBranchCodeFilesPath = Paths.get("dist/releases/next/code/", new String[0]);
                StageSourceDiff.addFilesToList(distBranchCodeFilesPath, result);
            }
        }
        return result;
    }

    private static void addFilesToList(Path distBranchFilesPath, List<Path> result) {
        File[] schemasFolders;
        String cwd = FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext());
        Path cwdPath = Paths.get(cwd, new String[0]);
        Path distBranchFilesAbsolutePath = Paths.get(cwd, distBranchFilesPath.toString());
        if (Files.isDirectory(distBranchFilesAbsolutePath, new LinkOption[0]) && (schemasFolders = new File(distBranchFilesAbsolutePath.toString()).listFiles()) != null) {
            for (File currentSchemaFolder : schemasFolders) {
                File[] currentSchemaContainedFolders;
                if (!Files.isDirectory(currentSchemaFolder.toPath(), new LinkOption[0]) || currentSchemaFolder.getName().equalsIgnoreCase("_custom") || (currentSchemaContainedFolders = new File(currentSchemaFolder.toString()).listFiles()) == null) continue;
                for (File currentFolder : currentSchemaContainedFolders) {
                    File[] containedFiles = new File(currentFolder.toString()).listFiles();
                    if (containedFiles == null) continue;
                    for (File currentFile : containedFiles) {
                        Path currentFileRelativizedPath = cwdPath.relativize(Paths.get(currentFile.getPath(), new String[0]));
                        result.add(currentFileRelativizedPath);
                    }
                }
            }
        }
    }

    private HashMap<DiffEntry.ChangeType, List<Path>> getSrcModifiedFiles(String comparedBranchName) throws IOException, GitAPIException {
        try (Git git = Git.open((File)new File(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext())));){
            Repository repository = git.getRepository();
            AbstractTreeIterator oldTree = StageSourceDiff.prepareTreeParser(repository, "refs/heads/" + comparedBranchName);
            AbstractTreeIterator newTree = StageSourceDiff.prepareTreeParser(repository, "refs/heads/" + repository.getBranch());
            DiffCommand diffCommand = git.diff().setOldTree(oldTree).setNewTree(newTree);
            diffCommand.setPathFilter((TreeFilter)PathFilter.create((String)"src/database"));
            List diffs = diffCommand.call();
            HashMap<DiffEntry.ChangeType, List> result = new HashMap<DiffEntry.ChangeType, List>();
            for (DiffEntry diff : diffs) {
                if (diff.getChangeType() == DiffEntry.ChangeType.DELETE) {
                    Path oldPath = Paths.get(diff.getOldPath(), new String[0]);
                    if (oldPath.toString().contains("ords") || oldPath.toString().contains("apex")) continue;
                    result.computeIfAbsent(diff.getChangeType(), k -> new ArrayList()).add(oldPath);
                    continue;
                }
                Path newPath = Paths.get(diff.getNewPath(), new String[0]);
                if (newPath.toString().contains("ords") || newPath.toString().contains("apex")) continue;
                result.computeIfAbsent(diff.getChangeType(), k -> new ArrayList()).add(newPath);
            }
            HashMap<DiffEntry.ChangeType, List> hashMap = result;
            return hashMap;
        }
    }

    private static AbstractTreeIterator prepareTreeParser(Repository repository, String ref) throws IOException {
        ObjectId headId = repository.resolve(ref + "^{tree}");
        if (headId == null) {
            throw new IllegalArgumentException(VerifyMessages.format("STAGESRCDIFFS_BRANCH_NOT_FOUND", ref));
        }
        try (ObjectReader reader = repository.newObjectReader();){
            CanonicalTreeParser treeParser = new CanonicalTreeParser();
            treeParser.reset(reader, (AnyObjectId)headId);
            CanonicalTreeParser canonicalTreeParser = treeParser;
            return canonicalTreeParser;
        }
    }
}

