/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.stage;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class StageChangelogFilesValid
implements VerifyServiceInterface {
    private static final Pattern INCLUDE_PATTERN_SQL = Pattern.compile("^\\s*(?:(?:@@|@)|START\\s+)([^\"\\s]+)");
    private static final Pattern INCLUDE_PATTERN_XML = Pattern.compile(".*<include file=\"([^\"]*)\" relativeToChangelogFile=\"true\"/>.*");
    private static Pattern usedPattern = INCLUDE_PATTERN_SQL;
    private static LinkedHashMap<Path, List<Path>> missingFiles;
    private static LinkedHashMap<Path, List<Path>> crossReferencedFiles;
    private static int totalMissingFiles;
    private static int totalCrossReferencedFiles;
    private static List<Path> unreadableFiles;
    private static int filesChecked;

    @Override
    public String getName() {
        return "stagechangelogfilesvalid";
    }

    @Override
    public String getGroup() {
        return "stage";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        missingFiles = new LinkedHashMap();
        crossReferencedFiles = new LinkedHashMap();
        unreadableFiles = new ArrayList<Path>();
        Path initialFilePath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/install.sql");
        String stageGeneratedFormat = (String)ProjectSettings.getConfigValue("stage.generatedFormat");
        if ("sql".equals(stageGeneratedFormat)) {
            initialFilePath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/install.sql");
            usedPattern = INCLUDE_PATTERN_SQL;
        } else if ("liquibase".equals(stageGeneratedFormat)) {
            initialFilePath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/releases/main.changelog.xml");
            usedPattern = INCLUDE_PATTERN_XML;
        }
        ArrayList<Path> initialProcessedFiles = new ArrayList<Path>();
        try {
            if (!Files.exists(initialFilePath, new LinkOption[0])) {
                this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.format("STAGECHANGELOGFILESVALID_GENERATED_FORMAT", stageGeneratedFormat) + "\n" + VerifyMessages.format("STAGECHANGELOGFILESVALID_MISSINGINITIALFILE", Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), new String[0]).relativize(initialFilePath)));
                filesChecked = 0;
                return false;
            }
            this.parseFileAndGetIncludes(initialFilePath, initialProcessedFiles);
            if (missingFiles.isEmpty() && crossReferencedFiles.isEmpty() && unreadableFiles.isEmpty()) {
                this.addMessage(VerifyServiceInterface.MessageLevel.INFO, VerifyMessages.format("STAGECHANGELOGFILESVALID_GENERATED_FORMAT", stageGeneratedFormat) + "\n" + VerifyMessages.format("STAGECHANGELOGFILESVALID_ALL_FILES_OK", filesChecked));
                filesChecked = 0;
                return true;
            }
            Object missingAndOrCrossreferencedAndOrUnreadableFilesMessage = VerifyMessages.format("STAGECHANGELOGFILESVALID_GENERATED_FORMAT", stageGeneratedFormat);
            if (!missingFiles.isEmpty()) {
                String missingFilesList = this.getFilesMessage(missingFiles, FilesType.MISSING);
                missingAndOrCrossreferencedAndOrUnreadableFilesMessage = totalMissingFiles == 1 ? (String)missingAndOrCrossreferencedAndOrUnreadableFilesMessage + "\n" + VerifyMessages.format("STAGECHANGELOGFILESVALID_MISSINGFILE", filesChecked, missingFilesList) : (String)missingAndOrCrossreferencedAndOrUnreadableFilesMessage + "\n" + VerifyMessages.format("STAGECHANGELOGFILESVALID_MISSINGFILES", totalMissingFiles, filesChecked, missingFilesList);
            }
            if (!crossReferencedFiles.isEmpty()) {
                String crossReferencedFilesList = this.getFilesMessage(crossReferencedFiles, FilesType.CROSSREFERENCED);
                missingAndOrCrossreferencedAndOrUnreadableFilesMessage = totalCrossReferencedFiles == 1 ? (String)missingAndOrCrossreferencedAndOrUnreadableFilesMessage + "\n" + VerifyMessages.format("STAGECHANGELOGFILESVALID_CROSSREFERENCEDFILE", filesChecked, crossReferencedFilesList) : (String)missingAndOrCrossreferencedAndOrUnreadableFilesMessage + "\n" + VerifyMessages.format("STAGECHANGELOGFILESVALID_CROSSREFERENCEDFILES", totalCrossReferencedFiles, filesChecked, crossReferencedFilesList);
            }
            if (!unreadableFiles.isEmpty()) {
                String unreadableFilesList = unreadableFiles.stream().map(Path::toString).collect(Collectors.joining(", "));
                missingAndOrCrossreferencedAndOrUnreadableFilesMessage = unreadableFiles.size() == 1 ? (String)missingAndOrCrossreferencedAndOrUnreadableFilesMessage + "\n" + VerifyMessages.format("STAGECHANGELOGFILESVALID_UNREADABLEFILE", filesChecked, unreadableFilesList) : (String)missingAndOrCrossreferencedAndOrUnreadableFilesMessage + "\n" + VerifyMessages.format("STAGECHANGELOGFILESVALID_UNREADABLEFILES", unreadableFiles.size(), filesChecked, unreadableFilesList);
            }
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, (String)missingAndOrCrossreferencedAndOrUnreadableFilesMessage);
            filesChecked = 0;
            return false;
        }
        catch (IOException e) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "EXCEPTION", "exception", e);
            return false;
        }
    }

    private void parseFileAndGetIncludes(Path currentFilePath, List<Path> processedFiles) throws IOException {
        block13: {
            Path absoluteNormalizedPath = currentFilePath.toAbsolutePath().normalize();
            if (!processedFiles.contains(absoluteNormalizedPath)) {
                processedFiles.add(absoluteNormalizedPath);
                BufferedReader reader = Files.newBufferedReader(absoluteNormalizedPath);
                block8: while (true) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        Matcher matcher = usedPattern.matcher(line);
                        if (!matcher.matches()) continue;
                        ++filesChecked;
                        String includedRelativePathStr = matcher.group(1);
                        Path currentDir = absoluteNormalizedPath.getParent();
                        Path includedAbsolutePath = currentDir.resolve(includedRelativePathStr).normalize();
                        Path relativizedPath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), new String[0]).relativize(currentDir.resolve(absoluteNormalizedPath).normalize());
                        Matcher matcherFolder = Pattern.compile(".*\\.\\./([^/]*)/.*").matcher(includedRelativePathStr);
                        Matcher matcherFile = Pattern.compile(".*\\.\\./([^/]*\\.[^/]*)").matcher(includedRelativePathStr);
                        if (matcherFolder.matches() && !currentDir.toString().contains(matcherFolder.group(1)) || matcherFile.matches()) {
                            this.putFiles(includedAbsolutePath, relativizedPath, crossReferencedFiles);
                        }
                        try {
                            this.parseFileAndGetIncludes(includedAbsolutePath, processedFiles);
                            continue block8;
                        }
                        catch (NoSuchFileException e) {
                            this.putFiles(includedAbsolutePath, relativizedPath, missingFiles);
                        }
                        catch (IOException e) {
                            unreadableFiles.add(Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), new String[0]).relativize(includedAbsolutePath));
                        }
                    }
                    break block13;
                    {
                        continue block8;
                        break;
                    }
                    break;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
        }
    }

    private void putFiles(Path includedAbsolutePath, Path relativizedPath, LinkedHashMap<Path, List<Path>> files) {
        List<Path> currentReferenceFiles = files.get(relativizedPath);
        if (currentReferenceFiles == null || currentReferenceFiles.isEmpty()) {
            ArrayList<Path> newCurrentCrossReferencedFiles = new ArrayList<Path>();
            newCurrentCrossReferencedFiles.add(Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), new String[0]).relativize(includedAbsolutePath));
            files.put(relativizedPath, newCurrentCrossReferencedFiles);
        } else {
            currentReferenceFiles.add(Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), new String[0]).relativize(includedAbsolutePath));
            files.put(relativizedPath, currentReferenceFiles);
        }
    }

    private String getFilesMessage(HashMap<Path, List<Path>> files, FilesType filesType) {
        switch (filesType.ordinal()) {
            case 0: {
                totalMissingFiles = 0;
                break;
            }
            case 1: {
                totalCrossReferencedFiles = 0;
            }
        }
        StringBuilder result = new StringBuilder();
        int firstCounter = 0;
        for (Map.Entry<Path, List<Path>> entry : files.entrySet()) {
            Path includingPath = entry.getKey();
            List<Path> includedPaths = entry.getValue();
            StringBuilder currentIncludedPaths = new StringBuilder();
            int secondCounter = 0;
            for (Path path : includedPaths) {
                if (secondCounter != 0) {
                    currentIncludedPaths.append("\n");
                }
                currentIncludedPaths.append("\t").append(path.toString());
                switch (filesType.ordinal()) {
                    case 0: {
                        ++totalMissingFiles;
                        break;
                    }
                    case 1: {
                        ++totalCrossReferencedFiles;
                    }
                }
                ++secondCounter;
            }
            String message = "";
            switch (filesType.ordinal()) {
                case 0: {
                    message = "STAGECHANGELOGFILESVALID_MISSINGFILE_LIST";
                    break;
                }
                case 1: {
                    message = "STAGECHANGELOGFILESVALID_CROSSREFERENCED_LIST";
                }
            }
            if (firstCounter != 0) {
                result.append("\n");
            }
            result.append(VerifyMessages.format(message, includingPath.toString(), currentIncludedPaths.toString()));
            ++firstCounter;
        }
        return result.toString();
    }

    static {
        filesChecked = 0;
    }

    private static enum FilesType {
        MISSING,
        CROSSREFERENCED;

    }
}

