/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.project;

import java.util.HashMap;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;

public class SqlClVersionService
implements VerifyServiceInterface {
    @Override
    public String getName() {
        return "sqlclversion";
    }

    @Override
    public String getGroup() {
        return "project";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        try {
            String expectedVersion = ProjectSettings.getSettingAsString("sqlcl.version");
            String currentVersion = ProjectConfig.getSqlclVersion();
            if (expectedVersion == null || expectedVersion.compareTo(currentVersion) < 0) {
                this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.format("BAD_VERSION", expectedVersion, currentVersion));
                return false;
            }
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, "SQLcl Version check passed");
            return true;
        }
        catch (Exception e) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "EXCEPTION", "exception", e);
            return false;
        }
    }
}

