/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.init;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.settings.Settings;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;

public class InitConfigFilesChanges
implements VerifyServiceInterface {
    private static boolean hasDifference = false;

    @Override
    public String getName() {
        return "initconfigfileschanges";
    }

    @Override
    public String getGroup() {
        return "Init";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        hasDifference = false;
        try {
            ProjectSettings.loadSystemSettings();
            LinkedHashMap<String, Settings> systemConfigMap = ProjectSettings.getSystemConfigMap();
            ProjectSettings.loadUserSettings();
            Map<String, Object> userConfigMap = ProjectSettings.getUserConfigMap();
            ComparisonReport report = InitConfigFilesChanges.compareUserAndSystem(systemConfigMap, userConfigMap);
            String comparisonReport = InitConfigFilesChanges.printComparisonReport(report);
            String currentProjectSqlClVersion = ProjectConfig.getSqlclVersion();
            String settingSqlClVersion = ProjectSettings.getSettingAsString("sqlcl.version");
            if (currentProjectSqlClVersion.equals(settingSqlClVersion)) {
                if (hasDifference) {
                    this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, comparisonReport);
                } else {
                    this.addMessage(VerifyServiceInterface.MessageLevel.INFO, comparisonReport);
                }
            } else {
                this.addMessage(VerifyServiceInterface.MessageLevel.WARN, comparisonReport);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    private static ComparisonReport compareUserAndSystem(LinkedHashMap<String, Settings> systemConfigMap, Map<String, Object> userConfigMap) {
        ComparisonReport report = new ComparisonReport();
        LinkedHashSet<String> rawSystemKeys = new LinkedHashSet<String>(systemConfigMap.keySet());
        LinkedHashSet<String> rawUserKeys = new LinkedHashSet<String>(userConfigMap.keySet());
        Set<String> nonPublicPrefixes = InitConfigFilesChanges.buildNonPublicPrefixes(systemConfigMap);
        Set<String> systemKeys = InitConfigFilesChanges.filterOutNonPublic(InitConfigFilesChanges.normalizeAndExpandKeys(rawSystemKeys), nonPublicPrefixes);
        Set<String> userKeys = InitConfigFilesChanges.normalizeAndExpandKeys(InitConfigFilesChanges.stripArrayIndexes(rawUserKeys));
        for (String k : userKeys) {
            if (systemKeys.contains(k)) continue;
            report.onlyInUser.add(k);
        }
        for (String k : systemKeys) {
            if (userKeys.contains(k)) continue;
            report.onlyInSystem.add(k);
        }
        return report;
    }

    private static String printComparisonReport(ComparisonReport r) {
        StringBuilder sb = new StringBuilder(VerifyMessages.getString("INITCONFIGDIFFS_TITLE"));
        if (!r.onlyInUser.isEmpty()) {
            hasDifference = true;
            sb.append("\n").append(VerifyMessages.format("INITCONFIGDIFFS_USER_ONLY", r.onlyInUser.size(), r.onlyInUser));
        }
        if (!r.onlyInSystem.isEmpty()) {
            hasDifference = true;
            sb.append("\n").append(VerifyMessages.format("INITCONFIGDIFFS_SYSTEM_ONLY", r.onlyInSystem.size(), r.onlyInSystem));
        }
        if (!hasDifference) {
            sb.append("\n").append(VerifyMessages.getString("INITCONFIGDIFFS_NO_DIFFERENCE"));
        }
        return sb.toString();
    }

    private static Set<String> buildNonPublicPrefixes(LinkedHashMap<String, Settings> systemConfigMap) {
        LinkedHashSet<String> nonPublic = new LinkedHashSet<String>();
        for (Map.Entry<String, Settings> e : systemConfigMap.entrySet()) {
            Settings s = e.getValue();
            if (s == null || !"N".equalsIgnoreCase(s.getPub())) continue;
            nonPublic.add(e.getKey());
        }
        return nonPublic;
    }

    private static Set<String> normalizeAndExpandKeys(Set<String> keys) {
        LinkedHashSet<String> normalized = new LinkedHashSet<String>(keys.size());
        for (String k : keys) {
            if (k == null || k.isEmpty()) continue;
            String nk = k.trim();
            normalized.add(nk);
        }
        LinkedHashSet<String> expanded = new LinkedHashSet<String>(normalized);
        for (String k : normalized) {
            expanded.addAll(InitConfigFilesChanges.ancestorsOf(k));
        }
        return expanded;
    }

    private static Set<String> stripArrayIndexes(Set<String> keys) {
        LinkedHashSet<String> out = new LinkedHashSet<String>(keys.size());
        for (String k : keys) {
            if (k == null) continue;
            out.add(k.replaceAll("\\[\\d+]", ""));
        }
        return out;
    }

    private static List<String> ancestorsOf(String key) {
        ArrayList<String> res = new ArrayList<String>();
        int idx = key.lastIndexOf(46);
        while (idx > 0) {
            res.add(key.substring(0, idx));
            idx = key.lastIndexOf(46, idx - 1);
        }
        return res;
    }

    private static Set<String> filterOutNonPublic(Set<String> keys, Set<String> nonPublicPrefixes) {
        if (nonPublicPrefixes == null || nonPublicPrefixes.isEmpty()) {
            return keys;
        }
        LinkedHashSet<String> out = new LinkedHashSet<String>(keys.size());
        block0: for (String key : keys) {
            for (String prefix : nonPublicPrefixes) {
                if (!key.equals(prefix) && !key.startsWith(prefix + ".")) continue;
                continue block0;
            }
            out.add(key);
        }
        return out;
    }

    private static final class ComparisonReport {
        public final Set<String> onlyInUser = new LinkedHashSet<String>();
        public final Set<String> onlyInSystem = new LinkedHashSet<String>();

        private ComparisonReport() {
        }
    }
}

