/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.export;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.app.Format;
import oracle.dbtools.app.Persist2XML;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import org.xml.sax.SAXException;

public class ExportFormatterRules
implements VerifyServiceInterface {
    @Override
    public String getName() {
        return "exportformatterrules";
    }

    @Override
    public String getGroup() {
        return "export";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        Object message = "";
        Path sqlFormatFilePath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), ".dbtools/project.sqlformat.xml");
        File sqlFormatFile = new File(sqlFormatFilePath.toString());
        if (!sqlFormatFile.exists()) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.getString("EXPORTFORMATTER_FILE_MISSING"));
            return false;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.parse(sqlFormatFile);
            message = (String)message + VerifyMessages.getString("EXPORTFORMATTER_PARSING_SUCCESS");
            FileInputStream fis = new FileInputStream(sqlFormatFile);
            Map options = Persist2XML.read((FileInputStream)fis);
            if (ProjectSettings.getSettingAsBoolean("export.format.enable").booleanValue()) {
                Format format = new Format();
                format.verifyOptions(options, false);
            }
            message = (String)message + "\n";
            message = (String)message + VerifyMessages.getString("EXPORTFORMATTER_VALID_KEY_VALUE");
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, (String)message);
            return true;
        }
        catch (SAXException e) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.format("EXPORTFORMATTER_PARSING_ERROR", e.getMessage()));
        }
        catch (IOException e) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.getString("EXPORTFORMATTER_FILE_UNREADABLE"));
        }
        catch (AssertionError e) {
            message = (String)message + "\n";
            message = (String)message + VerifyMessages.format("EXPORTFORMATTER_INVALID_KEY_VALUE", "\n" + ((Throwable)((Object)e)).getMessage());
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, (String)message);
        }
        catch (Exception e) {
            message = (String)message + "\n";
            message = (String)message + VerifyMessages.format("EXPORTFORMATTER_UNEXPECTED_ERROR", e.getMessage());
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, (String)message);
        }
        return false;
    }
}

