/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.interfaces;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.exceptions.GeneralVerifyException;

public interface VerifyServiceInterface {
    public static final List<ServiceMessage> serviceMessages = new LinkedList<ServiceMessage>();
    public static final Map<MessageLevel, Integer> status = new HashMap<MessageLevel, Integer>();

    public static String getCallerClassName() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stElements.length; ++i) {
            StackTraceElement ste = stElements[i];
            if (ste.getClassName().equals(VerifyServiceInterface.class.getName()) || ste.getClassName().indexOf("java.lang.Thread") == 0) continue;
            return ste.getClassName();
        }
        return null;
    }

    public String getName();

    public String getGroup();

    public boolean doTest(HashMap<String, Object> var1);

    default public boolean executeTest(HashMap<String, Object> params) throws GeneralVerifyException {
        String caller = VerifyServiceInterface.getCallerClassName();
        if (!"oracle.dbtools.extension.project.core.verify.VerifyEngine".equals(caller)) {
            throw new GeneralVerifyException(VerifyMessages.getString("BAD_DIRECT_CALL"));
        }
        serviceMessages.clear();
        status.clear();
        return this.doTest(params);
    }

    default public List<ServiceMessage> getMessages() {
        return serviceMessages;
    }

    default public int getMessageCount(@NonNull MessageLevel MessageLevel2) {
        if (MessageLevel2 == null) {
            throw new NullPointerException("MessageLevel is marked non-null but is null");
        }
        return status.getOrDefault((Object)MessageLevel2, 0);
    }

    default public Map<MessageLevel, Integer> getMessageCounts() {
        return status;
    }

    default public void addMessage(@NonNull MessageLevel level, @NonNull String message, String type, Object details) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (status.containsKey((Object)level)) {
            status.put(level, status.get((Object)level) + 1);
        } else {
            status.put(level, 1);
        }
        serviceMessages.add(new ServiceMessage(level, message, type, details));
    }

    default public void addMessage(@NonNull MessageLevel level, @NonNull String message) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (status.containsKey((Object)level)) {
            status.put(level, status.get((Object)level) + 1);
        } else {
            status.put(level, 1);
        }
        serviceMessages.add(new ServiceMessage(level, message, null, null));
    }

    public static class ServiceMessage {
        @NonNull
        MessageLevel Level;
        @NonNull
        String message;
        String type;
        Object detail;

        @NonNull
        @Generated
        public MessageLevel getLevel() {
            return this.Level;
        }

        @NonNull
        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Object getDetail() {
            return this.detail;
        }

        @Generated
        public ServiceMessage(@NonNull MessageLevel Level2, @NonNull String message, String type, Object detail) {
            if (Level2 == null) {
                throw new NullPointerException("Level is marked non-null but is null");
            }
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.Level = Level2;
            this.message = message;
            this.type = type;
            this.detail = detail;
        }
    }

    public static enum MessageLevel {
        INFO,
        WARN,
        ERROR,
        HIDDEN;

    }
}

