/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import oracle.dbtools.core.connections.util.ConnectionsSupport;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ProjectConnectionException;
import oracle.dbtools.extension.project.core.exceptions.ProjectExistsException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.utils.NamedConnections;
import oracle.dbtools.raptor.liquibase.core.CommandGenerator;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.Property;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NamedConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.util.Logger;

public class ProjectUtils {
    static void writeln(ScriptRunnerContext ctx, String msg, boolean verbose) {
        if (verbose) {
            try {
                ctx.writeln(msg);
                ctx.getOutputStream().getMainStream().flush();
            }
            catch (Exception e) {
                System.out.println(msg);
            }
        }
    }

    public static boolean ignoreCaseContains(List<String> theList, String searchStr) {
        for (String s : theList) {
            if (!searchStr.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static LinkedHashMap<String, Object> getMatchingSettings(List<String> theList, String searchStr) {
        LinkedHashMap<String, Object> matchingSettings = new LinkedHashMap<String, Object>();
        for (String s : theList) {
            if (!s.contains(searchStr)) continue;
            matchingSettings.put(s, ProjectSettings.getUserConfigMap().get(s));
        }
        return matchingSettings;
    }

    public static void writeInfo(ScriptRunnerContext ctx, String msg) {
        ctx.writeln("INFO: " + msg);
    }

    public static void writeError(ScriptRunnerContext ctx, String msg) {
        ctx.writeln("ERROR: " + msg);
    }

    public static void writeWarn(ScriptRunnerContext ctx, String msg) {
        ctx.writeln("WARN: " + msg);
    }

    public static void writeDebug(ScriptRunnerContext ctx, String msg) {
        ctx.writeln("DEBUG: " + msg);
    }

    private static Connection connect(ScriptRunnerContext ctx, String connName) throws IOException, ProjectConnectionException {
        try (StringReader reader = new StringReader("connect -name " + connName);){
            ScriptParser parser = new ScriptParser((Reader)reader);
            ISQLCommand sqlCommand = parser.next();
            if (sqlCommand != null) {
                new ConnectCommand().handleEvent(ctx.getCurrentConnection(), ctx, sqlCommand);
                Connection connection = ctx.getCurrentConnection();
                return connection;
            }
        }
        throw new ProjectConnectionException(ProjectMessages.getString("NO_CONNECTION"));
    }

    public static Connection getConnection(ScriptRunnerContext ctx) {
        return ProjectUtils.getConnection(ctx, true);
    }

    public static Connection getConnection(ScriptRunnerContext ctx, boolean verbose) {
        Connection activeConnection = ctx.getCurrentConnection();
        try {
            if (activeConnection.isClosed()) {
                activeConnection = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (activeConnection == null) {
            String connectionIsNull = "ctx.getCurrentConnection()==null";
            String connectionName = ProjectSettings.getSettingAsString("sqlcl.connectionName");
            if (connectionName != null && !connectionName.isEmpty()) {
                try {
                    ProjectUtils.writeln(ctx, MessageFormat.format(ProjectMessages.getString("STORED_CONNECTION"), connectionName), verbose);
                    activeConnection = ProjectUtils.connect(ctx, connectionName);
                    if (ctx.getCurrentConnection() == null) {
                        throw new Exception("ctx.getCurrentConnection()==null");
                    }
                }
                catch (Exception e) {
                    ProjectUtils.writeln(ctx, MessageFormat.format(ProjectMessages.getString("STORED_CONNECTION_FAILED"), connectionName), true);
                    if (!"ctx.getCurrentConnection()==null".equals(e.getMessage())) {
                        ProjectUtils.writeln(ctx, e.getLocalizedMessage(), true);
                    }
                    ProjectUtils.restoreConnection(ctx, activeConnection);
                    return activeConnection;
                }
            }
            if (ctx.getCurrentConnection() == null) {
                ProjectUtils.writeln(ctx, ProjectMessages.getString("NO_CONNECTION"), true);
                ProjectUtils.restoreConnection(ctx, activeConnection);
                return activeConnection;
            }
        } else {
            Object url = "";
            String user = "";
            try {
                url = activeConnection.getMetaData().getURL();
                user = activeConnection.getSchema();
            }
            catch (SQLException ignored) {
                boolean bl = false;
            }
            String prefix = "jdbc:oracle:thin:@";
            if (((String)url).startsWith("jdbc:oracle:thin:@")) {
                url = ((String)url).substring("jdbc:oracle:thin:@".length());
            }
            url = (String)url + " " + user;
            ProjectUtils.writeln(ctx, MessageFormat.format(ProjectMessages.getString("CURRENT_CONNECTION"), url), verbose);
        }
        return activeConnection;
    }

    private static void restoreConnection(ScriptRunnerContext ctx, Connection old) {
    }

    public static String removeIllegalCharacters(String name, boolean singleSpaces, boolean replaceWhitespace) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        String safe = name.trim();
        safe = safe.replaceAll("[\\/|\\\\|\\*|\\:|\\||\"|'|\\<|\\>|\\{|\\}|\\?|\\%|@]", "");
        if (singleSpaces) {
            safe = safe.replaceAll(" {2,}", " ");
        }
        if (replaceWhitespace) {
            safe = safe.replaceAll("\\s+", "_");
        }
        return safe.trim();
    }

    public static Path getProjectRootFolder() throws ProjectExistsException {
        Path root = ProjectConfig.getCurrentWorkingProjectRoot();
        if (root == null) {
            throw new ProjectExistsException(ProjectMessages.getString("NOT_PROJECT_ERR"));
        }
        return root;
    }

    public static void displayArgs(ScriptRunnerContext _ctx, ParsedCommand _sqlclCommand) {
        if (!_sqlclCommand.isFlagSet((Id)ProjectOptions.Options.DEBUG)) {
            return;
        }
        try {
            List options = _sqlclCommand.getType().getOptions();
            if (options.isEmpty()) {
                return;
            }
            _ctx.writeln("");
            _ctx.write("-----  DISPLAY ARGUMENTS  -----" + System.lineSeparator() + System.lineSeparator());
            for (Option option : options) {
                Object val = ProjectUtils.getOptionValue(option.getId(), _sqlclCommand);
                if (val == null) {
                    val = "null";
                }
                String req = option.isRequired() ? "REQUIRED  " : "";
                _ctx.write("  " + req + option.getName() + ":" + ProjectUtils.pad(15 - (option.getName().length() + req.length())) + String.valueOf(val) + System.lineSeparator());
            }
            _ctx.write(System.lineSeparator() + "-----  END ARGUMENTS -----" + System.lineSeparator() + System.lineSeparator());
        }
        catch (RuntimeException e) {
            Logger.warn(CommandGenerator.class, (Throwable)e);
        }
    }

    private static <T> T getOptionValue(Id optionId, ParsedCommand _sqlclCommand) {
        try {
            if (null != _sqlclCommand.getOptionValue(optionId)) {
                return (T)_sqlclCommand.getOptionValue(optionId);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static String pad(int howMany) {
        return " ".repeat(Math.max(0, howMany));
    }

    public static void printTable(List<List<String>> table) {
        if (table == null || table.isEmpty() || table.get(0) == null || table.get(0).isEmpty()) {
            return;
        }
        ScriptRunnerContext context = ProjectConfig.getCurrentContext();
        int terminalWidth = context.getSQLPlusConsoleReader().getWidth();
        int columns = table.get(0).size();
        int maxColumnWidth = (terminalWidth - (columns + 2) - columns * 2) / columns;
        List<Integer> maxWidths = ProjectUtils.longestValPerCol(table);
        int wholeWidth = maxWidths.stream().mapToInt(width -> Math.min(width, maxColumnWidth) + 3).sum();
        String headerSeparator = " +" + "=".repeat(wholeWidth - 1) + "+";
        String rowSeparator = " +" + "-".repeat(wholeWidth - 1) + "+";
        context.writeln(headerSeparator);
        for (int rowIndex = 0; rowIndex < table.size(); ++rowIndex) {
            List<String> row = table.get(rowIndex);
            ProjectUtils.printRow(row, maxWidths, maxColumnWidth);
            if (rowIndex == 0) {
                context.writeln(headerSeparator);
                continue;
            }
            context.writeln(rowSeparator);
        }
    }

    private static void printRow(List<String> row, List<Integer> maxWidths, int maxColumnWidth) {
        int maxLines = 1;
        ArrayList<List<String>> splitRows = new ArrayList<List<String>>();
        for (int i = 0; i < row.size(); ++i) {
            String col = row.get(i);
            List<String> splitCol = ProjectUtils.splitCell(col, Math.min(maxWidths.get(i), maxColumnWidth));
            maxLines = Math.max(maxLines, splitCol.size());
            splitRows.add(splitCol);
        }
        for (int line = 0; line < maxLines; ++line) {
            ScriptRunnerContext context = ProjectConfig.getCurrentContext();
            for (int i = 0; i < row.size(); ++i) {
                List splitCol = (List)splitRows.get(i);
                String cellLine = line < splitCol.size() ? (String)splitCol.get(line) : "";
                context.write(" | " + ProjectUtils.padRight(cellLine, Math.min(maxWidths.get(i), maxColumnWidth)));
            }
            context.writeln(" |");
        }
    }

    private static List<String> splitCell(String cell, int width) {
        String[] brokeLines;
        if (cell == null) {
            cell = "";
        }
        ArrayList<String> lines = new ArrayList<String>();
        String trimmedCell = cell.endsWith("\n") ? cell.substring(0, cell.length() - 1) : cell;
        for (String s : brokeLines = trimmedCell.split("\\R")) {
            int numLines = (int)Math.ceil((double)s.length() / (double)width);
            for (int j = 0; j < numLines; ++j) {
                int start = j * width;
                int end = Math.min(start + width, s.length());
                lines.add(s.substring(start, end));
            }
        }
        return lines;
    }

    public static List<Integer> longestValPerCol(List<List<String>> table) {
        if (table == null || table.isEmpty()) {
            return Collections.emptyList();
        }
        int columnCount = table.get(0).size();
        ArrayList<Integer> maxWidths = new ArrayList<Integer>(Collections.nCopies(columnCount, 0));
        for (List<String> row : table) {
            if (row == null || row.isEmpty()) continue;
            for (int j = 0; j < row.size(); ++j) {
                String col = row.get(j);
                if (col == null) {
                    col = "";
                }
                maxWidths.set(j, Math.max((Integer)maxWidths.get(j), col.length()));
            }
        }
        return maxWidths;
    }

    private static String padRight(String s, int n) {
        return String.format("%-" + n + "s", s);
    }

    public static String checkValidSchemas(String schs, ScriptRunnerContext ctx) {
        try {
            if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() != null && ctx.getCurrentConnection().isClosed()) {
                return schs;
            }
            String query = "select count(*) from all_users where username = :schema";
            Object validSchemas = "";
            for (String usch : schs.split(",")) {
                HashMap<String, String> binds = new HashMap<String, String>();
                DBUtil dbUtil = DBUtil.getInstance((Connection)ctx.getCurrentConnection());
                try {
                    usch = usch.toUpperCase();
                }
                catch (Exception e) {
                    usch = ProjectConfig.getCurrentContext().getCurrentConnection().getSchema();
                }
                binds.put("schema", usch);
                String count = dbUtil.executeOracleReturnOneCol(query, binds);
                if (count == null || Integer.parseInt(count) <= 0) continue;
                validSchemas = (String)validSchemas + usch + ",";
            }
            if (!((String)validSchemas).isEmpty()) {
                validSchemas = ((String)validSchemas).substring(0, ((String)validSchemas).lastIndexOf(","));
            }
            return validSchemas;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<Connection> displayErrorMessageForConnectionStatusOrConnectAutomatically(ScriptRunnerContext ctx, boolean verbose) throws Exception {
        String settingConnectionName = ProjectSettings.getSettingAsString("sqlcl.connectionName");
        boolean autoConnect = ProjectSettings.getSettingAsBoolean("sqlcl.autoConnect");
        String currentConnectionName = NamedConnections.getCurrentConnectionName();
        if (settingConnectionName == null || settingConnectionName.isEmpty()) {
            if (autoConnect) {
                GeneralMessages.errorMessage(ProjectMessages.getString("PROJECTCONNECTION_AUTOCONNECT_NOCONNECTIONNAME"));
            } else {
                GeneralMessages.warnMessage(ProjectMessages.getString("PROJECTCONNECTION_NOAUTOCONNECT_NOCONNECTIONNAME"));
            }
            return Optional.ofNullable(ctx.getCurrentConnection());
        }
        if (currentConnectionName == null || currentConnectionName.isEmpty()) {
            if (autoConnect) {
                GeneralMessages.generalMessage(ProjectMessages.format("PROJECTCONNECTION_AUTOCONNECT_CONNECTIONNAME", settingConnectionName));
                return Optional.ofNullable(ProjectUtils.getConnection(ctx, verbose));
            }
            GeneralMessages.generalMessage(ProjectMessages.format("PROJECTCONNECTION_NOAUTOCONNECT_CONNECTIONNAME", settingConnectionName));
            return Optional.ofNullable(ctx.getCurrentConnection());
        }
        if (!currentConnectionName.equals(settingConnectionName)) {
            if (autoConnect) {
                ConnectionsSupport support = ConnectionsSupport.builder().build();
                try {
                    GeneralMessages.generalMessage(ProjectMessages.format("PROJECTCONNECTION_AUTOCONNECT_CONNECTIONNAME_SWITCH", settingConnectionName));
                    Connection newConnection = support.openConnection(settingConnectionName);
                    ((ConnectionContext)ctx.getService(ConnectionContext.class)).getCurrentPropertyValues().setValueOf((Property)NamedConnectionProperty.NAME, (Object)settingConnectionName);
                    return Optional.ofNullable(newConnection);
                }
                catch (SQLException e) {
                    GeneralMessages.errorMessage(ProjectMessages.format("PROJECTCONNECTION_CONNECTION_ERROR", settingConnectionName, e));
                    return Optional.ofNullable(ctx.getCurrentConnection());
                }
            }
            GeneralMessages.warnMessage(ProjectMessages.format("PROJECTCONNECTION_NOAUTOCONNECT_CONNECTIONNAME_SWITCH", settingConnectionName));
            return Optional.ofNullable(ctx.getCurrentConnection());
        }
        Optional<Connection> currentConnection = Optional.ofNullable(ctx.getCurrentConnection());
        if (currentConnection.isPresent()) {
            GeneralMessages.generalMessage(ProjectMessages.format("PROJECTCONNECTION_CURRENT_CONNECTION", currentConnection.get().getSchema()));
        }
        return currentConnection;
    }
}

