/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.util.Map;
import oracle.dbtools.app.Persist2XML;
import oracle.dbtools.extension.project.commands.export.ExportMessages;
import oracle.dbtools.extension.project.commands.export.Report;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.parser.plsql.SyntaxError;

public class Format {
    private static oracle.dbtools.app.Format format = null;

    public static String format(String input) {
        try {
            return Format.format_(input);
        }
        catch (SyntaxError e) {
            Report.debug(ProjectConfig.getCurrentContext(), "Format failed " + e.getMessage());
            return input;
        }
        catch (Exception e) {
            Report.warning(ProjectConfig.getCurrentContext(), e);
            return input;
        }
    }

    public static String format_(String input) throws Exception {
        if (format == null) {
            return input;
        }
        return format.format(input);
    }

    public static void init(boolean isVerifyCommand) throws Exception {
        String emsg = ExportMessages.getString("EXPORT_PROJECT_NOT_IDENTIFIED");
        try {
            File f;
            Object projectPath;
            Path path = ProjectConfig.getCurrentWorkingProjectRoot();
            if (path == null) {
                throw new AssertionError((Object)emsg);
            }
            if (!ProjectSettings.getSettingAsBoolean("export.format.enable").booleanValue()) {
                format = null;
                return;
            }
            if (format == null) {
                format = new oracle.dbtools.app.Format();
            }
            Object object = projectPath = ProjectConfig.getCurrentWorkingProjectRoot() != null ? ProjectConfig.getCurrentWorkingProjectRoot().toString() : "";
            if (((String)projectPath).isEmpty()) {
                return;
            }
            if (!((String)projectPath).endsWith("/")) {
                projectPath = (String)projectPath + "/";
            }
            if ((f = new File((String)projectPath + File.separator + ".dbtools" + File.separator + "project.sqlformat.xml")).exists()) {
                FileInputStream fis = new FileInputStream(f);
                Map options = Persist2XML.read((FileInputStream)fis);
                format.verifyOptions(options, isVerifyCommand);
                format.setOptions(options);
            } else {
                Report.error(ProjectConfig.getCurrentContext(), "project.sqlformat.xml not found");
                format = null;
            }
        }
        catch (AssertionError e) {
            if (!emsg.equals(((Throwable)((Object)e)).getMessage())) {
                Report.error(ProjectConfig.getCurrentContext(), ((Throwable)((Object)e)).getMessage());
            }
            format = null;
        }
        catch (Throwable e) {
            Report.error(ProjectConfig.getCurrentContext(), e.getMessage());
            format = null;
        }
    }
}

