/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.utils;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.dbtools.extension.project.commands.UtilMessages;
import oracle.dbtools.extension.project.commands.export.DbmsMetadata;
import oracle.dbtools.extension.project.commands.stage.StageMessages;
import oracle.dbtools.extension.project.commands.stage.objectclasses.DbDiffObject;
import oracle.dbtools.extension.project.commands.stage.transforms.ObjectTypes;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ChangelogGenerationException;
import oracle.dbtools.extension.project.core.exceptions.CreateFileException;
import oracle.dbtools.extension.project.core.exceptions.StageProcessException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.utils.ConsoleColors;
import oracle.dbtools.extension.project.core.utils.Format;
import oracle.dbtools.extension.project.core.utils.GitUtils;
import oracle.dbtools.extension.project.core.utils.ProjectFileUtils;
import oracle.dbtools.extension.project.core.utils.ProjectUtils;
import oracle.dbtools.extension.project.core.utils.XMLFormatter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jgit.api.Git;

public class StageConstants {
    public static final String ADD = "ADD";
    public static final String MODIFY = "MODIFY";
    public static final String DELETE = "DELETE";
    public static final String CHANGESET_STRIP_COMMENTS_FALSE = "-- changeset.*stripComments:false";
    public static final String SNAPSHOT = "-- sqlcl_snapshot";
    protected static final String LIQUIBASE_FORMATTED_SQL = "-- liquibase formatted sql";
    protected static final String CHANGESET = "-- changeset ";
    protected static final String STRIP_COMMENTS = " stripComments:false ";
    protected static final String LOGICAL_FILE_PATH = " logicalFilePath:";
    protected static final String SQLCL_SNAPSHOT = "-- sqlcl_snapshot ";
    protected static final String ENDXML = "<!--CHANGES-->";
    protected static final String ENDSQL = "--CHANGES";
    protected static final String RUNALWAYS = " runAlways:";
    protected static final String RUNONCHANGE = " runOnChange:";
    protected static final String FAILONERROR = " failOnError:";
    protected static final String SCHEMAS = "%SCHEMAS%";
    protected static final String CURRENT_VERSION = "%CURRENT_VERSION%";
    protected static final String APEX = "APEX";
    protected static final String ORDS = "ORDS";
    protected static final String EMIT_SCHEMA = "export.setTransform.emitSchema";
    protected static final String TABLESPACE = "export.setTransform.tablespace";
    protected static final String SEGMENT_ATTRIBUTES = "export.setTransform.segmentAttributes";
    protected static final String STORAGE = "export.setTransform.storage";
    protected static final String REF_CONSTRAINTS = "export.setTransform.refConstraints";
    protected static final String CONSTRAINTS_AS_ALTERS = "export.setTransform.constraintsAsAlters";
    protected static final String CONSTRAINTS = "export.setTransform.constraints";
    protected static final String DATABASE_CHANGE_LOG = "</databaseChangeLog>";
    protected static final ArrayList<String> excludedSchemas = new ArrayList();
    protected static final HashMap<String, List<String>> excludedObjects = new HashMap();
    protected static final HashMap<String, List<String>> excludedApexs = new HashMap();
    protected static final ArrayList<String> excludedOrds = new ArrayList();

    private StageConstants() {
    }

    public static Path getDiffPath(String objPath, String schema, String type, String fileName) {
        return Paths.get(objPath, schema.toLowerCase(), ObjectTypes.plural(type).toLowerCase(), fileName.toLowerCase());
    }

    public static void debugMessageWithPrettySxmlFormat(String branchSxml, String masterSxml, String alterDdl) {
        try {
            boolean ignoreDeclaration = true;
            GeneralMessages.debugMessage(StageMessages.format("CAN_NOT_GET_ALTER_DDL_DBEUG", XMLFormatter.prettyFormat(branchSxml, "UTF-8", true), XMLFormatter.prettyFormat(masterSxml, "UTF-8", true), alterDdl));
        }
        catch (Exception e) {
            GeneralMessages.debugException(e);
        }
    }

    public static Connection getConnection() throws ChangelogGenerationException {
        Connection conn = ProjectUtils.getConnection(ProjectConfig.getCurrentContext(), false);
        if (conn == null) {
            throw new ChangelogGenerationException(StageMessages.getString("BAD_CONNECTION"));
        }
        return conn;
    }

    public static String applyFormatting(String statement) {
        if (1000000 < statement.length()) {
            return statement;
        }
        return Format.format(statement);
    }

    public static String getChangeEnd() {
        if (StageConstants.isSqlStage()) {
            return ENDSQL;
        }
        return ENDXML;
    }

    public static String cleanInput(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        String cleaned = input;
        int removed = 0;
        for (int i = 0; i < 3; ++i) {
            if (!cleaned.endsWith("\n")) continue;
            cleaned = cleaned.substring(0, cleaned.length() - 1);
            ++removed;
        }
        if (removed == 3) {
            return cleaned;
        }
        return input;
    }

    public static String getSha1fromString(String data) throws StageProcessException {
        String ddl;
        if (data != null && data.contains(SNAPSHOT)) {
            ddl = data.substring(0, data.indexOf(SNAPSHOT));
            ddl = StageConstants.cleanInput(ddl);
        } else {
            ddl = data;
        }
        try {
            return DbmsMetadata.generateHash(ddl);
        }
        catch (Exception e) {
            throw new StageProcessException(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public static String getGuid() {
        long epochMilli = System.currentTimeMillis();
        return String.valueOf(epochMilli);
    }

    public static boolean isSqlStage() {
        return StageConstants.isSqlStage(false);
    }

    public static boolean isReleaseIsolation() {
        String isolation = ProjectSettings.getSettingAsString("stage.softObjectIsolation");
        return isolation != null && isolation.equals("release");
    }

    public static boolean isChangeIsolation() {
        String isolation = ProjectSettings.getSettingAsString("stage.softObjectIsolation");
        return isolation != null && isolation.equals("change");
    }

    public static boolean isSqlStage(boolean withOutput) {
        String genModel = ProjectSettings.getSettingAsString("stage.generatedFormat");
        if (genModel.equalsIgnoreCase("LIQUIBASE")) {
            return false;
        }
        if (genModel.equalsIgnoreCase("SQL")) {
            return true;
        }
        if (withOutput) {
            GeneralMessages.warnMessage(ConsoleColors.YELLOW, StageMessages.format("INVALID_OUTPUT_TYPE", genModel, "stage.generatedFormat"));
        }
        return false;
    }

    public static boolean isCorrectInstallFile(String script, String format) throws CreateFileException {
        if (script != null && !script.isEmpty()) {
            boolean found;
            if ("LIQUIBASE".equalsIgnoreCase(format)) {
                String regex = "(?:lb|liquibase).*?-changelog-file\\s+releases/main\\.changelog\\.xml.*";
                found = Pattern.compile(regex).matcher(script).find();
            } else if ("SQL".equalsIgnoreCase(format)) {
                String regex = Pattern.quote("@releases/main.changelog.sql");
                found = Pattern.compile(regex).matcher(script).find();
            } else {
                throw new CreateFileException(StageMessages.format("INVALID_STAGE_FORMAT", ProjectSettings.getSettingAsString("stage.generatedFormat")));
            }
            return found;
        }
        return true;
    }

    public static String getGitBranch() throws IOException, InterruptedException, StageProcessException {
        try (Git git = GitUtils.findGitRepo(ProjectConfig.getCurrentWorkingProjectRoot().toFile());){
            if (git == null) {
                throw new StageProcessException(StageMessages.get("GIT_NOT_FOUND"));
            }
            String string = git.getRepository().getBranch();
            return string;
        }
    }

    public static boolean filesAreDifferent(Path dest, String content) throws IOException {
        int checksum2;
        if (!dest.toFile().exists()) {
            return true;
        }
        String destin = FileUtils.readFileToString((File)dest.toFile(), (Charset)StandardCharsets.UTF_8).replaceAll(CHANGESET_STRIP_COMMENTS_FALSE, "");
        int checksum = destin.hashCode();
        return checksum != (checksum2 = content.replaceAll(CHANGESET_STRIP_COMMENTS_FALSE, "").hashCode());
    }

    public static boolean filesAreDifferent(Path src, Path dest) throws IOException {
        int checksum2;
        if (!dest.toFile().exists()) {
            return true;
        }
        String source = FileUtils.readFileToString((File)src.toFile(), (Charset)StandardCharsets.UTF_8).replaceAll(CHANGESET_STRIP_COMMENTS_FALSE, "");
        String destin = FileUtils.readFileToString((File)dest.toFile(), (Charset)StandardCharsets.UTF_8).replaceAll(CHANGESET_STRIP_COMMENTS_FALSE, "");
        int checksum = source.hashCode();
        return checksum != (checksum2 = destin.hashCode());
    }

    public static Path getGitRootPath() throws IOException, InterruptedException, StageProcessException {
        try (Git git = GitUtils.findGitRepo(ProjectConfig.getCurrentWorkingProjectRoot().toFile());){
            if (git == null) {
                throw new StageProcessException(StageMessages.get("GIT_NOT_FOUND"));
            }
            Path path = git.getRepository().getDirectory().toPath().getParent();
            return path;
        }
    }

    public static Path getSrcFilePath(DbDiffObject entry) throws StageProcessException {
        try {
            Path gitRootPath = StageConstants.getGitRootPath();
            Path oldAbsolutePath = gitRootPath.resolve(entry.getDiffEntry().getOldPath());
            Path newAbsolutePath = gitRootPath.resolve(entry.getDiffEntry().getNewPath());
            if (!newAbsolutePath.toString().equals("/dev/null")) {
                return Paths.get(ProjectConfig.getCurrentWorkingProjectRoot().resolve(newAbsolutePath).toString(), new String[0]);
            }
            if (!oldAbsolutePath.toString().equals("/dev/null")) {
                return Paths.get(ProjectConfig.getCurrentWorkingProjectRoot().resolve(oldAbsolutePath).toString(), new String[0]);
            }
            throw new StageProcessException("BAD_SOURCE_PATH");
        }
        catch (Exception e) {
            throw new StageProcessException(e.getMessage());
        }
    }

    public static Path createFileUsingTemplate(Path directory, String fileName, String template) throws CreateFileException {
        return StageConstants.createFileUsingTemplate(directory, fileName, template, null);
    }

    public static Path createFileUsingTemplate(Path directory, String fileName, String template, Map<String, String> replaceStrings) throws CreateFileException {
        Path changelog = Paths.get(directory.toString(), fileName);
        if (Files.notExists(changelog, new LinkOption[0])) {
            if (FilenameUtils.getExtension((String)changelog.toString()).equalsIgnoreCase("xml")) {
                GeneralMessages.createChangeMsg(ProjectConfig.getCurrentWorkingProjectRoot().relativize(changelog).toString());
            } else {
                GeneralMessages.createFileMsg(ProjectConfig.getCurrentWorkingProjectRoot().relativize(changelog).toString());
            }
            try {
                ProjectFileUtils.createFileWithContent(changelog, ProjectFileUtils.getResourcesFileContent(Paths.get(template, new String[0])), replaceStrings);
            }
            catch (IOException e) {
                throw new CreateFileException(UtilMessages.format("FILE_CREATE_ERROR", ConsoleColors.RED.code, ConsoleColors.RESET.code, ProjectConfig.getCurrentWorkingProjectRoot().relativize(changelog).toString(), changelog, e));
            }
        }
        return changelog;
    }
}

