/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.generators;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import oracle.dbtools.extension.project.commands.stage.StageMessages;
import oracle.dbtools.extension.project.commands.stage.objectclasses.DbDiffObject;
import oracle.dbtools.extension.project.core.exceptions.MaterializedViewLogException;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import org.apache.commons.lang3.StringUtils;

public class DropDdlGenerator {
    private DropDdlGenerator() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getDrop(DbDiffObject entry) throws MaterializedViewLogException {
        StringBuilder sql = new StringBuilder();
        List<String> schedulerTypes = Arrays.asList("SCHEDULE", "PROGRAM", "JOB", "JOB_CLASS", "SCHEDULER_GROUP", "CHAIN");
        String apexTypes = "APEX_APPLICATIONS";
        if ("REF_CONSTRAINT".equalsIgnoreCase(entry.getObjectType())) {
            String dropsql = entry.getMasterFileContent().trim();
            dropsql = dropsql.substring(0, dropsql.indexOf("-- sqlcl_snapshot")).trim();
            dropsql = StringUtils.replaceIgnoreCase((String)dropsql, (String)"add", (String)"drop").trim();
            int loc = StringUtils.indexOfIgnoreCase((CharSequence)dropsql, (CharSequence)"FOREIGN KEY");
            sql.append(dropsql, 0, loc - 1);
        } else if (StringUtils.endsWithIgnoreCase((CharSequence)entry.getObjectType(), (CharSequence)"GRANT")) {
            String dropsql = entry.getMasterFileContent().trim();
            dropsql = dropsql.substring(0, dropsql.indexOf("-- sqlcl_snapshot")).trim();
            dropsql = StringUtils.replaceIgnoreCase((String)dropsql, (String)"grant", (String)"revoke").trim();
            dropsql = StringUtils.replaceIgnoreCase((String)dropsql, (String)"to", (String)"from").trim();
            sql.append(dropsql);
        } else if (StringUtils.endsWithIgnoreCase((CharSequence)entry.getObjectType(), (CharSequence)"MLE_MODULE")) {
            String dropsql = "DROP MLE MODULE \"" + entry.getSchema() + "\".\"" + entry.getObjectName() + "\"";
            sql.append(dropsql);
        } else if (StringUtils.endsWithIgnoreCase((CharSequence)entry.getObjectType(), (CharSequence)"MLE_ENV")) {
            String dropsql = "DROP MLE ENV \"" + entry.getSchema() + "\".\"" + entry.getObjectName() + "\"";
            sql.append(dropsql);
        } else if ("AQ_QUEUE".equalsIgnoreCase(entry.getObjectType())) {
            StringBuilder dropQPlSql = new StringBuilder();
            dropQPlSql.append("BEGIN\n").append("  SYS.DBMS_AQADM.DROP_QUEUE(QUEUE_NAME => '\"");
            if (Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.emitSchema"))) {
                dropQPlSql.append(entry.getSchema()).append("\".\"");
            }
            dropQPlSql.append(entry.getObjectName()).append("\"');\n").append("END;");
            sql.append((CharSequence)dropQPlSql);
        } else if ("AQ_QUEUE_TABLE".equalsIgnoreCase(entry.getObjectType())) {
            StringBuilder dropQTablePlSql = new StringBuilder();
            dropQTablePlSql.append("BEGIN\n").append("  SYS.DBMS_AQADM.DROP_QUEUE_TABLE(\n").append("    QUEUE_TABLE => '\"");
            if (Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.emitSchema"))) {
                dropQTablePlSql.append(entry.getSchema()).append("\".\"");
            }
            dropQTablePlSql.append(entry.getObjectName()).append("\"',\n").append("    FORCE       => FALSE  -- Set to TRUE to forcibly drop the table along with its queues\n").append("  );\n").append("END;");
            sql.append((CharSequence)dropQTablePlSql);
        } else if ("SYNONYM".equalsIgnoreCase(entry.getObjectType())) {
            if (entry.getSchema().equalsIgnoreCase("PUBLIC")) {
                sql.append("DROP PUBLIC SYNONYM \"").append(entry.getObjectName()).append("\"");
            } else {
                sql.append("DROP SYNONYM ").append("\"").append(entry.getSchema()).append("\".").append("\"").append(entry.getObjectName()).append("\"");
            }
        } else {
            if (schedulerTypes.contains(entry.getObjectType().toUpperCase())) {
                return DropDdlGenerator.getSchedulerDrop(entry);
            }
            if (apexTypes.contains(entry.getObjectType().toUpperCase())) {
                return DropDdlGenerator.getAPEXDrop(entry);
            }
            if ("COMMENT".contains(entry.getObjectType().toUpperCase())) {
                String entrySql = entry.getMasterFileContent();
                String dropCommentSql = entrySql.split(";")[0].replaceAll("(?is)is\\s*'[^']*'", "is ''");
                if (dropCommentSql.trim().endsWith(";")) return dropCommentSql;
                return dropCommentSql.trim() + ";";
            }
            StringBuilder dropStmt = new StringBuilder();
            dropStmt.append("DROP ");
            dropStmt.append(SchemaGenerator.typeNameTransform.getOrDefault(entry.getObjectType(), entry.getObjectType()).trim()).append(" ");
            if ("MATERIALIZED_VIEW_LOG".equals(entry.getObjectType().trim())) {
                dropStmt.append("ON ");
            }
            if (ProjectSettings.getSettingAsBoolean("export.setTransform.emitSchema") != null && ProjectSettings.getSettingAsBoolean("export.setTransform.emitSchema").booleanValue()) {
                dropStmt.append("\"").append(entry.getSchema()).append("\".");
            }
            if ("MATERIALIZED_VIEW_LOG".equals(entry.getObjectType().trim())) {
                if (entry.getMvLogDependentObjects().size() > 1) throw new MaterializedViewLogException(StageMessages.format("MATERIALIZED_VIEWS_LOG_EXCEPTION", new Object[0]));
                String baseObj = entry.getMvLogDependentObjects().get(0);
                dropStmt.append("\"").append(baseObj.toUpperCase()).append("\"");
            } else {
                dropStmt.append("\"").append(entry.getObjectName()).append("\"");
            }
            if ("TABLE".equals(entry.getObjectType())) {
                dropStmt.append(" CASCADE CONSTRAINTS");
            }
            if ("SQL_DOMAIN".equals(entry.getObjectType())) {
                dropStmt = new StringBuilder(StringUtils.replaceIgnoreCase((String)String.valueOf(dropStmt), (String)"sql_domain", (String)"DOMAIN"));
            }
            sql.append((CharSequence)dropStmt);
        }
        if (sql.toString().endsWith(";")) return sql.toString().trim();
        sql.append(";");
        return sql.toString().trim();
    }

    public static String getSchedulerDrop(DbDiffObject entry) {
        StringBuilder dropStmt = new StringBuilder();
        dropStmt.append("BEGIN\n").append("  DBMS_SCHEDULER.DROP_");
        String objectType = entry.getObjectType().toUpperCase();
        boolean emitSchema = Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.emitSchema"));
        if (!objectType.equals("SCHEDULER_GROUP")) {
            dropStmt.append(objectType).append("(\n").append("   ").append(objectType.toLowerCase()).append("_name => '\"");
            if (emitSchema) {
                dropStmt.append(entry.getSchema()).append("\".\"");
            }
            dropStmt.append(entry.getObjectName()).append("\"'\n").append("   --force => true -- Uncomment to forcibly drop the ").append(objectType.toLowerCase());
            if (objectType.equals("JOB")) {
                dropStmt.append("   --defer => true -- Either choose force or defer!\n");
            }
            dropStmt.append("\n);\n");
        } else {
            dropStmt.append("GROUP(\n").append("   group_name => '\"");
            if (emitSchema) {
                dropStmt.append(entry.getSchema()).append("\".\"");
            }
            dropStmt.append(entry.getObjectName()).append("\"'\n").append("   --force => true -- Uncomment to forcibly drop the scheduler_group\n").append(");\n");
        }
        dropStmt.append("END;\n/");
        return dropStmt.toString().trim();
    }

    public static String getAPEXDrop(DbDiffObject entry) {
        String APEXDropScript = "/oracle/dbtools/extension/project/commands/stage/templates/apex/dropApexScript.tmpl";
        String wsName = entry.getSchema().toUpperCase();
        String appId = entry.getObjectName().toLowerCase().substring(1);
        String template = null;
        try (InputStream inputStream = DropDdlGenerator.class.getResourceAsStream(APEXDropScript);){
            if (inputStream == null) {
                throw new RuntimeException(StageMessages.format("TEMPLATE_NOT_FOUND", APEXDropScript));
            }
            template = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(StageMessages.format("TEMPLATE_FAILED", APEXDropScript), e);
        }
        template = template.replace("&&wsName", wsName);
        template = template.replace("&&appId", appId);
        return template.trim();
    }
}

