/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.UpdateSchedulingPolicyDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateSchedulingPolicyRequest
extends BmcRequest<UpdateSchedulingPolicyDetails> {
    private String schedulingPolicyId;
    private UpdateSchedulingPolicyDetails updateSchedulingPolicyDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getSchedulingPolicyId() {
        return this.schedulingPolicyId;
    }

    public UpdateSchedulingPolicyDetails getUpdateSchedulingPolicyDetails() {
        return this.updateSchedulingPolicyDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateSchedulingPolicyDetails getBody$() {
        return this.updateSchedulingPolicyDetails;
    }

    public Builder toBuilder() {
        return new Builder().schedulingPolicyId(this.schedulingPolicyId).updateSchedulingPolicyDetails(this.updateSchedulingPolicyDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",schedulingPolicyId=").append(String.valueOf(this.schedulingPolicyId));
        sb.append(",updateSchedulingPolicyDetails=").append(String.valueOf((Object)this.updateSchedulingPolicyDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSchedulingPolicyRequest)) {
            return false;
        }
        UpdateSchedulingPolicyRequest other = (UpdateSchedulingPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.schedulingPolicyId, other.schedulingPolicyId) && Objects.equals((Object)this.updateSchedulingPolicyDetails, (Object)other.updateSchedulingPolicyDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.schedulingPolicyId == null ? 43 : this.schedulingPolicyId.hashCode());
        result = result * 59 + (this.updateSchedulingPolicyDetails == null ? 43 : this.updateSchedulingPolicyDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSchedulingPolicyRequest, UpdateSchedulingPolicyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String schedulingPolicyId = null;
        private UpdateSchedulingPolicyDetails updateSchedulingPolicyDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder schedulingPolicyId(String schedulingPolicyId) {
            this.schedulingPolicyId = schedulingPolicyId;
            return this;
        }

        public Builder updateSchedulingPolicyDetails(UpdateSchedulingPolicyDetails updateSchedulingPolicyDetails) {
            this.updateSchedulingPolicyDetails = updateSchedulingPolicyDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSchedulingPolicyRequest o) {
            this.schedulingPolicyId(o.getSchedulingPolicyId());
            this.updateSchedulingPolicyDetails(o.getUpdateSchedulingPolicyDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSchedulingPolicyRequest build() {
            UpdateSchedulingPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSchedulingPolicyDetails body) {
            this.updateSchedulingPolicyDetails(body);
            return this;
        }

        public UpdateSchedulingPolicyRequest buildWithoutInvocationCallback() {
            UpdateSchedulingPolicyRequest request = new UpdateSchedulingPolicyRequest();
            request.schedulingPolicyId = this.schedulingPolicyId;
            request.updateSchedulingPolicyDetails = this.updateSchedulingPolicyDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

