/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetScheduledActionRequest
extends BmcRequest<Void> {
    private String scheduledActionId;
    private String opcRequestId;

    public String getScheduledActionId() {
        return this.scheduledActionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().scheduledActionId(this.scheduledActionId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",scheduledActionId=").append(String.valueOf(this.scheduledActionId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetScheduledActionRequest)) {
            return false;
        }
        GetScheduledActionRequest other = (GetScheduledActionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.scheduledActionId, other.scheduledActionId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.scheduledActionId == null ? 43 : this.scheduledActionId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetScheduledActionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String scheduledActionId = null;
        private String opcRequestId = null;

        public Builder scheduledActionId(String scheduledActionId) {
            this.scheduledActionId = scheduledActionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetScheduledActionRequest o) {
            this.scheduledActionId(o.getScheduledActionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetScheduledActionRequest build() {
            GetScheduledActionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetScheduledActionRequest buildWithoutInvocationCallback() {
            GetScheduledActionRequest request = new GetScheduledActionRequest();
            request.scheduledActionId = this.scheduledActionId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

